/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.config;

import jakarta.jms.Connection;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerRegistry;
import org.apache.activemq.broker.BrokerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerPropertiesTest
extends TestCase {
    private static final transient Logger LOG = LoggerFactory.getLogger(BrokerPropertiesTest.class);

    public void testPropertiesFile() throws Exception {
        BrokerService broker = BrokerFactory.createBroker((String)"properties:org/apache/activemq/config/broker.properties");
        LOG.info("Created broker: " + broker);
        BrokerPropertiesTest.assertNotNull((Object)broker);
        BrokerPropertiesTest.assertEquals((String)"isUseJmx()", (boolean)false, (boolean)broker.isUseJmx());
        BrokerPropertiesTest.assertEquals((String)"isPersistent()", (boolean)false, (boolean)broker.isPersistent());
        BrokerPropertiesTest.assertEquals((String)"getBrokerName()", (String)"Cheese", (String)broker.getBrokerName());
        broker.stop();
    }

    public void testVmBrokerPropertiesFile() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost?brokerConfig=properties:org/apache/activemq/config/broker.properties");
        Connection connection = factory.createConnection();
        BrokerService broker = BrokerRegistry.getInstance().lookup("Cheese");
        LOG.info("Found broker : " + broker);
        BrokerPropertiesTest.assertNotNull((Object)broker);
        BrokerPropertiesTest.assertEquals((String)"isUseJmx()", (boolean)false, (boolean)broker.isUseJmx());
        BrokerPropertiesTest.assertEquals((String)"isPersistent()", (boolean)false, (boolean)broker.isPersistent());
        BrokerPropertiesTest.assertEquals((String)"getBrokerName()", (String)"Cheese", (String)broker.getBrokerName());
        connection.close();
        broker.stop();
    }
}

