/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.perf;

import jakarta.jms.Connection;
import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Consumer
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(Consumer.class);

    Consumer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Connection connection = null;
        Session session = null;
        TopicSubscriber consumer = null;
        try {
            ActiveMQConnectionFactory amq = new ActiveMQConnectionFactory("tcp://localhost:62616");
            connection = amq.createConnection();
            connection.setClientID("tmielke");
            connection.setExceptionListener(new ExceptionListener(){

                public void onException(JMSException e) {
                    e.printStackTrace();
                }
            });
            connection.start();
            session = connection.createSession(false, 1);
            Topic destination = session.createTopic("TEST.FOO");
            consumer = session.createDurableSubscriber(destination, "tmielke");
            long counter = 0L;
            for (int i = 0; i < 10000; ++i) {
                Message message2 = consumer.receive();
                if (message2 instanceof TextMessage) {
                    TextMessage textMessage = (TextMessage)message2;
                    textMessage.getText();
                } else {
                    LOG.error("Received message of unsupported type. Expecting TextMessage. " + message2);
                }
                if (++counter % 1000L != 0L) continue;
                LOG.info("received " + counter + " messages");
            }
        }
        catch (Exception e) {
            LOG.error("Error in Consumer: " + e);
            return;
        }
        finally {
            try {
                if (consumer != null) {
                    consumer.close();
                }
                if (session != null) {
                    session.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception ex) {
                LOG.error("Error closing down JMS objects: " + ex);
            }
        }
    }
}

