/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.perf;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Producer
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(Producer.class);

    Producer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Connection connection = null;
        Session session = null;
        MessageProducer producer = null;
        try {
            ActiveMQConnectionFactory amq = new ActiveMQConnectionFactory("tcp://localhost:61616");
            connection = amq.createConnection();
            connection.setExceptionListener(new ExceptionListener(){

                public void onException(JMSException e) {
                    e.printStackTrace();
                }
            });
            connection.start();
            session = connection.createSession(false, 1);
            Topic destination = session.createTopic("TEST.FOO");
            producer = session.createProducer((Destination)destination);
            producer.setDeliveryMode(2);
            long counter = 0L;
            for (int i = 0; i < 10000; ++i) {
                String text = "Hello world! From: " + Thread.currentThread().getName() + " : " + this.hashCode() + ":" + counter;
                TextMessage message = session.createTextMessage(text);
                producer.send((Message)message);
                if (++counter % 1000L != 0L) continue;
                LOG.info("sent " + counter + " messages");
            }
        }
        catch (Exception ex) {
            LOG.error(ex.toString());
            return;
        }
        finally {
            try {
                if (producer != null) {
                    producer.close();
                }
                if (session != null) {
                    session.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                LOG.error("Problem closing down JMS objects: " + e);
            }
        }
    }
}

