/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store;

import java.util.Random;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.IdGenerator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractMessageStoreSizeTest {
    protected static final IdGenerator id = new IdGenerator();
    protected ActiveMQQueue destination = new ActiveMQQueue("Test");
    protected ProducerId producerId = new ProducerId("1.1.1");
    protected static final int MESSAGE_COUNT = 20;
    protected static String dataDirectory = "target/test-amq-5748/datadb";
    protected static int testMessageSize = 1000;

    @Before
    public void init() throws Exception {
        this.initStore();
    }

    @After
    public void destroy() throws Exception {
        this.destroyStore();
    }

    protected abstract void initStore() throws Exception;

    protected abstract void destroyStore() throws Exception;

    @Test
    public void testMessageSize() throws Exception {
        this.writeMessages();
        long messageSize = this.getMessageStore().getMessageSize();
        Assert.assertTrue((this.getMessageStore().getMessageCount() == 20 ? 1 : 0) != 0);
        Assert.assertTrue((messageSize > (long)(20 * testMessageSize) ? 1 : 0) != 0);
    }

    protected void writeMessages() throws Exception {
        ConnectionContext context = new ConnectionContext();
        for (int i = 0; i < 20; ++i) {
            ActiveMQMessage message = new ActiveMQMessage();
            byte[] data = new byte[testMessageSize];
            Random rng = new Random();
            rng.nextBytes(data);
            message.setContent(new ByteSequence(data));
            message.setDestination((ActiveMQDestination)this.destination);
            message.setMessageId(new MessageId(id.generateId() + ":1", (long)i));
            this.getMessageStore().addMessage(context, (Message)message);
        }
    }

    protected abstract MessageStore getMessageStore();
}

