/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb;

import java.io.File;
import org.apache.activemq.store.AbstractMessageStoreSizeTest;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractKahaDBMessageStoreSizeTest
extends AbstractMessageStoreSizeTest {
    MessageStore messageStore;
    PersistenceAdapter store;

    @Override
    public void initStore() throws Exception {
        this.createStore(true, dataDirectory);
    }

    protected abstract void createStore(boolean var1, String var2) throws Exception;

    protected abstract String getVersion5Dir();

    @Override
    public void destroyStore() throws Exception {
        if (this.store != null) {
            this.store.stop();
        }
    }

    @Test
    public void testMessageSizeStoreRecovery() throws Exception {
        this.writeMessages();
        this.store.stop();
        this.createStore(false, dataDirectory);
        this.writeMessages();
        long messageSize = this.messageStore.getMessageSize();
        Assert.assertEquals((long)40L, (long)this.messageStore.getMessageCount());
        Assert.assertTrue((messageSize > (long)(40 * testMessageSize) ? 1 : 0) != 0);
    }

    @Test
    public void testMessageSizeStoreRecoveryVersion5() throws Exception {
        this.store.stop();
        File dataDir = new File(dataDirectory);
        if (dataDir.exists()) {
            FileUtils.deleteDirectory((File)new File(dataDirectory));
        }
        FileUtils.copyDirectory((File)new File(this.getVersion5Dir()), (File)dataDir);
        this.createStore(false, dataDirectory);
        long messageSize = this.messageStore.getMessageSize();
        Assert.assertTrue((this.messageStore.getMessageCount() == 20 ? 1 : 0) != 0);
        Assert.assertTrue((messageSize == 0L ? 1 : 0) != 0);
    }

    @Test
    public void testMessageSizeStoreRecoveryVersion5RebuildIndex() throws Exception {
        this.store.stop();
        File dataDir = new File(dataDirectory);
        if (dataDir.exists()) {
            FileUtils.deleteDirectory((File)new File(dataDirectory));
        }
        FileUtils.copyDirectory((File)new File(this.getVersion5Dir()), (File)dataDir);
        for (File index : FileUtils.listFiles((File)new File(dataDirectory), (IOFileFilter)new WildcardFileFilter("*.data"), (IOFileFilter)TrueFileFilter.INSTANCE)) {
            FileUtils.deleteQuietly((File)index);
        }
        this.createStore(false, dataDirectory);
        this.writeMessages();
        long messageSize = this.messageStore.getMessageSize();
        Assert.assertTrue((this.messageStore.getMessageCount() == 40 ? 1 : 0) != 0);
        Assert.assertTrue((messageSize > (long)(40 * testMessageSize) ? 1 : 0) != 0);
    }

    @Override
    protected MessageStore getMessageStore() {
        return this.messageStore;
    }
}

