/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.failover;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.Service;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.transport.TransportListener;
import org.apache.activemq.transport.mock.MockTransport;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.util.Wait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconnectTest
extends TestCase {
    public static final int MESSAGES_PER_ITTERATION = 10;
    public static final int WORKER_COUNT = 10;
    private static final Logger LOG = LoggerFactory.getLogger(ReconnectTest.class);
    private BrokerService bs;
    private URI tcpUri;
    private final AtomicInteger resumedCount = new AtomicInteger();
    private final AtomicInteger interruptedCount = new AtomicInteger();
    private Worker[] workers;

    public void testReconnects() throws Exception {
        for (int k = 1; k < 10; ++k) {
            int i;
            LOG.info("Test run: " + k);
            for (i = 0; i < 10; ++i) {
                int c = 0;
                for (int j = 0; j < 30 && (c = this.workers[i].iterations.getAndSet(0)) == 0; ++j) {
                    this.workers[i].assertNoErrors();
                    LOG.info("Test run " + k + ": Waiting for worker " + i + " to finish an iteration.");
                    Thread.sleep(1000L);
                }
                ReconnectTest.assertTrue((String)("Test run " + k + ": Worker " + i + " never completed an interation."), (c != 0 ? 1 : 0) != 0);
                this.workers[i].assertNoErrors();
            }
            LOG.info("Simulating transport error to cause reconnect.");
            for (i = 0; i < 10; ++i) {
                this.workers[i].failConnection();
            }
            ReconnectTest.assertTrue((String)"Timed out waiting for all connections to be interrupted.", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

                public boolean isSatisified() throws Exception {
                    LOG.debug("Test run waiting for connections to get interrupted.. at: " + ReconnectTest.this.interruptedCount.get());
                    return ReconnectTest.this.interruptedCount.get() == 10;
                }
            }, (long)TimeUnit.SECONDS.toMillis(60L)));
            ReconnectTest.assertTrue((String)"Timed out waiting for all connections to be resumed.", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

                public boolean isSatisified() throws Exception {
                    LOG.debug("Test run waiting for connections to get resumed.. at: " + ReconnectTest.this.resumedCount.get());
                    return ReconnectTest.this.resumedCount.get() >= 10;
                }
            }, (long)TimeUnit.SECONDS.toMillis(60L)));
            this.interruptedCount.set(0);
            this.resumedCount.set(0);
            for (i = 0; i < 10; ++i) {
                this.workers[i].iterations.set(0);
            }
            Thread.sleep(1000L);
        }
    }

    protected void setUp() throws Exception {
        this.bs = new BrokerService();
        this.bs.setPersistent(false);
        this.bs.setUseJmx(true);
        TransportConnector connector = this.bs.addConnector("tcp://localhost:0");
        this.bs.start();
        this.tcpUri = connector.getConnectUri();
        this.workers = new Worker[10];
        for (int i = 0; i < 10; ++i) {
            this.workers[i] = new Worker("" + i);
            this.workers[i].start();
        }
    }

    protected void tearDown() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.workers[i].stop();
        }
        new ServiceStopper().stop((Service)this.bs);
    }

    class Worker
    implements Runnable {
        public AtomicInteger iterations = new AtomicInteger();
        public CountDownLatch stopped = new CountDownLatch(1);
        private final ActiveMQConnection connection;
        private final AtomicBoolean stop = new AtomicBoolean(false);
        private Throwable error;
        private final String name;

        public Worker(final String name) throws URISyntaxException, JMSException {
            this.name = name;
            URI uri = new URI("failover://(mock://(" + ReconnectTest.this.tcpUri + "))?updateURIsSupported=false");
            ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(uri);
            this.connection = (ActiveMQConnection)factory.createConnection();
            this.connection.addTransportListener(new TransportListener(){

                public void onCommand(Object command) {
                }

                public void onException(IOException error) {
                    Worker.this.setError(error);
                }

                public void transportInterupted() {
                    LOG.info("Worker " + name + " was interrupted...");
                    ReconnectTest.this.interruptedCount.incrementAndGet();
                }

                public void transportResumed() {
                    LOG.info("Worker " + name + " was resummed...");
                    ReconnectTest.this.resumedCount.incrementAndGet();
                }
            });
            this.connection.start();
        }

        public void failConnection() {
            MockTransport mockTransport = (MockTransport)this.connection.getTransportChannel().narrow(MockTransport.class);
            mockTransport.onException(new IOException("Simulated error"));
        }

        public void start() {
            new Thread(this).start();
        }

        public void stop() {
            this.stop.set(true);
            try {
                if (!this.stopped.await(5L, TimeUnit.SECONDS)) {
                    this.connection.close();
                    this.stopped.await(5L, TimeUnit.SECONDS);
                } else {
                    this.connection.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ActiveMQQueue queue = new ActiveMQQueue("FOO_" + this.name);
                Session session = this.connection.createSession(false, 1);
                MessageConsumer consumer = session.createConsumer((Destination)queue);
                MessageProducer producer = session.createProducer((Destination)queue);
                producer.setDeliveryMode(2);
                while (!this.stop.get()) {
                    int i;
                    for (i = 0; i < 10; ++i) {
                        producer.send((Message)session.createTextMessage("TEST:" + i));
                    }
                    for (i = 0; i < 10; ++i) {
                        consumer.receive();
                    }
                    this.iterations.incrementAndGet();
                }
                session.close();
            }
            catch (JMSException e) {
                this.setError(e);
            }
            finally {
                this.stopped.countDown();
            }
        }

        public synchronized Throwable getError() {
            return this.error;
        }

        public synchronized void setError(Throwable error) {
            this.error = error;
        }

        public synchronized void assertNoErrors() {
            if (this.error != null) {
                this.error.printStackTrace();
                TestCase.fail((String)("Worker " + this.name + " got Exception: " + this.error));
            }
        }
    }
}

