/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.vm;

import jakarta.jms.Connection;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerRegistry;
import org.apache.activemq.broker.PublishedAddressPolicy;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.transport.TransportListener;
import org.junit.Assert;
import org.junit.Test;

public class VMTransportBrokerNameTest {
    private static final String MY_BROKER = "myBroker";
    final String vmUrl = "vm:(broker:(tcp://localhost:61616)/myBroker?persistent=false)";

    @Test
    public void testBrokerName() throws Exception {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(new URI("vm:(broker:(tcp://localhost:61616)/myBroker?persistent=false)"));
        ActiveMQConnection c1 = (ActiveMQConnection)cf.createConnection();
        Assert.assertTrue((String)("Transport has name in it: " + c1.getTransport()), (boolean)c1.getTransport().toString().contains(MY_BROKER));
        ActiveMQConnectionFactory cfbyName = new ActiveMQConnectionFactory(new URI("vm://myBroker?create=false"));
        Connection c2 = cfbyName.createConnection();
        Assert.assertNotNull((Object)BrokerRegistry.getInstance().lookup(MY_BROKER));
        Assert.assertEquals((Object)BrokerRegistry.getInstance().findFirst().getBrokerName(), (Object)MY_BROKER);
        Assert.assertEquals((long)BrokerRegistry.getInstance().getBrokers().size(), (long)1L);
        c1.close();
        c2.close();
    }

    @Test
    public void testPublishableAddressUri() throws Exception {
        PublishedAddressPolicy publishedAddressPolicy = new PublishedAddressPolicy();
        final AtomicReference<URI> uriAtomicReference = new AtomicReference<URI>();
        TransportConnector dummyTransportConnector = new TransportConnector(){

            public URI getConnectUri() throws IOException, URISyntaxException {
                return (URI)uriAtomicReference.get();
            }
        };
        URI ok = new URI("vm://b1");
        uriAtomicReference.set(ok);
        Assert.assertEquals(uriAtomicReference.get(), (Object)publishedAddressPolicy.getPublishableConnectURI(dummyTransportConnector));
        ok = new URI("vm://b1?async=false");
        uriAtomicReference.set(ok);
        Assert.assertEquals(uriAtomicReference.get(), (Object)publishedAddressPolicy.getPublishableConnectURI(dummyTransportConnector));
        URI badHost = new URI("vm://b1_11");
        uriAtomicReference.set(badHost);
        Assert.assertEquals(uriAtomicReference.get(), (Object)publishedAddressPolicy.getPublishableConnectURI(dummyTransportConnector));
    }

    @Test
    public void testBrokerInfoReceiptClientAsync() throws Exception {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(new URI("vm:(broker:(tcp://localhost:61616)/myBroker?persistent=false)"));
        ActiveMQConnection c1 = (ActiveMQConnection)cf.createConnection();
        int numIterations = 400;
        final CountDownLatch successLatch = new CountDownLatch(400);
        ExecutorService executor = Executors.newFixedThreadPool(100);
        for (int i = 0; i < 400; ++i) {
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        VMTransportBrokerNameTest.this.verifyBrokerInfo(successLatch);
                    }
                    catch (Exception ignored) {
                        ignored.printStackTrace();
                    }
                }
            });
        }
        executor.shutdown();
        executor.awaitTermination(20L, TimeUnit.SECONDS);
        c1.close();
        Assert.assertTrue((String)("all success: " + successLatch.getCount()), (boolean)successLatch.await(1L, TimeUnit.SECONDS));
    }

    public void verifyBrokerInfo(CountDownLatch success) throws Exception {
        final CountDownLatch gotBrokerInfo = new CountDownLatch(1);
        Transport transport = TransportFactory.connect((URI)new URI("vm://myBroker?async=false"));
        transport.setTransportListener(new TransportListener(){

            public void onCommand(Object command) {
                if (command instanceof BrokerInfo) {
                    gotBrokerInfo.countDown();
                }
            }

            public void onException(IOException error) {
            }

            public void transportInterupted() {
            }

            public void transportResumed() {
            }
        });
        transport.start();
        if (gotBrokerInfo.await(5L, TimeUnit.SECONDS)) {
            success.countDown();
        }
        transport.stop();
    }
}

