/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import jakarta.jms.Destination;
import jakarta.jms.MessageConsumer;
import java.io.File;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import org.apache.activemq.JmsMultipleBrokersTestSupport;
import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.DurableTopicSubscription;
import org.apache.activemq.broker.region.Topic;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.network.DiscoveryNetworkConnector;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ6366Test
extends JmsMultipleBrokersTestSupport {
    protected static final Logger LOG = LoggerFactory.getLogger(AMQ6366Test.class);
    final ActiveMQTopic dest = new ActiveMQTopic("TEST.FOO");

    public void testDuplexDurableSubRestarted() throws Exception {
        this.testNonDurableReceiveThrougRestart("BrokerA", "BrokerB");
    }

    public void testDuplexDurableSubRestartedReverse() throws Exception {
        this.testNonDurableReceiveThrougRestart("BrokerB", "BrokerA");
    }

    protected void testNonDurableReceiveThrougRestart(String pubBroker, String conBroker) throws Exception {
        NetworkConnector networkConnector = this.bridgeBrokerPair("BrokerA", "BrokerB");
        this.startAllBrokers();
        this.waitForBridgeFormation();
        MessageConsumer client = this.createDurableSubscriber(conBroker, (jakarta.jms.Topic)this.dest, "sub1");
        client.close();
        Thread.sleep(1000L);
        networkConnector.stop();
        Thread.sleep(1000L);
        HashSet<ActiveMQTopic> durableDests = new HashSet<ActiveMQTopic>();
        durableDests.add(this.dest);
        networkConnector.setDurableDestinations(durableDests);
        networkConnector.start();
        this.waitForBridgeFormation();
        this.sendMessages(pubBroker, (Destination)this.dest, 1);
        Thread.sleep(1000L);
        Topic destination = (Topic)((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)conBroker)).broker.getDestination((ActiveMQDestination)this.dest);
        DurableTopicSubscription sub = destination.getDurableTopicSubs().values().toArray(new DurableTopicSubscription[0])[0];
        AMQ6366Test.assertEquals((long)1L, (long)sub.getSubscriptionStatistics().getEnqueues().getCount());
    }

    @Override
    protected void configureBroker(BrokerService broker) {
        broker.getManagementContext().setCreateConnector(false);
        broker.setAdvisorySupport(true);
    }

    protected NetworkConnector bridgeBrokerPair(String localBrokerName, String remoteBrokerName) throws Exception {
        BrokerService localBroker = ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)localBrokerName)).broker;
        BrokerService remoteBroker = ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)remoteBrokerName)).broker;
        List transportConnectors = remoteBroker.getTransportConnectors();
        if (!transportConnectors.isEmpty()) {
            URI remoteURI = ((TransportConnector)transportConnectors.get(0)).getConnectUri();
            String uri = "static:(" + remoteURI + ")";
            DiscoveryNetworkConnector connector = new DiscoveryNetworkConnector(new URI(uri));
            connector.setDynamicOnly(false);
            connector.setStaticBridge(false);
            connector.setDuplex(true);
            connector.addDynamicallyIncludedDestination((ActiveMQDestination)this.dest);
            localBroker.addNetworkConnector((NetworkConnector)connector);
            return connector;
        }
        throw new Exception("Remote broker has no registered connectors.");
    }

    @Override
    public void setUp() throws Exception {
        File dataDir = new File(IOHelper.getDefaultDataDirectory());
        LOG.info("Delete dataDir.." + dataDir.getCanonicalPath());
        TestSupport.recursiveDelete(dataDir);
        super.setAutoFail(true);
        super.setUp();
        this.createBroker(new URI("broker:(tcp://0.0.0.0:0)/BrokerA"));
        this.createBroker(new URI("broker:(tcp://0.0.0.0:0)/BrokerB"));
    }
}

