/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DurableSubProcessWithRestartTest {
    private static final Logger LOG = LoggerFactory.getLogger(DurableSubProcessWithRestartTest.class);
    public static final long RUNTIME = 300000L;
    public static final int SERVER_SLEEP = 2000;
    public static final int CARGO_SIZE = 400;
    public static final int MAX_CLIENTS = 5;
    public static final Random CLIENT_LIFETIME = new Random(5000, 10000);
    public static final Random CLIENT_ONLINE = new Random(2000, 2000);
    public static final Random CLIENT_OFFLINE = new Random(10000, 10000);
    public static final Persistence PERSISTENT_ADAPTER = Persistence.KAHADB;
    public static final long BROKER_RESTART = 10000L;
    public static final boolean ALLOW_SUBSCRIPTION_ABANDONMENT = true;
    public static final boolean CHECK_REDELIVERY = true;
    private BrokerService broker;
    private ActiveMQTopic topic;
    private ClientManager clientManager;
    private Server server;
    private HouseKeeper houseKeeper;
    private final ReentrantReadWriteLock processLock = new ReentrantReadWriteLock(true);
    private int restartCount = 0;
    static final Vector<Throwable> exceptions = new Vector();

    @Ignore(value="covered by org.apache.activemq.usecases.DurableSubscriptionOfflineTest.testNoMissOnMatchingSubAfterRestart()")
    @Test
    public void testProcess() {
        try {
            long now;
            this.server.start();
            this.clientManager.start();
            this.houseKeeper.start();
            long end = System.currentTimeMillis() + 300000L;
            while ((now = System.currentTimeMillis()) <= end) {
                now = (now = end - now) < 10000L ? now : 10000L;
                Thread.sleep(now);
                this.restartBroker();
            }
        }
        catch (Throwable e) {
            DurableSubProcessWithRestartTest.exit("ProcessTest.testProcess failed.", e);
        }
        this.processLock.writeLock().lock();
        Assert.assertTrue((String)("no exceptions: " + exceptions), (boolean)exceptions.isEmpty());
        LOG.info("DONE.");
    }

    private void restartBroker() throws Exception {
        LOG.info("Broker restart: waiting for components.");
        this.processLock.writeLock().lock();
        try {
            this.destroyBroker();
            this.startBroker(false);
            ++this.restartCount;
            LOG.info("Broker restarted. count: " + this.restartCount);
        }
        finally {
            this.processLock.writeLock().unlock();
        }
    }

    public static int random(int max) {
        return (int)(Math.random() * (double)(max + 1));
    }

    public static int random(int min, int max) {
        return DurableSubProcessWithRestartTest.random(max - min) + min;
    }

    public static void sleepRandom(int maxMillis) throws InterruptedException {
        Thread.sleep(DurableSubProcessWithRestartTest.random(maxMillis));
    }

    public static void sleepRandom(int minMillis, int maxMillis) throws InterruptedException {
        Thread.sleep(DurableSubProcessWithRestartTest.random(minMillis, maxMillis));
    }

    public static void exit(String message) {
        DurableSubProcessWithRestartTest.exit(message, null);
    }

    public static void exit(String message, Throwable e) {
        RuntimeException cause = new RuntimeException(message, e);
        LOG.error(message, (Throwable)cause);
        exceptions.add(cause);
        Assert.fail((String)cause.toString());
    }

    @Before
    public void setUp() throws Exception {
        this.topic = new ActiveMQTopic("TopicT");
        this.startBroker();
        this.clientManager = new ClientManager();
        this.server = new Server();
        this.houseKeeper = new HouseKeeper();
    }

    @After
    public void tearDown() throws Exception {
        this.destroyBroker();
    }

    private void startBroker() throws Exception {
        this.startBroker(true);
    }

    private void startBroker(boolean deleteAllMessages) throws Exception {
        if (this.broker != null) {
            return;
        }
        this.broker = BrokerFactory.createBroker((String)("broker:(vm://" + DurableSubProcessWithRestartTest.getName() + ")"));
        this.broker.setBrokerName(DurableSubProcessWithRestartTest.getName());
        this.broker.setAdvisorySupport(false);
        this.broker.setDeleteAllMessagesOnStartup(deleteAllMessages);
        switch (PERSISTENT_ADAPTER) {
            case MEMORY: {
                this.broker.setPersistent(false);
                break;
            }
            case KAHADB: {
                File kahadbData = new File("activemq-data/" + DurableSubProcessWithRestartTest.getName() + "-kahadb");
                if (deleteAllMessages) {
                    DurableSubProcessWithRestartTest.delete(kahadbData);
                }
                this.broker.setPersistent(true);
                KahaDBPersistenceAdapter kahadb = new KahaDBPersistenceAdapter();
                kahadb.setDirectory(kahadbData);
                kahadb.setJournalMaxFileLength(0x500000);
                this.broker.setPersistenceAdapter((PersistenceAdapter)kahadb);
            }
        }
        this.broker.addConnector("tcp://localhost:61656");
        this.broker.getSystemUsage().getMemoryUsage().setLimit(0x10000000L);
        this.broker.getSystemUsage().getTempUsage().setLimit(0x10000000L);
        this.broker.getSystemUsage().getStoreUsage().setLimit(0x10000000L);
        this.broker.start();
    }

    protected static String getName() {
        return "DurableSubProcessWithRestartTest";
    }

    private static boolean delete(File path) {
        if (path == null) {
            return true;
        }
        if (path.isDirectory()) {
            for (File file : path.listFiles()) {
                DurableSubProcessWithRestartTest.delete(file);
            }
        }
        return path.delete();
    }

    private void destroyBroker() throws Exception {
        if (this.broker == null) {
            return;
        }
        this.broker.stop();
        this.broker = null;
    }

    final class Server
    extends Thread {
        final String url;
        final ConnectionFactory cf;
        final Object sendMutex;
        final String[] cargos;
        int transRover;
        int messageRover;

        public Server() {
            super("Server");
            this.url = "vm://" + DurableSubProcessWithRestartTest.getName() + "?jms.redeliveryPolicy.maximumRedeliveries=2&jms.redeliveryPolicy.initialRedeliveryDelay=500&jms.producerWindowSize=20971520&jms.prefetchPolicy.all=100&jms.copyMessageOnSend=false&jms.disableTimeStampsByDefault=false&jms.alwaysSyncSend=true&jms.dispatchAsync=false&jms.watchTopicAdvisories=false&waitForStart=200&create=false";
            this.cf = new ActiveMQConnectionFactory(this.url);
            this.sendMutex = new Object();
            this.cargos = new String[500];
            this.transRover = 0;
            this.messageRover = 0;
            this.setDaemon(true);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            try {
                while (true) lbl-1000:
                // 3 sources

                {
                    DurableSubProcessWithRestartTest.sleepRandom(2000);
                    DurableSubProcessWithRestartTest.this.processLock.readLock().lock();
                    try {
                        this.send();
                    }
                    finally {
                        DurableSubProcessWithRestartTest.this.processLock.readLock().unlock();
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable e) {
                DurableSubProcessWithRestartTest.exit("Server.run failed", e);
                return;
            }
            ** GOTO lbl-1000
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send() throws JMSException {
            Object object = this.sendMutex;
            synchronized (object) {
                int trans = ++this.transRover;
                boolean relevantTrans = DurableSubProcessWithRestartTest.random(2) > 1;
                ClientType clientType = relevantTrans ? ClientType.randomClientType() : null;
                int count = DurableSubProcessWithRestartTest.random(200);
                LOG.info("Sending Trans[id=" + trans + ", count=" + count + ", clientType=" + clientType + "]");
                Connection con = this.cf.createConnection();
                Session sess = con.createSession(true, 0);
                MessageProducer prod = sess.createProducer(null);
                for (int i = 0; i < count; ++i) {
                    Message message = sess.createMessage();
                    message.setIntProperty("ID", ++this.messageRover);
                    message.setIntProperty("TRANS", trans);
                    String type = clientType != null ? clientType.randomMessageType() : ClientType.randomNonRelevantMessageType();
                    message.setStringProperty("TYPE", type);
                    message.setStringProperty("CARGO", this.getCargo(DurableSubProcessWithRestartTest.random(400)));
                    prod.send((Destination)DurableSubProcessWithRestartTest.this.topic, message);
                    DurableSubProcessWithRestartTest.this.clientManager.onServerMessage(message);
                }
                Message message = sess.createMessage();
                message.setIntProperty("ID", ++this.messageRover);
                message.setIntProperty("TRANS", trans);
                message.setBooleanProperty("COMMIT", true);
                message.setBooleanProperty("RELEVANT", relevantTrans);
                prod.send((Destination)DurableSubProcessWithRestartTest.this.topic, message);
                DurableSubProcessWithRestartTest.this.clientManager.onServerMessage(message);
                sess.commit();
                LOG.info("Committed Trans[id=" + trans + ", count=" + count + ", clientType=" + clientType + "], ID=" + this.messageRover);
                sess.close();
                con.close();
            }
        }

        private String getCargo(int length) {
            if (length == 0) {
                return null;
            }
            if (length < this.cargos.length) {
                String result = this.cargos[length];
                if (result == null) {
                    this.cargos[length] = result = this.getCargoImpl(length);
                }
                return result;
            }
            return this.getCargoImpl(length);
        }

        private String getCargoImpl(int length) {
            StringBuilder sb = new StringBuilder(length);
            int i = length;
            while (--i >= 0) {
                sb.append('a');
            }
            return sb.toString();
        }
    }

    private final class ClientManager
    extends Thread {
        private int clientRover;
        private final CopyOnWriteArrayList<Client> clients;

        public ClientManager() {
            super("ClientManager");
            this.clientRover = 0;
            this.clients = new CopyOnWriteArrayList();
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                while (true) {
                    if (this.clients.size() < 5) {
                        DurableSubProcessWithRestartTest.this.processLock.readLock().lock();
                        try {
                            this.createNewClient();
                        }
                        finally {
                            DurableSubProcessWithRestartTest.this.processLock.readLock().unlock();
                        }
                    }
                    int size = this.clients.size();
                    DurableSubProcessWithRestartTest.sleepRandom(size * 3 * 1000, size * 6 * 1000);
                }
            }
            catch (Throwable e) {
                DurableSubProcessWithRestartTest.exit("ClientManager.run failed.", e);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createNewClient() throws JMSException {
            Client client;
            ClientType type = ClientType.randomClientType();
            Object object = DurableSubProcessWithRestartTest.this.server.sendMutex;
            synchronized (object) {
                client = new Client(++this.clientRover, type, CLIENT_LIFETIME, CLIENT_ONLINE, CLIENT_OFFLINE);
                this.clients.add(client);
            }
            client.start();
            LOG.info(client.toString() + " created. " + this);
        }

        public void removeClient(Client client) {
            this.clients.remove(client);
        }

        public void onServerMessage(Message message) throws JMSException {
            for (Client client : this.clients) {
                client.onServerMessage(message);
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("ClientManager[count=");
            sb.append(this.clients.size());
            sb.append(", clients=");
            boolean sep = false;
            for (Client client : this.clients) {
                if (sep) {
                    sb.append(", ");
                } else {
                    sep = true;
                }
                sb.append(client.toString());
            }
            sb.append(']');
            return sb.toString();
        }
    }

    private final class HouseKeeper
    extends Thread {
        public final CopyOnWriteArrayList<String> abandonedSubscriptions;

        private HouseKeeper() {
            super("HouseKeeper");
            this.abandonedSubscriptions = new CopyOnWriteArrayList();
            this.setDaemon(true);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) lbl-1000:
                    // 3 sources

                    {
                        Thread.sleep(180000L);
                        DurableSubProcessWithRestartTest.this.processLock.readLock().lock();
                        try {
                            this.sweep();
                        }
                        finally {
                            DurableSubProcessWithRestartTest.this.processLock.readLock().unlock();
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException ex) {
                    break;
                }
                catch (Throwable e) {
                    log = new Exception("HouseKeeper failed.", e);
                    log.printStackTrace();
                    continue;
                }
                ** GOTO lbl-1000
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sweep() throws Exception {
            LOG.info("Housekeeper sweeping.");
            int closed = 0;
            ArrayList<String> sweeped = new ArrayList<String>();
            try {
                for (String clientId : this.abandonedSubscriptions) {
                    LOG.info("Sweeping out subscription of " + clientId + ".");
                    DurableSubProcessWithRestartTest.this.broker.getAdminView().destroyDurableSubscriber(clientId, "subscription");
                    sweeped.add(clientId);
                    ++closed;
                }
            }
            catch (Exception ignored) {
                LOG.info("Ex on destroy sub " + ignored);
            }
            finally {
                this.abandonedSubscriptions.removeAll(sweeped);
            }
            LOG.info("Housekeeper sweeped out " + closed + " subscriptions.");
        }
    }

    private static enum Persistence {
        MEMORY,
        KAHADB;

    }

    public static final class Random {
        final int min;
        final int max;

        Random(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public int next() {
            return DurableSubProcessWithRestartTest.random(this.min, this.max);
        }

        public void sleepRandom() throws InterruptedException {
            DurableSubProcessWithRestartTest.sleepRandom(this.min, this.max);
        }
    }

    private final class Client
    extends Thread {
        String url;
        final ConnectionFactory cf;
        public static final String SUBSCRIPTION_NAME = "subscription";
        private final int id;
        private final String conClientId;
        private final Random lifetime;
        private final Random online;
        private final Random offline;
        private final ClientType clientType;
        private final String selector;
        private final ConcurrentLinkedQueue<Message> waitingList;
        private final HashSet<Integer> processed;

        public Client(int id, ClientType clientType, Random lifetime, Random online, Random offline) throws JMSException {
            super("Client" + id);
            this.url = "failover:(tcp://localhost:61656?wireFormat.maxInactivityDuration=0)?jms.watchTopicAdvisories=false&jms.alwaysSyncSend=true&jms.dispatchAsync=true&jms.producerWindowSize=20971520&jms.copyMessageOnSend=false&initialReconnectDelay=100&maxReconnectDelay=30000&useExponentialBackOff=true";
            this.cf = new ActiveMQConnectionFactory(this.url);
            this.waitingList = new ConcurrentLinkedQueue();
            this.processed = new HashSet(10000);
            this.setDaemon(true);
            this.id = id;
            this.conClientId = "cli" + id;
            this.clientType = clientType;
            this.selector = "(COMMIT = true and RELEVANT = true) or " + clientType.selector;
            this.lifetime = lifetime;
            this.online = online;
            this.offline = offline;
            this.subscribe();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long end = System.currentTimeMillis() + (long)this.lifetime.next();
            try {
                long max;
                boolean sleep = false;
                while ((max = end - System.currentTimeMillis()) > 0L) {
                    if (sleep) {
                        this.offline.sleepRandom();
                    } else {
                        sleep = true;
                    }
                    DurableSubProcessWithRestartTest.this.processLock.readLock().lock();
                    try {
                        this.process(this.online.next());
                    }
                    finally {
                        DurableSubProcessWithRestartTest.this.processLock.readLock().unlock();
                    }
                }
                if (DurableSubProcessWithRestartTest.random(1) > 0) {
                    this.unsubscribe();
                } else {
                    LOG.info("Client abandon the subscription. " + this);
                    DurableSubProcessWithRestartTest.this.houseKeeper.abandonedSubscriptions.add(this.conClientId);
                }
            }
            catch (Throwable e) {
                DurableSubProcessWithRestartTest.exit(this.toString() + " failed.", e);
            }
            DurableSubProcessWithRestartTest.this.clientManager.removeClient(this);
            LOG.info(this.toString() + " DONE.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void process(long millis) throws JMSException {
            long end = System.currentTimeMillis() + millis;
            long hardEnd = end + 20000L;
            boolean inTransaction = false;
            int transCount = 0;
            LOG.info(this.toString() + " ONLINE.");
            Connection con = this.openConnection();
            Session sess = con.createSession(false, 2);
            TopicSubscriber consumer = sess.createDurableSubscriber((Topic)DurableSubProcessWithRestartTest.this.topic, SUBSCRIPTION_NAME, this.selector, false);
            try {
                while (true) {
                    Message message;
                    long max;
                    if ((max = end - System.currentTimeMillis()) <= 0L) {
                        if (!inTransaction) {
                            break;
                        }
                        max = hardEnd - System.currentTimeMillis();
                        if (max <= 0L) {
                            DurableSubProcessWithRestartTest.exit(this + " failed: Transaction is not finished.");
                        }
                    }
                    if ((message = consumer.receive(max)) == null) continue;
                    this.onClientMessage(message);
                    if (message.propertyExists("COMMIT")) {
                        message.acknowledge();
                        LOG.info("Received Trans[id=" + message.getIntProperty("TRANS") + ", count=" + transCount + "] in " + this + ".");
                        inTransaction = false;
                        transCount = 0;
                        continue;
                    }
                    inTransaction = true;
                    ++transCount;
                }
            }
            finally {
                sess.close();
                con.close();
                LOG.info(this.toString() + " OFFLINE.");
                Message topMessage = this.waitingList.peek();
                if (topMessage != null) {
                    this.checkDeliveryTime(topMessage);
                }
            }
        }

        public void onServerMessage(Message message) throws JMSException {
            if (Boolean.TRUE.equals(message.getObjectProperty("COMMIT"))) {
                if (Boolean.TRUE.equals(message.getObjectProperty("RELEVANT"))) {
                    this.waitingList.add(message);
                }
            } else {
                String messageType = message.getStringProperty("TYPE");
                if (this.clientType.isRelevant(messageType)) {
                    this.waitingList.add(message);
                }
            }
        }

        public void onClientMessage(Message message) {
            Message serverMessage = this.waitingList.poll();
            try {
                Integer receivedId = (Integer)message.getObjectProperty("ID");
                if (this.processed != null && this.processed.contains(receivedId)) {
                    LOG.info("! Message has been processed before. " + this + " message = " + message);
                }
                if (serverMessage == null) {
                    DurableSubProcessWithRestartTest.exit(this + " failed: There is no next server message, but received: " + message);
                }
                Integer serverId = (Integer)serverMessage.getObjectProperty("ID");
                if (receivedId == null || serverId == null) {
                    DurableSubProcessWithRestartTest.exit(this + " failed: message ID not found.\r\n received: " + message + "\r\n   server: " + serverMessage);
                }
                if (!serverId.equals(receivedId)) {
                    String detail = this.processed != null ? Arrays.toString(this.processed.toArray()) + "\n" : "";
                    DurableSubProcessWithRestartTest.exit(detail + this + " failed: Received wrong message.\r\n received: " + message + "\r\n   server: " + serverMessage);
                }
                this.checkDeliveryTime(message);
                if (this.processed != null) {
                    this.processed.add(receivedId);
                }
            }
            catch (Throwable e) {
                DurableSubProcessWithRestartTest.exit(this + ".onClientMessage failed.\r\n received: " + message + "\r\n   server: " + serverMessage, e);
            }
        }

        public void checkDeliveryTime(Message message) throws JMSException {
            long creation = message.getJMSTimestamp();
            long min = System.currentTimeMillis() - (long)((this.offline.max + this.online.min) * 4);
        }

        private Connection openConnection() throws JMSException {
            Connection con = this.cf.createConnection();
            con.setClientID(this.conClientId);
            con.start();
            return con;
        }

        private void subscribe() throws JMSException {
            Connection con = this.openConnection();
            Session session = con.createSession(false, 1);
            session.createDurableSubscriber((Topic)DurableSubProcessWithRestartTest.this.topic, SUBSCRIPTION_NAME, this.selector, true);
            session.close();
            con.close();
        }

        private void unsubscribe() throws JMSException {
            Connection con = this.openConnection();
            Session session = con.createSession(false, 1);
            session.unsubscribe(SUBSCRIPTION_NAME);
            session.close();
            con.close();
        }

        @Override
        public String toString() {
            return "Client[id=" + this.id + ", type=" + this.clientType + "]";
        }
    }

    private static enum ClientType {
        A("a", "b", "c"),
        B("c", "d", "e"),
        C("d", "e", "f"),
        D("g", "h");

        public final String[] messageTypes;
        public final HashSet<String> messageTypeSet;
        public final String selector;

        private ClientType(String ... messageTypes) {
            this.messageTypes = messageTypes;
            this.messageTypeSet = new HashSet<String>(Arrays.asList(messageTypes));
            StringBuilder sb = new StringBuilder("TYPE in (");
            for (int i = 0; i < messageTypes.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append('\'').append(messageTypes[i]).append('\'');
            }
            sb.append(')');
            this.selector = sb.toString();
        }

        public static ClientType randomClientType() {
            return ClientType.values()[DurableSubProcessWithRestartTest.random(ClientType.values().length - 1)];
        }

        public final String randomMessageType() {
            return this.messageTypes[DurableSubProcessWithRestartTest.random(this.messageTypes.length - 1)];
        }

        public static String randomNonRelevantMessageType() {
            return Integer.toString(DurableSubProcessWithRestartTest.random(20));
        }

        public final boolean isRelevant(String messageType) {
            return this.messageTypeSet.contains(messageType);
        }

        public final String toString() {
            return this.name();
        }
    }
}

