/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.test.TestSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscribeClosePublishThenConsumeTest
extends TestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(SubscribeClosePublishThenConsumeTest.class);

    public void testDurableTopic() throws Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("vm://locahost");
        String topicName = "TestTopic";
        String clientID = this.getName();
        String subscriberName = "MySubscriber:" + System.currentTimeMillis();
        Connection connection = connectionFactory.createConnection();
        connection.setClientID(clientID);
        Session session = connection.createSession(false, 1);
        Topic topic = session.createTopic(topicName);
        TopicSubscriber subscriber = session.createDurableSubscriber(topic, subscriberName);
        connection.start();
        topic = null;
        subscriber.close();
        subscriber = null;
        session.close();
        session = null;
        Connection t = connectionFactory.createConnection();
        connection.close();
        connection = t;
        session = connection.createSession(false, 1);
        topic = session.createTopic(topicName);
        MessageProducer producer = session.createProducer((Destination)topic);
        producer.setDeliveryMode(2);
        TextMessage textMessage = session.createTextMessage("Hello World");
        producer.send((Message)textMessage);
        textMessage = null;
        topic = null;
        session.close();
        session = null;
        t = connectionFactory.createConnection();
        connection.close();
        connection = t;
        connection.setClientID(clientID);
        session = connection.createSession(false, 1);
        topic = session.createTopic(topicName);
        subscriber = session.createDurableSubscriber(topic, subscriberName);
        connection.start();
        LOG.info("Started connection - now about to try receive the textMessage");
        long time = System.currentTimeMillis();
        Message message = subscriber.receive(15000L);
        long elapsed = System.currentTimeMillis() - time;
        LOG.info("Waited for: " + elapsed + " millis");
        SubscribeClosePublishThenConsumeTest.assertNotNull((String)"Should have received the message we published by now", (Object)message);
        SubscribeClosePublishThenConsumeTest.assertTrue((String)"should be text textMessage", (boolean)(message instanceof TextMessage));
        textMessage = (TextMessage)message;
        SubscribeClosePublishThenConsumeTest.assertEquals((String)"Hello World", (String)textMessage.getText());
    }
}

