/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.mirror;

import io.netty.util.collection.LongObjectHashMap;
import java.util.HashMap;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AMQPMirrorControllerSource;
import org.apache.activemq.artemis.utils.collections.LinkedListImpl;
import org.apache.activemq.artemis.utils.collections.NodeStore;

public class ReferenceNodeStore
implements NodeStore<MessageReference> {
    private final String serverID;
    HashMap<String, LongObjectHashMap<LinkedListImpl.Node<MessageReference>>> lists;
    String lruListID;
    LongObjectHashMap<LinkedListImpl.Node<MessageReference>> lruMap;

    public ReferenceNodeStore(ActiveMQServer server) {
        this.serverID = server.getNodeID().toString();
    }

    public void storeNode(MessageReference element, LinkedListImpl.Node<MessageReference> node) {
        String list = this.getServerID(element);
        long id = this.getID(element);
        this.storeNode(list, id, node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeNode(String serverID, long id, LinkedListImpl.Node<MessageReference> node) {
        LongObjectHashMap<LinkedListImpl.Node<MessageReference>> nodesMap = this.getMap(serverID);
        if (nodesMap != null) {
            LongObjectHashMap<LinkedListImpl.Node<MessageReference>> longObjectHashMap = nodesMap;
            synchronized (longObjectHashMap) {
                nodesMap.put(id, node);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode(MessageReference element, LinkedListImpl.Node<MessageReference> node) {
        long id = this.getID(element);
        String serverID = this.getServerID(element);
        LongObjectHashMap<LinkedListImpl.Node<MessageReference>> nodeMap = this.getMap(serverID);
        if (nodeMap != null) {
            LongObjectHashMap<LinkedListImpl.Node<MessageReference>> longObjectHashMap = nodeMap;
            synchronized (longObjectHashMap) {
                nodeMap.remove(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedListImpl.Node<MessageReference> getNode(String serverID, long id) {
        LongObjectHashMap<LinkedListImpl.Node<MessageReference>> nodeMap = this.getMap(serverID);
        assert (nodeMap != null);
        LongObjectHashMap<LinkedListImpl.Node<MessageReference>> longObjectHashMap = nodeMap;
        synchronized (longObjectHashMap) {
            return (LinkedListImpl.Node)nodeMap.get(id);
        }
    }

    private synchronized LongObjectHashMap<LinkedListImpl.Node<MessageReference>> getMap(String serverID) {
        LongObjectHashMap theList;
        if (serverID == null) {
            serverID = this.serverID;
        }
        if (this.lruListID != null && this.lruListID.equals(serverID)) {
            return this.lruMap;
        }
        if (this.lists == null) {
            this.lists = new HashMap();
        }
        if ((theList = this.lists.get(serverID)) == null) {
            theList = new LongObjectHashMap();
            this.lists.put(serverID, (LongObjectHashMap<LinkedListImpl.Node<MessageReference>>)theList);
        }
        this.lruMap = theList;
        this.lruListID = serverID;
        return theList;
    }

    public String getServerID(MessageReference element) {
        Object nodeID = element.getMessage().getBrokerProperty(AMQPMirrorControllerSource.INTERNAL_BROKER_ID_EXTRA_PROPERTY);
        if (nodeID != null) {
            return nodeID.toString();
        }
        return null;
    }

    public long getID(MessageReference element) {
        Long id = (Long)element.getMessage().getBrokerProperty(AMQPMirrorControllerSource.INTERNAL_ID_EXTRA_PROPERTY);
        if (id == null) {
            return element.getMessageID();
        }
        return id;
    }

    public synchronized void clear() {
        this.lists.forEach((k, v) -> v.clear());
        this.lists.clear();
        this.lruListID = null;
        this.lruMap = null;
    }

    public int size() {
        int size = 0;
        for (LongObjectHashMap<LinkedListImpl.Node<MessageReference>> mapValue : this.lists.values()) {
            size += mapValue.size();
        }
        return size;
    }
}

