/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.converter.coreWrapper;

import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQPropertyConversionException;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.protocol.amqp.converter.AMQPMessageSupport;
import org.apache.activemq.artemis.protocol.amqp.converter.coreWrapper.CoreMessageWrapper;
import org.apache.activemq.artemis.reader.MapMessageUtil;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.UnsignedShort;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;

public final class CoreMapMessageWrapper
extends CoreMessageWrapper {
    public static final byte TYPE = 5;
    private final TypedProperties map = new TypedProperties();

    public CoreMapMessageWrapper(ICoreMessage message) {
        super(message);
    }

    private static Map<String, Object> getMapFromMessageBody(CoreMapMessageWrapper message) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Enumeration names = message.getMapNames();
        while (names.hasMoreElements()) {
            String key = (String)names.nextElement();
            Object value = message.getObject(key);
            if (value instanceof byte[]) {
                value = new Binary((byte[])value);
            }
            map.put(key, value);
        }
        return map;
    }

    @Override
    public Section createAMQPSection(Map<Symbol, Object> maMap, Properties properties) {
        maMap.put(AMQPMessageSupport.JMS_MSG_TYPE, (byte)2);
        return new AmqpValue(CoreMapMessageWrapper.getMapFromMessageBody(this));
    }

    public void setBoolean(String name, boolean value) {
        this.map.putBooleanProperty(new SimpleString(name), value);
    }

    public void setByte(String name, byte value) {
        this.map.putByteProperty(new SimpleString(name), value);
    }

    public void setShort(String name, short value) {
        this.map.putShortProperty(new SimpleString(name), value);
    }

    public void setChar(String name, char value) {
        this.map.putCharProperty(new SimpleString(name), value);
    }

    public void setInt(String name, int value) {
        this.map.putIntProperty(new SimpleString(name), value);
    }

    public void setLong(String name, long value) {
        this.map.putLongProperty(new SimpleString(name), value);
    }

    public void setFloat(String name, float value) {
        this.map.putFloatProperty(new SimpleString(name), value);
    }

    public void setDouble(String name, double value) {
        this.map.putDoubleProperty(new SimpleString(name), value);
    }

    public void setString(String name, String value) {
        this.map.putSimpleStringProperty(new SimpleString(name), SimpleString.toSimpleString((String)value));
    }

    public void setBytes(String name, byte[] value) {
        this.map.putBytesProperty(new SimpleString(name), value);
    }

    public void setBytes(String name, byte[] value, int offset, int length) {
        byte[] newBytes = new byte[length];
        System.arraycopy(value, offset, newBytes, 0, length);
        this.map.putBytesProperty(new SimpleString(name), newBytes);
    }

    public void setObject(String name, Object value) throws ActiveMQPropertyConversionException {
        Object val = value;
        if (value instanceof UnsignedInteger) {
            val = ((UnsignedInteger)value).intValue();
        } else if (value instanceof UnsignedShort) {
            val = ((UnsignedShort)value).shortValue();
        } else if (value instanceof UnsignedByte) {
            val = ((UnsignedByte)value).byteValue();
        } else if (value instanceof UnsignedLong) {
            val = ((UnsignedLong)value).longValue();
        }
        TypedProperties.setObjectProperty((SimpleString)new SimpleString(name), (Object)val, (TypedProperties)this.map);
    }

    public boolean getBoolean(String name) throws ActiveMQPropertyConversionException {
        return this.map.getBooleanProperty(new SimpleString(name));
    }

    public byte getByte(String name) throws ActiveMQPropertyConversionException {
        return this.map.getByteProperty(new SimpleString(name));
    }

    public short getShort(String name) throws ActiveMQPropertyConversionException {
        return this.map.getShortProperty(new SimpleString(name));
    }

    public char getChar(String name) throws ActiveMQPropertyConversionException {
        return this.map.getCharProperty(new SimpleString(name)).charValue();
    }

    public int getInt(String name) throws ActiveMQPropertyConversionException {
        return this.map.getIntProperty(new SimpleString(name));
    }

    public long getLong(String name) throws ActiveMQPropertyConversionException {
        return this.map.getLongProperty(new SimpleString(name));
    }

    public float getFloat(String name) throws ActiveMQPropertyConversionException {
        return this.map.getFloatProperty(new SimpleString(name)).floatValue();
    }

    public double getDouble(String name) throws ActiveMQPropertyConversionException {
        return this.map.getDoubleProperty(new SimpleString(name));
    }

    public String getString(String name) throws ActiveMQPropertyConversionException {
        SimpleString str = this.map.getSimpleStringProperty(new SimpleString(name));
        if (str == null) {
            return null;
        }
        return str.toString();
    }

    public byte[] getBytes(String name) throws ActiveMQPropertyConversionException {
        return this.map.getBytesProperty(new SimpleString(name));
    }

    public Object getObject(String name) {
        Object val = this.map.getProperty(new SimpleString(name));
        if (val instanceof SimpleString) {
            val = ((SimpleString)val).toString();
        }
        return val;
    }

    public Enumeration getMapNames() {
        return Collections.enumeration(this.map.getMapNames());
    }

    public boolean itemExists(String name) {
        return this.map.containsProperty(new SimpleString(name));
    }

    @Override
    public void clearBody() {
        super.clearBody();
        this.map.clear();
    }

    @Override
    public void encode() {
        super.encode();
        MapMessageUtil.writeBodyMap((ActiveMQBuffer)this.getWriteBodyBuffer(), (TypedProperties)this.map);
    }

    @Override
    public void decode() {
        super.decode();
        MapMessageUtil.readBodyMap((ActiveMQBuffer)this.getReadBodyBuffer(), (TypedProperties)this.map);
    }
}

