/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.sasl;

import java.security.Principal;
import org.apache.activemq.artemis.core.remoting.CertificateUtil;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.protocol.amqp.broker.AmqpInterceptor;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPRoutingHandler;
import org.apache.activemq.artemis.protocol.amqp.sasl.ExternalServerSASL;
import org.apache.activemq.artemis.protocol.amqp.sasl.ServerSASL;
import org.apache.activemq.artemis.protocol.amqp.sasl.ServerSASLFactory;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManager;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.jboss.logging.Logger;

public class ExternalServerSASLFactory
implements ServerSASLFactory {
    private static final Logger logger = Logger.getLogger(ExternalServerSASLFactory.class);

    @Override
    public String getMechanism() {
        return "EXTERNAL";
    }

    @Override
    public ServerSASL create(ActiveMQServer server, ProtocolManager<AmqpInterceptor, AMQPRoutingHandler> manager, Connection connection, RemotingConnection remotingConnection) {
        Principal principal = CertificateUtil.getPeerPrincipalFromConnection((RemotingConnection)remotingConnection);
        if (principal != null) {
            ExternalServerSASL externalServerSASL = new ExternalServerSASL();
            externalServerSASL.setPrincipal(principal);
            return externalServerSASL;
        }
        logger.debug((Object)"SASL EXTERNAL mechanism requires a TLS peer principal");
        return null;
    }

    @Override
    public int getPrecedence() {
        return 0;
    }

    @Override
    public boolean isDefaultPermitted() {
        return false;
    }
}

