/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.tools;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.tools.DBOption;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFileFactory;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import org.apache.activemq.artemis.core.journal.impl.JournalReaderCallback;
import org.apache.activemq.artemis.core.journal.impl.dataformat.ByteArrayEncoding;
import org.apache.activemq.artemis.core.message.impl.CoreMessagePersister;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.spi.core.protocol.MessagePersister;
import org.apache.activemq.artemis.utils.ByteUtil;

@Command(name="recover", description="Recover (undelete) every message on the journal by creating a new output journal. Rolled back and acked messages will be sent out to the output as much as possible.")
public class RecoverMessages
extends DBOption {
    @Option(name={"--reclaimed"}, description="Try to recover as many records as possible from reclaimed files.")
    private boolean reclaimed = false;
    @Option(name={"--target"}, description="Output folder container the new journal with all the generated messages.", required=true)
    private String outputJournal;

    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        Configuration configuration = this.getParameterConfiguration();
        File journalOutput = new File(this.outputJournal);
        try {
            if (configuration.isJDBC()) {
                throw new IllegalAccessException("JDBC Not supported on recover");
            }
            RecoverMessages.recover(configuration, this.getJournal(), journalOutput, new File(this.getLargeMessages()), this.reclaimed);
        }
        catch (Exception e) {
            this.treatError(e, "data", "recover");
        }
        return null;
    }

    public static void recover(Configuration configuration, String journallocation, File journalOutput, File largeMessage, boolean reclaimed) throws Exception {
        ActionContext context = ActionContext.system();
        File journal = new File(journallocation);
        if (!journalOutput.exists() && !journalOutput.mkdirs()) {
            throw new IllegalStateException("It was not possible to create " + journalOutput);
        }
        if (journalOutput.exists() && !journalOutput.isDirectory()) {
            throw new IllegalStateException(journalOutput + " is not a directory");
        }
        NIOSequentialFileFactory outputFF = new NIOSequentialFileFactory(journalOutput, null, 1);
        outputFF.setDatasync(false);
        JournalImpl targetJournal = new JournalImpl(configuration.getJournalFileSize(), 2, 2, -1, 0, (SequentialFileFactory)outputFF, "activemq-data", "amq", 1);
        targetJournal.setAutoReclaim(false);
        targetJournal.start();
        targetJournal.loadInternalOnly();
        NIOSequentialFileFactory messagesFF = new NIOSequentialFileFactory(journal, null, 1);
        NIOSequentialFileFactory largeMessagesFF = new NIOSequentialFileFactory(largeMessage, null, 1);
        JournalImpl messagesJournal = new JournalImpl(configuration.getJournalFileSize(), configuration.getJournalMinFiles(), configuration.getJournalPoolFiles(), 0, 0, (SequentialFileFactory)messagesFF, "activemq-data", "amq", 1);
        List files = messagesJournal.orderFiles();
        HashSet<Byte> userRecordsOfInterest = new HashSet<Byte>();
        userRecordsOfInterest.add((byte)30);
        userRecordsOfInterest.add((byte)31);
        userRecordsOfInterest.add((byte)45);
        userRecordsOfInterest.add((byte)32);
        userRecordsOfInterest.add((byte)35);
        HashSet routeBindigns = new HashSet();
        for (JournalFile file : files) {
            context.out.println("Recovering messages from file " + file);
            JournalImpl.readJournalFile((SequentialFileFactory)messagesFF, (JournalFile)file, (JournalReaderCallback)new JournalReaderCallback((SequentialFileFactory)largeMessagesFF, userRecordsOfInterest, targetJournal, context, routeBindigns){
                long lastlargeMessageId = -1L;
                SequentialFile largeMessageFile;
                final /* synthetic */ SequentialFileFactory val$largeMessagesFF;
                final /* synthetic */ HashSet val$userRecordsOfInterest;
                final /* synthetic */ JournalImpl val$targetJournal;
                final /* synthetic */ ActionContext val$context;
                final /* synthetic */ HashSet val$routeBindigns;
                {
                    this.val$largeMessagesFF = sequentialFileFactory;
                    this.val$userRecordsOfInterest = hashSet;
                    this.val$targetJournal = journalImpl;
                    this.val$context = actionContext;
                    this.val$routeBindigns = hashSet2;
                }

                public void done() {
                    try {
                        if (this.largeMessageFile != null) {
                            this.largeMessageFile.close();
                            this.largeMessageFile = null;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                public void onReadEventRecord(RecordInfo info) throws Exception {
                    switch (info.getUserRecordType()) {
                        case 32: {
                            this.onReadUpdateRecord(info);
                            break;
                        }
                        case 49: {
                            if (this.lastlargeMessageId != info.id || this.largeMessageFile == null) {
                                if (this.largeMessageFile != null) {
                                    this.largeMessageFile.close();
                                }
                                this.largeMessageFile = this.val$largeMessagesFF.createSequentialFile(info.id + ".msg");
                                this.largeMessageFile.open();
                                this.largeMessageFile.position(this.largeMessageFile.size());
                                this.lastlargeMessageId = info.id;
                            }
                            this.largeMessageFile.write((EncodingSupport)new ByteArrayEncoding(info.data), false, null);
                            break;
                        }
                        default: {
                            this.onReadAddRecord(info);
                        }
                    }
                }

                public void onReadAddRecord(RecordInfo info) throws Exception {
                    if (this.val$userRecordsOfInterest.contains(info.getUserRecordType())) {
                        if (this.val$targetJournal.getRecords().get(info.id) != null) {
                            this.val$context.out.println("RecordID " + info.id + " would been duplicated, ignoring it");
                            return;
                        }
                        try {
                            this.val$targetJournal.appendAddRecord(info.id, info.userRecordType, info.data, false);
                        }
                        catch (Exception e) {
                            this.val$context.out.println("Cannot append record for " + info.id + "->" + e.getMessage());
                        }
                    }
                }

                public void onReadUpdateRecord(RecordInfo info) throws Exception {
                    if (this.val$userRecordsOfInterest.contains(info.getUserRecordType())) {
                        if (info.getUserRecordType() == 32) {
                            long queue = ByteUtil.bytesToLong((byte[])info.data);
                            Pair pairQueue = new Pair((Object)info.id, (Object)queue);
                            if (this.val$routeBindigns.contains(pairQueue)) {
                                this.val$context.out.println("AddReference on " + info.id + " / queue=" + queue + " has already been recorded, ignoring it");
                                return;
                            }
                            this.val$routeBindigns.add(pairQueue);
                        }
                        try {
                            this.val$targetJournal.appendUpdateRecord(info.id, info.userRecordType, info.data, true);
                        }
                        catch (Exception e) {
                            this.val$context.out.println("Cannot update record " + info.id + "-> " + e.getMessage());
                            e.printStackTrace(this.val$context.err);
                        }
                    }
                }

                public void onReadDeleteRecord(long recordID) throws Exception {
                }

                public void onReadAddRecordTX(long transactionID, RecordInfo info) throws Exception {
                    this.onReadAddRecord(info);
                }

                public void onReadUpdateRecordTX(long transactionID, RecordInfo info) throws Exception {
                    this.onReadUpdateRecord(info);
                }

                public void onReadDeleteRecordTX(long transactionID, RecordInfo recordInfo) throws Exception {
                }

                public void onReadPrepareRecord(long transactionID, byte[] extraData, int numberOfRecords) throws Exception {
                }

                public void onReadCommitRecord(long transactionID, int numberOfRecords) throws Exception {
                }

                public void onReadRollbackRecord(long transactionID) throws Exception {
                }

                public void markAsDataFile(JournalFile file) {
                }
            }, null, (boolean)reclaimed, null);
        }
        targetJournal.flush();
        targetJournal.stop();
        outputFF.stop();
    }

    static {
        MessagePersister.registerPersister((Persister)CoreMessagePersister.getInstance());
    }
}

