/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.tools.xml;

import java.nio.ByteBuffer;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.cli.commands.tools.xml.XmlDataExporterUtil;
import org.apache.activemq.artemis.core.client.impl.ClientLargeMessageImpl;
import org.apache.activemq.artemis.core.message.LargeBodyReader;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.reader.TextMessageUtil;

public class XMLMessageExporter {
    private static final int LARGE_MESSAGE_CHUNK_SIZE = 1000;
    private XMLStreamWriter xmlWriter;

    public XMLMessageExporter(XMLStreamWriter xmlWriter) {
        this.xmlWriter = xmlWriter;
    }

    public XMLStreamWriter getRawXMLWriter() {
        return this.xmlWriter;
    }

    public void printSingleMessageAsXML(ICoreMessage message, List<String> queues, boolean encodeTextUTF8) throws Exception {
        this.xmlWriter.writeStartElement("message");
        this.printMessageAttributes(message);
        this.printMessageProperties((Message)message);
        this.printMessageQueues(queues);
        this.printMessageBody((Message)message.toCore(), encodeTextUTF8);
        this.xmlWriter.writeEndElement();
    }

    public void printMessageBody(Message message, boolean encodeTextMessageUTF8) throws Exception {
        this.xmlWriter.writeStartElement("body");
        if (message.isLargeMessage()) {
            this.printLargeMessageBody(message);
        } else if (encodeTextMessageUTF8 && message.toCore().getType() == 3) {
            this.xmlWriter.writeCData(TextMessageUtil.readBodyText((ActiveMQBuffer)message.toCore().getReadOnlyBodyBuffer()).toString());
        } else {
            this.xmlWriter.writeCData(XmlDataExporterUtil.encodeMessageBodyBase64(message));
        }
        this.xmlWriter.writeEndElement();
    }

    private static ByteBuffer acquireHeapBodyBuffer(ByteBuffer chunkBytes, int requiredCapacity) {
        if (chunkBytes == null || chunkBytes.capacity() != requiredCapacity) {
            chunkBytes = ByteBuffer.allocate(requiredCapacity);
        } else {
            chunkBytes.clear();
        }
        return chunkBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printLargeMessageBody(Message message) throws XMLStreamException {
        this.xmlWriter.writeAttribute("isLarge", Boolean.TRUE.toString());
        LargeBodyReader encoder = null;
        try {
            if (message instanceof LargeServerMessage) {
                encoder = ((LargeServerMessage)message).toMessage().toCore().getLargeBodyReader();
            } else if (message instanceof ClientLargeMessageImpl) {
                encoder = ((ClientLargeMessageImpl)message).getLargeBodyReader();
            } else {
                throw new RuntimeException("Unrecognized message implementation: " + message.getClass().getName());
            }
            encoder.open();
            long totalBytesWritten = 0L;
            long bodySize = encoder.getSize();
            ByteBuffer buffer = null;
            for (long i = 0L; i < bodySize; i += 1000L) {
                long remainder = bodySize - totalBytesWritten;
                int bufferSize = remainder >= 1000L ? 1000 : (int)remainder;
                buffer = XMLMessageExporter.acquireHeapBodyBuffer(buffer, bufferSize);
                encoder.readInto(buffer);
                this.xmlWriter.writeCData(XmlDataExporterUtil.encode(buffer.array()));
                totalBytesWritten += (long)bufferSize;
            }
            encoder.close();
        }
        catch (ActiveMQException e) {
            e.printStackTrace();
        }
        finally {
            if (encoder != null) {
                try {
                    encoder.close();
                }
                catch (ActiveMQException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void printMessageQueues(List<String> queues) throws XMLStreamException {
        if (queues != null) {
            this.xmlWriter.writeStartElement("queues");
            for (String queueName : queues) {
                this.xmlWriter.writeEmptyElement("queue");
                this.xmlWriter.writeAttribute("name", queueName);
            }
            this.xmlWriter.writeEndElement();
        }
    }

    public void printMessageProperties(Message message) throws XMLStreamException {
        this.xmlWriter.writeStartElement("properties");
        for (SimpleString key : message.getPropertyNames()) {
            Object value = message.getObjectProperty(key);
            this.xmlWriter.writeEmptyElement("property");
            this.xmlWriter.writeAttribute("name", key.toString());
            this.xmlWriter.writeAttribute("value", XmlDataExporterUtil.convertProperty(value));
            String propertyType = XmlDataExporterUtil.getPropertyType(value);
            if (propertyType == null) continue;
            this.xmlWriter.writeAttribute("type", propertyType);
        }
        this.xmlWriter.writeEndElement();
    }

    public void printMessageAttributes(ICoreMessage message) throws XMLStreamException {
        this.xmlWriter.writeAttribute("id", Long.toString(message.getMessageID()));
        this.xmlWriter.writeAttribute("priority", Byte.toString(message.getPriority()));
        this.xmlWriter.writeAttribute("expiration", Long.toString(message.getExpiration()));
        this.xmlWriter.writeAttribute("timestamp", Long.toString(message.getTimestamp()));
        String prettyType = XmlDataExporterUtil.getMessagePrettyType(message.getType());
        this.xmlWriter.writeAttribute("type", prettyType);
        if (message.getUserID() != null) {
            this.xmlWriter.writeAttribute("user-id", message.getUserID().toString());
        }
    }
}

