/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.tools.journal;

import java.text.DecimalFormat;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.tools.OptionalLocking;
import org.apache.activemq.artemis.cli.commands.util.SyncCalculation;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.server.JournalType;
import picocli.CommandLine;

@CommandLine.Command(name="perf-journal", description={"Calculate the journal-buffer-timeout to use with the current data folder."})
public class PerfJournal
extends OptionalLocking {
    @CommandLine.Option(names={"--block-size"}, description={"The block size for each write. Default 4096."})
    public int size = 4096;
    @CommandLine.Option(names={"--writes"}, description={"The number of writes to be performed. Default: 250."})
    public int writes = 250;
    @CommandLine.Option(names={"--tries"}, description={"The number of tries for the test. Default: 5."})
    public int tries = 5;
    @CommandLine.Option(names={"--no-sync"}, description={"Disable syncs."})
    public boolean nosyncs = false;
    @CommandLine.Option(names={"--sync"}, description={"Enable syncs."})
    public boolean syncs = false;
    @CommandLine.Option(names={"--journal-type"}, description={"Journal type to be used: Default: read from broker.xml."})
    public String journalType = null;
    @CommandLine.Option(names={"--sync-writes"}, description={"Perform each write synchronously, e.g. if there was a single producer."})
    public boolean syncWrites = false;
    @CommandLine.Option(names={"--file"}, description={"The file name to be used. Default: test.tmp."})
    public String fileName = "test.tmp";
    @CommandLine.Option(names={"--max-aio"}, description={"libaio.maxAIO to be used. Default: read from broker.xml."})
    public int maxAIO = 0;

    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        FileConfiguration fileConfiguration = this.getFileConfiguration();
        if (this.nosyncs) {
            fileConfiguration.setJournalDatasync(false);
        } else if (this.syncs) {
            fileConfiguration.setJournalDatasync(true);
        }
        if (this.journalType != null) {
            fileConfiguration.setJournalType(JournalType.getType((String)this.journalType));
        }
        context.out.println("");
        context.out.println("Auto tuning journal ...");
        context.out.println("Performing " + this.tries + " tests writing " + this.writes + " blocks of " + this.size + " on each test, sync=" + fileConfiguration.isJournalDatasync() + " with journalType = " + fileConfiguration.getJournalType());
        fileConfiguration.getJournalLocation().mkdirs();
        if (this.maxAIO <= 0) {
            this.maxAIO = fileConfiguration.getJournalMaxIO_AIO();
        }
        long time = SyncCalculation.syncTest(fileConfiguration.getJournalLocation(), this.size, this.writes, this.tries, this.verbose, fileConfiguration.isJournalDatasync(), this.syncWrites, this.fileName, this.maxAIO, fileConfiguration.getJournalType(), context);
        long nanosecondsWait = SyncCalculation.toNanos(time, this.writes, this.verbose, context);
        double writesPerMillisecond = (double)this.writes / (double)time;
        String writesPerMillisecondStr = new DecimalFormat("###.##").format(writesPerMillisecond);
        context.out.println("Your system can execute " + writesPerMillisecondStr + " writes per millisecond");
        context.out.println("Your journal-buffer-timeout should be:" + nanosecondsWait);
        context.out.println("You should use this following configuration:");
        context.out.println();
        context.out.println("<journal-buffer-timeout>" + nanosecondsWait + "</journal-buffer-timeout>");
        return null;
    }
}

