/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.BaseMessage;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.util.ByteArray;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class BytesMessage
extends BaseMessage {
    protected byte[] array;
    protected int offset;
    protected int length;

    public BytesMessage() {
    }

    public BytesMessage(Address dest) {
        super(dest);
    }

    public BytesMessage(Address dest, byte[] array) {
        this(dest, array, 0, array != null ? array.length : 0);
    }

    public BytesMessage(Address dest, byte[] array, int offset, int length) {
        super(dest);
        this.setArray(array, offset, length);
    }

    public BytesMessage(Address dest, ByteArray array) {
        super(dest);
        this.setArray(array);
    }

    public BytesMessage(Address dest, Object obj) {
        super(dest);
        this.setObject(obj);
    }

    @Override
    public BytesMessage setFlag(Message.Flag ... flags) {
        super.setFlag(flags);
        return this;
    }

    @Override
    public Supplier<Message> create() {
        return BytesMessage::new;
    }

    @Override
    public short getType() {
        return 0;
    }

    @Override
    public boolean hasPayload() {
        return this.array != null;
    }

    @Override
    public boolean hasArray() {
        return true;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public byte[] getArray() {
        return this.array;
    }

    @Override
    public BytesMessage setArray(byte[] b, int offset, int length) {
        this.array = b;
        if (this.array != null) {
            if (offset < 0 || offset > this.array.length) {
                throw new ArrayIndexOutOfBoundsException(offset);
            }
            if (offset + length > this.array.length) {
                throw new ArrayIndexOutOfBoundsException(offset + length);
            }
            this.offset = offset;
            this.length = length;
        } else {
            this.length = 0;
            this.offset = 0;
        }
        return this;
    }

    @Override
    public BytesMessage setArray(ByteArray buf) {
        if (buf != null) {
            this.array = buf.getArray();
            this.offset = buf.getOffset();
            this.length = buf.getLength();
        }
        return this;
    }

    @Override
    public BytesMessage setObject(Object obj) {
        this.clearFlag(Message.Flag.SERIALIZED);
        if (obj == null) {
            this.array = null;
            this.length = 0;
            this.offset = 0;
            return this;
        }
        if (obj instanceof byte[]) {
            return this.setArray((byte[])obj, 0, ((byte[])obj).length);
        }
        if (obj instanceof ByteArray) {
            return this.setArray((ByteArray)obj);
        }
        if (obj instanceof ByteBuffer) {
            ByteBuffer bb = (ByteBuffer)obj;
            if (bb.isDirect()) {
                return (BytesMessage)this.setArray(Util.bufferToArray(bb));
            }
            return this.setArray(bb.array(), bb.arrayOffset() + bb.position(), bb.remaining());
        }
        try {
            ByteArray tmp = Util.objectToBuffer(obj);
            this.setFlag(Message.Flag.SERIALIZED);
            return this.setArray(tmp);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public <T> T getObject() {
        return this.getObject(null);
    }

    public <T> T getObject(ClassLoader loader) {
        if (this.array == null) {
            return null;
        }
        try {
            return (T)(this.isFlagSet(Message.Flag.SERIALIZED) ? (Object)Util.objectFromByteBuffer(this.array, this.offset, this.length, loader) : this.getArray());
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public int size() {
        return super.size() + this.sizeOfPayload();
    }

    @Override
    protected Message copyPayload(Message copy) {
        if (this.array != null) {
            copy.setArray(this.array, this.offset, this.length);
        }
        return copy;
    }

    protected int sizeOfPayload() {
        int retval = 4;
        if (this.array != null) {
            retval += this.length;
        }
        return retval;
    }

    @Override
    public void writePayload(DataOutput out) throws IOException {
        out.writeInt(this.array != null ? this.length : -1);
        if (this.array != null) {
            out.write(this.array, this.offset, this.length);
        }
    }

    @Override
    public void readPayload(DataInput in) throws IOException {
        int len = in.readInt();
        if (len >= 0) {
            this.array = new byte[len];
            in.readFully(this.array, 0, len);
            this.length = len;
        }
    }

    protected <T extends BytesMessage> T createMessage() {
        return (T)new BytesMessage();
    }
}

