/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Supplier;
import org.apache.activemq.artemis.shaded.org.jgroups.Header;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Bits;

public class PingHeader
extends Header {
    public static final byte GET_MBRS_REQ = 1;
    public static final byte GET_MBRS_RSP = 2;
    protected byte type;
    protected String cluster_name;
    protected boolean initial_discovery;

    public PingHeader() {
    }

    public PingHeader(byte type) {
        this.type = type;
    }

    public byte type() {
        return this.type;
    }

    public PingHeader clusterName(String name) {
        this.cluster_name = name;
        return this;
    }

    public boolean initialDiscovery() {
        return this.initial_discovery;
    }

    public PingHeader initialDiscovery(boolean b) {
        this.initial_discovery = b;
        return this;
    }

    @Override
    public short getMagicId() {
        return 53;
    }

    @Override
    public Supplier<? extends Header> create() {
        return PingHeader::new;
    }

    @Override
    public int serializedSize() {
        int retval = 3;
        if (this.cluster_name != null) {
            retval += this.cluster_name.length() + 2;
        }
        return retval;
    }

    @Override
    public String toString() {
        return String.format("[%s cluster=%s initial_discovery=%b]", PingHeader.type2Str(this.type), this.cluster_name, this.initial_discovery);
    }

    static String type2Str(byte t) {
        switch (t) {
            case 1: {
                return "GET_MBRS_REQ";
            }
            case 2: {
                return "GET_MBRS_RSP";
            }
        }
        return "<unkown type (" + t + ")>";
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        out.writeByte(this.type);
        Bits.writeString(this.cluster_name, out);
        out.writeBoolean(this.initial_discovery);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        this.type = in.readByte();
        this.cluster_name = Bits.readString(in);
        this.initial_discovery = in.readBoolean();
    }
}

