/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.uri;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Locale;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.shaded.org.apache.commons.beanutils.FluentPropertyBeanIntrospector;
import org.apache.activemq.artemis.shaded.org.apache.commons.beanutils.IntrospectionContext;
import org.apache.activemq.artemis.utils.collections.ConcurrentHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FluentPropertyBeanIntrospectorWithIgnores
extends FluentPropertyBeanIntrospector {
    static Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static ConcurrentHashSet<Pair<String, String>> ignores = new ConcurrentHashSet();

    public static void addIgnore(String className, String propertyName) {
        logger.trace("Adding ignore on {}/{}", (Object)className, (Object)propertyName);
        ignores.add(new Pair<String, String>(className, propertyName));
    }

    public static boolean isIgnored(String className, String propertyName) {
        return ignores.contains(new Pair<String, String>(className, propertyName));
    }

    @Override
    public void introspect(IntrospectionContext icontext) throws IntrospectionException {
        for (Method m : icontext.getTargetClass().getMethods()) {
            if (!m.getName().startsWith(this.getWriteMethodPrefix())) continue;
            if (FluentPropertyBeanIntrospectorWithIgnores.isIgnored(icontext.getTargetClass().getName(), m.getName())) {
                logger.trace("{} Ignored for {}", (Object)m.getName(), (Object)icontext.getTargetClass().getName());
                continue;
            }
            this.introspect(icontext, m, this.propertyName(m));
            this.introspect(icontext, m, this.defaultPropertyName(m));
        }
    }

    private void introspect(IntrospectionContext icontext, Method writeMethod, String propertyName) {
        PropertyDescriptor pd = icontext.getPropertyDescriptor(propertyName);
        try {
            if (pd == null) {
                icontext.addPropertyDescriptor(this.createFluentPropertyDescritor(writeMethod, propertyName));
            } else if (pd.getWriteMethod() == null) {
                pd.setWriteMethod(writeMethod);
            }
        }
        catch (IntrospectionException e) {
            logger.trace("error for property named {}", (Object)propertyName, (Object)e);
        }
    }

    private PropertyDescriptor createFluentPropertyDescritor(Method writeMethod, String propertyName) throws IntrospectionException {
        return new PropertyDescriptor(propertyName, null, writeMethod);
    }

    private String propertyName(Method m) {
        String methodName = m.getName().substring(this.getWriteMethodPrefix().length());
        return methodName.length() > 1 ? Character.toLowerCase(methodName.charAt(0)) + methodName.substring(1) : methodName.toLowerCase(Locale.ENGLISH);
    }

    private String defaultPropertyName(Method m) {
        String methodName = m.getName().substring(this.getWriteMethodPrefix().length());
        return methodName.length() > 1 ? Introspector.decapitalize(methodName) : methodName.toLowerCase(Locale.ENGLISH);
    }
}

