/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.base64.Base64;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.CookieDecoder;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AttributeKey;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.IOException;
import java.net.ConnectException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.core.client.ActiveMQClientMessageBundle;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryImpl;
import org.apache.activemq.artemis.core.protocol.core.impl.ActiveMQClientProtocolManager;
import org.apache.activemq.artemis.core.remoting.impl.netty.ActiveMQChannelHandler;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnection;
import org.apache.activemq.artemis.core.remoting.impl.netty.SharedNioEventLoopGroup;
import org.apache.activemq.artemis.core.remoting.impl.netty.TransportConstants;
import org.apache.activemq.artemis.core.remoting.impl.ssl.SSLSupport;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.spi.core.remoting.AbstractConnector;
import org.apache.activemq.artemis.spi.core.remoting.BaseConnectionLifeCycleListener;
import org.apache.activemq.artemis.spi.core.remoting.BufferHandler;
import org.apache.activemq.artemis.spi.core.remoting.ClientConnectionLifeCycleListener;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManager;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.utils.ConfigurationHelper;
import org.apache.activemq.artemis.utils.FutureLatch;
import org.apache.activemq.artemis.utils.IPV6Util;
import org.jboss.logging.Logger;

public class NettyConnector
extends AbstractConnector {
    private static final Logger logger = Logger.getLogger(NettyConnector.class);
    public static final String JAVAX_KEYSTORE_PATH_PROP_NAME = "javax.net.ssl.keyStore";
    public static final String JAVAX_KEYSTORE_PASSWORD_PROP_NAME = "javax.net.ssl.keyStorePassword";
    public static final String JAVAX_TRUSTSTORE_PATH_PROP_NAME = "javax.net.ssl.trustStore";
    public static final String JAVAX_TRUSTSTORE_PASSWORD_PROP_NAME = "javax.net.ssl.trustStorePassword";
    public static final String ACTIVEMQ_KEYSTORE_PROVIDER_PROP_NAME = "org.apache.activemq.ssl.keyStoreProvider";
    public static final String ACTIVEMQ_KEYSTORE_PATH_PROP_NAME = "org.apache.activemq.ssl.keyStore";
    public static final String ACTIVEMQ_KEYSTORE_PASSWORD_PROP_NAME = "org.apache.activemq.ssl.keyStorePassword";
    public static final String ACTIVEMQ_TRUSTSTORE_PROVIDER_PROP_NAME = "org.apache.activemq.ssl.trustStoreProvider";
    public static final String ACTIVEMQ_TRUSTSTORE_PATH_PROP_NAME = "org.apache.activemq.ssl.trustStore";
    public static final String ACTIVEMQ_TRUSTSTORE_PASSWORD_PROP_NAME = "org.apache.activemq.ssl.trustStorePassword";
    public static final String MAGIC_NUMBER = "CF70DEB8-70F9-4FBA-8B4F-DFC3E723B4CD";
    public static final String SEC_ACTIVEMQ_REMOTING_KEY = "Sec-ActiveMQRemoting-Key";
    public static final String SEC_ACTIVEMQ_REMOTING_ACCEPT = "Sec-ActiveMQRemoting-Accept";
    public static final String ACTIVEMQ_REMOTING = "activemq-remoting";
    private static final AttributeKey<String> REMOTING_KEY = AttributeKey.valueOf((String)"Sec-ActiveMQRemoting-Key");
    public static final Map<String, Object> DEFAULT_CONFIG;
    private Class<? extends Channel> channelClazz;
    private Bootstrap bootstrap;
    private ChannelGroup channelGroup;
    private final BufferHandler handler;
    private final BaseConnectionLifeCycleListener listener;
    private boolean sslEnabled = false;
    private boolean httpEnabled;
    private long httpMaxClientIdleTime;
    private long httpClientIdleScanPeriod;
    private boolean httpRequiresSessionId;
    private boolean httpUpgradeEnabled;
    private boolean useServlet;
    private String host;
    private int port;
    private String localAddress;
    private int localPort;
    private String keyStoreProvider;
    private String keyStorePath;
    private String keyStorePassword;
    private String trustStoreProvider;
    private String trustStorePath;
    private String trustStorePassword;
    private String enabledCipherSuites;
    private String enabledProtocols;
    private boolean verifyHost;
    private boolean tcpNoDelay;
    private int tcpSendBufferSize;
    private int tcpReceiveBufferSize;
    private long batchDelay;
    private ConcurrentMap<Object, Connection> connections = new ConcurrentHashMap<Object, Connection>();
    private String servletPath;
    private int nioRemotingThreads;
    private boolean useNioGlobalWorkerPool;
    private ScheduledExecutorService scheduledThreadPool;
    private Executor closeExecutor;
    private BatchFlusher flusher;
    private ScheduledFuture<?> batchFlusherFuture;
    private EventLoopGroup group;
    private int connectTimeoutMillis;
    private final ClientProtocolManager protocolManager;

    public NettyConnector(Map<String, Object> configuration, BufferHandler handler, BaseConnectionLifeCycleListener listener, Executor closeExecutor, Executor threadPool, ScheduledExecutorService scheduledThreadPool) {
        this(configuration, handler, listener, closeExecutor, threadPool, scheduledThreadPool, new ActiveMQClientProtocolManager());
    }

    public NettyConnector(Map<String, Object> configuration, BufferHandler handler, BaseConnectionLifeCycleListener listener, Executor closeExecutor, Executor threadPool, ScheduledExecutorService scheduledThreadPool, ClientProtocolManager protocolManager) {
        super(configuration);
        this.protocolManager = protocolManager;
        if (listener == null) {
            throw ActiveMQClientMessageBundle.BUNDLE.nullListener();
        }
        if (handler == null) {
            throw ActiveMQClientMessageBundle.BUNDLE.nullHandler();
        }
        this.listener = listener;
        this.handler = handler;
        this.sslEnabled = ConfigurationHelper.getBooleanProperty("sslEnabled", false, configuration);
        this.httpEnabled = ConfigurationHelper.getBooleanProperty("httpEnabled", false, configuration);
        this.servletPath = ConfigurationHelper.getStringProperty("servletPath", "/messaging/ActiveMQServlet", configuration);
        if (this.httpEnabled) {
            this.httpMaxClientIdleTime = ConfigurationHelper.getLongProperty("httpClientIdleTime", 500L, configuration);
            this.httpClientIdleScanPeriod = ConfigurationHelper.getLongProperty("httpClientIdleScanPeriod", 500L, configuration);
            this.httpRequiresSessionId = ConfigurationHelper.getBooleanProperty("httpRequiresSessionId", false, configuration);
        } else {
            this.httpMaxClientIdleTime = 0L;
            this.httpClientIdleScanPeriod = -1L;
            this.httpRequiresSessionId = false;
        }
        this.httpUpgradeEnabled = ConfigurationHelper.getBooleanProperty("httpUpgradeEnabled", false, configuration);
        this.nioRemotingThreads = ConfigurationHelper.getIntProperty("nioRemotingThreads", -1, configuration);
        this.useNioGlobalWorkerPool = ConfigurationHelper.getBooleanProperty("useNioGlobalWorkerPool", true, configuration);
        this.useServlet = ConfigurationHelper.getBooleanProperty("useServlet", false, configuration);
        this.host = ConfigurationHelper.getStringProperty("host", "localhost", configuration);
        this.port = ConfigurationHelper.getIntProperty("port", 61616, configuration);
        this.localAddress = ConfigurationHelper.getStringProperty("localAddress", TransportConstants.DEFAULT_LOCAL_ADDRESS, configuration);
        this.localPort = ConfigurationHelper.getIntProperty("localPort", 0, configuration);
        if (this.sslEnabled) {
            this.keyStoreProvider = ConfigurationHelper.getStringProperty("keyStoreProvider", "JKS", configuration);
            this.keyStorePath = ConfigurationHelper.getStringProperty("keyStorePath", TransportConstants.DEFAULT_KEYSTORE_PATH, configuration);
            this.keyStorePassword = ConfigurationHelper.getPasswordProperty("keyStorePassword", TransportConstants.DEFAULT_KEYSTORE_PASSWORD, configuration, ActiveMQDefaultConfiguration.getPropMaskPassword(), ActiveMQDefaultConfiguration.getPropPasswordCodec());
            this.trustStoreProvider = ConfigurationHelper.getStringProperty("trustStoreProvider", "JKS", configuration);
            this.trustStorePath = ConfigurationHelper.getStringProperty("trustStorePath", TransportConstants.DEFAULT_TRUSTSTORE_PATH, configuration);
            this.trustStorePassword = ConfigurationHelper.getPasswordProperty("trustStorePassword", TransportConstants.DEFAULT_TRUSTSTORE_PASSWORD, configuration, ActiveMQDefaultConfiguration.getPropMaskPassword(), ActiveMQDefaultConfiguration.getPropPasswordCodec());
            this.enabledCipherSuites = ConfigurationHelper.getStringProperty("enabledCipherSuites", TransportConstants.DEFAULT_ENABLED_CIPHER_SUITES, configuration);
            this.enabledProtocols = ConfigurationHelper.getStringProperty("enabledProtocols", TransportConstants.DEFAULT_ENABLED_PROTOCOLS, configuration);
            this.verifyHost = ConfigurationHelper.getBooleanProperty("verifyHost", false, configuration);
        } else {
            this.keyStoreProvider = "JKS";
            this.keyStorePath = TransportConstants.DEFAULT_KEYSTORE_PATH;
            this.keyStorePassword = TransportConstants.DEFAULT_KEYSTORE_PASSWORD;
            this.trustStoreProvider = "JKS";
            this.trustStorePath = TransportConstants.DEFAULT_TRUSTSTORE_PATH;
            this.trustStorePassword = TransportConstants.DEFAULT_TRUSTSTORE_PASSWORD;
            this.enabledCipherSuites = TransportConstants.DEFAULT_ENABLED_CIPHER_SUITES;
            this.enabledProtocols = TransportConstants.DEFAULT_ENABLED_PROTOCOLS;
            this.verifyHost = false;
        }
        this.tcpNoDelay = ConfigurationHelper.getBooleanProperty("tcpNoDelay", true, configuration);
        this.tcpSendBufferSize = ConfigurationHelper.getIntProperty("tcpSendBufferSize", 32768, configuration);
        this.tcpReceiveBufferSize = ConfigurationHelper.getIntProperty("tcpReceiveBufferSize", 32768, configuration);
        this.batchDelay = ConfigurationHelper.getLongProperty("batchDelay", 0L, configuration);
        this.connectTimeoutMillis = ConfigurationHelper.getIntProperty("connect-timeout-millis", -1, configuration);
        this.closeExecutor = closeExecutor;
        this.scheduledThreadPool = scheduledThreadPool;
    }

    public String toString() {
        return "NettyConnector [host=" + this.host + ", port=" + this.port + ", httpEnabled=" + this.httpEnabled + ", httpUpgradeEnabled=" + this.httpUpgradeEnabled + ", useServlet=" + this.useServlet + ", servletPath=" + this.servletPath + ", sslEnabled=" + this.sslEnabled + ", useNio=" + true + this.getHttpUpgradeInfo() + "]";
    }

    private String getHttpUpgradeInfo() {
        if (!this.httpUpgradeEnabled) {
            return "";
        }
        String serverName = ConfigurationHelper.getStringProperty("activemqServerName", null, this.configuration);
        String acceptor = ConfigurationHelper.getStringProperty("httpUpgradeEndpoint", null, this.configuration);
        return ", activemqServerName=" + serverName + ", httpUpgradeEndpoint=" + acceptor;
    }

    @Override
    public synchronized void start() {
        SSLContext context;
        if (this.channelClazz != null) {
            return;
        }
        int threadsToUse = this.nioRemotingThreads == -1 ? Runtime.getRuntime().availableProcessors() * 3 : this.nioRemotingThreads;
        if (this.useNioGlobalWorkerPool) {
            this.channelClazz = NioSocketChannel.class;
            this.group = SharedNioEventLoopGroup.getInstance(threadsToUse);
        } else {
            this.channelClazz = NioSocketChannel.class;
            this.group = new NioEventLoopGroup(threadsToUse);
        }
        this.bootstrap = new Bootstrap();
        this.bootstrap.channel(this.channelClazz);
        this.bootstrap.group(this.group);
        this.bootstrap.option(ChannelOption.TCP_NODELAY, (Object)this.tcpNoDelay);
        if (this.connectTimeoutMillis != -1) {
            this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.connectTimeoutMillis);
        }
        if (this.tcpReceiveBufferSize != -1) {
            this.bootstrap.option(ChannelOption.SO_RCVBUF, (Object)this.tcpReceiveBufferSize);
        }
        if (this.tcpSendBufferSize != -1) {
            this.bootstrap.option(ChannelOption.SO_SNDBUF, (Object)this.tcpSendBufferSize);
        }
        this.bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        this.bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)true);
        this.channelGroup = new DefaultChannelGroup("activemq-connector", (EventExecutor)GlobalEventExecutor.INSTANCE);
        if (this.sslEnabled) {
            try {
                String realKeyStorePath = this.keyStorePath;
                String realKeyStoreProvider = this.keyStoreProvider;
                String realKeyStorePassword = this.keyStorePassword;
                if (System.getProperty(JAVAX_KEYSTORE_PATH_PROP_NAME) != null) {
                    realKeyStorePath = System.getProperty(JAVAX_KEYSTORE_PATH_PROP_NAME);
                }
                if (System.getProperty(JAVAX_KEYSTORE_PASSWORD_PROP_NAME) != null) {
                    realKeyStorePassword = System.getProperty(JAVAX_KEYSTORE_PASSWORD_PROP_NAME);
                }
                if (System.getProperty(ACTIVEMQ_KEYSTORE_PROVIDER_PROP_NAME) != null) {
                    realKeyStoreProvider = System.getProperty(ACTIVEMQ_KEYSTORE_PROVIDER_PROP_NAME);
                }
                if (System.getProperty(ACTIVEMQ_KEYSTORE_PATH_PROP_NAME) != null) {
                    realKeyStorePath = System.getProperty(ACTIVEMQ_KEYSTORE_PATH_PROP_NAME);
                }
                if (System.getProperty(ACTIVEMQ_KEYSTORE_PASSWORD_PROP_NAME) != null) {
                    realKeyStorePassword = System.getProperty(ACTIVEMQ_KEYSTORE_PASSWORD_PROP_NAME);
                }
                String realTrustStorePath = this.trustStorePath;
                String realTrustStoreProvider = this.trustStoreProvider;
                String realTrustStorePassword = this.trustStorePassword;
                if (System.getProperty(JAVAX_TRUSTSTORE_PATH_PROP_NAME) != null) {
                    realTrustStorePath = System.getProperty(JAVAX_TRUSTSTORE_PATH_PROP_NAME);
                }
                if (System.getProperty(JAVAX_TRUSTSTORE_PASSWORD_PROP_NAME) != null) {
                    realTrustStorePassword = System.getProperty(JAVAX_TRUSTSTORE_PASSWORD_PROP_NAME);
                }
                if (System.getProperty(ACTIVEMQ_TRUSTSTORE_PROVIDER_PROP_NAME) != null) {
                    realTrustStoreProvider = System.getProperty(ACTIVEMQ_TRUSTSTORE_PROVIDER_PROP_NAME);
                }
                if (System.getProperty(ACTIVEMQ_TRUSTSTORE_PATH_PROP_NAME) != null) {
                    realTrustStorePath = System.getProperty(ACTIVEMQ_TRUSTSTORE_PATH_PROP_NAME);
                }
                if (System.getProperty(ACTIVEMQ_TRUSTSTORE_PASSWORD_PROP_NAME) != null) {
                    realTrustStorePassword = System.getProperty(ACTIVEMQ_TRUSTSTORE_PASSWORD_PROP_NAME);
                }
                context = SSLSupport.createContext(realKeyStoreProvider, realKeyStorePath, realKeyStorePassword, realTrustStoreProvider, realTrustStorePath, realTrustStorePassword);
            }
            catch (Exception e) {
                this.close();
                IllegalStateException ise = new IllegalStateException("Unable to create NettyConnector for " + this.host + ":" + this.port);
                ise.initCause(e);
                throw ise;
            }
        } else {
            context = null;
        }
        if (context == null || this.useServlet) {
            // empty if block
        }
        this.bootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            public void initChannel(Channel channel) throws Exception {
                ChannelPipeline pipeline = channel.pipeline();
                if (NettyConnector.this.sslEnabled && !NettyConnector.this.useServlet) {
                    SSLEngine engine = NettyConnector.this.verifyHost ? context.createSSLEngine(NettyConnector.this.host, NettyConnector.this.port) : context.createSSLEngine();
                    engine.setUseClientMode(true);
                    engine.setWantClientAuth(true);
                    String[] originalProtocols = engine.getEnabledProtocols();
                    if (NettyConnector.this.enabledCipherSuites != null) {
                        try {
                            engine.setEnabledCipherSuites(SSLSupport.parseCommaSeparatedListIntoArray(NettyConnector.this.enabledCipherSuites));
                        }
                        catch (IllegalArgumentException e) {
                            ActiveMQClientLogger.LOGGER.invalidCipherSuite(SSLSupport.parseArrayIntoCommandSeparatedList(engine.getSupportedCipherSuites()));
                            throw e;
                        }
                    }
                    if (NettyConnector.this.enabledProtocols != null) {
                        try {
                            engine.setEnabledProtocols(SSLSupport.parseCommaSeparatedListIntoArray(NettyConnector.this.enabledProtocols));
                        }
                        catch (IllegalArgumentException e) {
                            ActiveMQClientLogger.LOGGER.invalidProtocol(SSLSupport.parseArrayIntoCommandSeparatedList(engine.getSupportedProtocols()));
                            throw e;
                        }
                    } else {
                        engine.setEnabledProtocols(originalProtocols);
                    }
                    if (NettyConnector.this.verifyHost) {
                        SSLParameters sslParameters = engine.getSSLParameters();
                        sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
                        engine.setSSLParameters(sslParameters);
                    }
                    SslHandler handler = new SslHandler(engine);
                    pipeline.addLast(new ChannelHandler[]{handler});
                }
                if (NettyConnector.this.httpEnabled) {
                    pipeline.addLast(new ChannelHandler[]{new HttpRequestEncoder()});
                    pipeline.addLast(new ChannelHandler[]{new HttpResponseDecoder()});
                    pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)});
                    pipeline.addLast(new ChannelHandler[]{new HttpHandler()});
                }
                if (NettyConnector.this.httpUpgradeEnabled) {
                    HttpClientCodec httpClientCodec = new HttpClientCodec();
                    pipeline.addLast(new ChannelHandler[]{httpClientCodec});
                    pipeline.addLast("http-upgrade", (ChannelHandler)new HttpUpgradeHandler(pipeline, httpClientCodec));
                }
                NettyConnector.this.protocolManager.addChannelHandlers(pipeline);
                pipeline.addLast(new ChannelHandler[]{new ActiveMQClientChannelHandler(NettyConnector.this.channelGroup, NettyConnector.this.handler, new Listener())});
            }
        });
        if (this.batchDelay > 0L) {
            this.flusher = new BatchFlusher();
            this.batchFlusherFuture = this.scheduledThreadPool.scheduleWithFixedDelay(this.flusher, this.batchDelay, this.batchDelay, TimeUnit.MILLISECONDS);
        }
        logger.debug((Object)("Started Netty Connector version " + TransportConstants.NETTY_VERSION));
    }

    @Override
    public synchronized void close() {
        if (this.channelClazz == null) {
            return;
        }
        if (this.batchFlusherFuture != null) {
            this.batchFlusherFuture.cancel(false);
            this.flusher.cancel();
            this.flusher = null;
            this.batchFlusherFuture = null;
        }
        this.bootstrap = null;
        this.channelGroup.close().awaitUninterruptibly();
        this.group.shutdownGracefully(100L, 3000L, TimeUnit.MILLISECONDS);
        this.channelClazz = null;
        for (Connection connection : this.connections.values()) {
            this.listener.connectionDestroyed(connection.getID());
        }
        this.connections.clear();
    }

    @Override
    public boolean isStarted() {
        return this.channelClazz != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Connection createConnection() {
        ChannelFuture future;
        Inet6Address inet6Address;
        if (this.channelClazz == null) {
            return null;
        }
        InetSocketAddress remoteDestination = new InetSocketAddress(this.host, this.port);
        InetAddress inetAddress = remoteDestination.getAddress();
        if (inetAddress instanceof Inet6Address && (inet6Address = (Inet6Address)inetAddress).getScopeId() != 0) {
            try {
                remoteDestination = new InetSocketAddress(InetAddress.getByAddress(inet6Address.getAddress()), remoteDestination.getPort());
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        logger.debug((Object)("Remote destination: " + remoteDestination));
        if (this.localPort != 0) {
            InetSocketAddress localDestination = this.localAddress != null ? new InetSocketAddress(this.localAddress, this.localPort) : new InetSocketAddress(this.localPort);
            future = this.bootstrap.connect((SocketAddress)remoteDestination, (SocketAddress)localDestination);
        } else {
            future = this.bootstrap.connect((SocketAddress)remoteDestination);
        }
        future.awaitUninterruptibly();
        if (future.isSuccess()) {
            Channel ch;
            block18: {
                ch = future.channel();
                SslHandler sslHandler = (SslHandler)ch.pipeline().get(SslHandler.class);
                if (sslHandler != null) {
                    io.netty.util.concurrent.Future handshakeFuture = sslHandler.handshakeFuture();
                    if (!handshakeFuture.awaitUninterruptibly(30000L)) {
                        ch.close().awaitUninterruptibly();
                        return null;
                    }
                    if (!handshakeFuture.isSuccess()) {
                        ch.close().awaitUninterruptibly();
                        ActiveMQClientLogger.LOGGER.errorCreatingNettyConnection(handshakeFuture.cause());
                        return null;
                    }
                    ChannelPipeline channelPipeline = ch.pipeline();
                    ActiveMQChannelHandler channelHandler = (ActiveMQChannelHandler)channelPipeline.get(ActiveMQChannelHandler.class);
                    channelHandler.active = true;
                }
                if (this.httpUpgradeEnabled) {
                    try {
                        String endpoint;
                        HttpUpgradeHandler httpUpgradeHandler = (HttpUpgradeHandler)ch.pipeline().get("http-upgrade");
                        String scheme = "http";
                        if (this.sslEnabled) {
                            scheme = "https";
                        }
                        String ipv6Host = IPV6Util.encloseHost((String)this.host);
                        URI uri = new URI(scheme, null, ipv6Host, this.port, null, null, null);
                        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, uri.getRawPath());
                        request.headers().set("Host", (Object)ipv6Host);
                        request.headers().set("Upgrade", (Object)ACTIVEMQ_REMOTING);
                        request.headers().set("Connection", (Object)"Upgrade");
                        String serverName = ConfigurationHelper.getStringProperty("activemqServerName", null, this.configuration);
                        if (serverName != null) {
                            request.headers().set("activemqServerName", (Object)serverName);
                        }
                        if ((endpoint = ConfigurationHelper.getStringProperty("httpUpgradeEndpoint", null, this.configuration)) != null) {
                            request.headers().set("httpUpgradeEndpoint", (Object)endpoint);
                        }
                        byte[] nonce = NettyConnector.randomBytes(16);
                        String key = NettyConnector.base64(nonce);
                        request.headers().set(SEC_ACTIVEMQ_REMOTING_KEY, (Object)key);
                        ch.attr(REMOTING_KEY).set((Object)key);
                        logger.debugf("Sending HTTP request %s", (Object)request);
                        ch.writeAndFlush((Object)request);
                        if (!httpUpgradeHandler.awaitHandshake()) {
                            ch.close().awaitUninterruptibly();
                            return null;
                        }
                        break block18;
                    }
                    catch (URISyntaxException e) {
                        ActiveMQClientLogger.LOGGER.errorCreatingNettyConnection(e);
                        return null;
                    }
                }
                ChannelPipeline channelPipeline = ch.pipeline();
                ActiveMQChannelHandler channelHandler = (ActiveMQChannelHandler)channelPipeline.get(ActiveMQChannelHandler.class);
                channelHandler.active = true;
            }
            Listener connectionListener = new Listener();
            NettyConnection conn = new NettyConnection(this.configuration, ch, connectionListener, !this.httpEnabled && this.batchDelay > 0L, false);
            connectionListener.connectionCreated((ActiveMQComponent)null, (Connection)conn, this.protocolManager);
            return conn;
        }
        Throwable t = future.cause();
        if (t != null && !(t instanceof ConnectException)) {
            ActiveMQClientLogger.LOGGER.errorCreatingNettyConnection(future.cause());
        }
        return null;
    }

    @Override
    public boolean isEquivalent(Map<String, Object> configuration) {
        Boolean httpUpgradeEnabled = ConfigurationHelper.getBooleanProperty("httpUpgradeEnabled", false, configuration);
        if (httpUpgradeEnabled.booleanValue()) {
            String otherActiveMQServerName = ConfigurationHelper.getStringProperty("activemqServerName", null, configuration);
            String activeMQServerName = ConfigurationHelper.getStringProperty("activemqServerName", null, this.configuration);
            boolean equivalent = this.isSameHostAndPort(configuration) && otherActiveMQServerName != null && otherActiveMQServerName.equals(activeMQServerName);
            return equivalent;
        }
        return this.isSameHostAndPort(configuration);
    }

    private boolean isSameHostAndPort(Map<String, Object> configuration) {
        String host = ConfigurationHelper.getStringProperty("host", "localhost", configuration);
        Integer port = ConfigurationHelper.getIntProperty("port", 61616, configuration);
        if (!port.equals(this.port)) {
            return false;
        }
        if (host.equals(this.host)) {
            return true;
        }
        boolean result = false;
        try {
            InetAddress inetAddr1 = InetAddress.getByName(host);
            InetAddress inetAddr2 = InetAddress.getByName(this.host);
            String ip1 = inetAddr1.getHostAddress();
            String ip2 = inetAddr2.getHostAddress();
            logger.debug((Object)(this + " host 1: " + host + " ip address: " + ip1 + " host 2: " + this.host + " ip address: " + ip2));
            result = ip1.equals(ip2);
        }
        catch (UnknownHostException e) {
            ActiveMQClientLogger.LOGGER.error("Cannot resolve host", e);
        }
        return result;
    }

    public void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public Bootstrap getBootStrap() {
        return this.bootstrap;
    }

    public static void clearThreadPools() {
        SharedNioEventLoopGroup.forceShutdown();
    }

    private static ClassLoader getThisClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClientSessionFactoryImpl.class.getClassLoader();
            }
        });
    }

    private static String base64(byte[] data) {
        ByteBuf encodedData = Unpooled.wrappedBuffer((byte[])data);
        ByteBuf encoded = Base64.encode((ByteBuf)encodedData);
        String encodedString = encoded.toString(StandardCharsets.UTF_8);
        encoded.release();
        return encodedString;
    }

    private static byte[] randomBytes(int size) {
        byte[] bytes = new byte[size];
        for (int index = 0; index < size; ++index) {
            bytes[index] = (byte)NettyConnector.randomNumber(0, 255);
        }
        return bytes;
    }

    private static int randomNumber(int minimum, int maximum) {
        return (int)(Math.random() * (double)maximum + (double)minimum);
    }

    public static String createExpectedResponse(String magicNumber, String secretKey) throws IOException {
        try {
            String concat = secretKey + magicNumber;
            MessageDigest digest = MessageDigest.getInstance("SHA1");
            digest.update(concat.getBytes(StandardCharsets.UTF_8));
            byte[] bytes = digest.digest();
            return org.apache.activemq.artemis.utils.Base64.encodeBytes((byte[])bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }

    static {
        ResourceLeakDetector.setEnabled((boolean)false);
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("host", "localhost");
        config.put("port", 61616);
        DEFAULT_CONFIG = Collections.unmodifiableMap(config);
    }

    private class BatchFlusher
    implements Runnable {
        private boolean cancelled;

        private BatchFlusher() {
        }

        @Override
        public synchronized void run() {
            if (!this.cancelled) {
                for (Connection connection : NettyConnector.this.connections.values()) {
                    connection.checkFlushBatchBuffer();
                }
            }
        }

        public synchronized void cancel() {
            this.cancelled = true;
        }
    }

    private class Listener
    implements ClientConnectionLifeCycleListener {
        private Listener() {
        }

        @Override
        public void connectionCreated(ActiveMQComponent component, Connection connection, ClientProtocolManager protocol) {
            if (NettyConnector.this.connections.putIfAbsent(connection.getID(), connection) != null) {
                throw ActiveMQClientMessageBundle.BUNDLE.connectionExists(connection.getID());
            }
            NettyConnector.this.listener.connectionCreated(component, connection, protocol);
        }

        @Override
        public void connectionDestroyed(final Object connectionID) {
            if (NettyConnector.this.connections.remove(connectionID) != null) {
                NettyConnector.this.closeExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        NettyConnector.this.listener.connectionDestroyed(connectionID);
                    }
                });
            }
        }

        @Override
        public void connectionException(final Object connectionID, final ActiveMQException me) {
            NettyConnector.this.closeExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    NettyConnector.this.listener.connectionException(connectionID, me);
                }
            });
        }

        @Override
        public void connectionReadyForWrites(Object connectionID, boolean ready) {
            NettyConnection connection = (NettyConnection)NettyConnector.this.connections.get(connectionID);
            if (connection != null) {
                connection.fireReady(ready);
            }
            NettyConnector.this.listener.connectionReadyForWrites(connectionID, ready);
        }
    }

    class HttpHandler
    extends ChannelDuplexHandler {
        private Channel channel;
        private long lastSendTime = 0L;
        private boolean waitingGet = false;
        private HttpIdleTimer task;
        private final String url;
        private final FutureLatch handShakeFuture = new FutureLatch();
        private boolean active = false;
        private boolean handshaking = false;
        private String cookie;

        HttpHandler() throws Exception {
            this.url = new URI("http", null, NettyConnector.this.host, NettyConnector.this.port, NettyConnector.this.servletPath, null, null).toString();
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            super.channelActive(ctx);
            this.channel = ctx.channel();
            if (NettyConnector.this.httpClientIdleScanPeriod > 0L) {
                this.task = new HttpIdleTimer();
                ScheduledFuture<?> future = NettyConnector.this.scheduledThreadPool.scheduleAtFixedRate(this.task, NettyConnector.this.httpClientIdleScanPeriod, NettyConnector.this.httpClientIdleScanPeriod, TimeUnit.MILLISECONDS);
                this.task.setFuture(future);
            }
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            if (this.task != null) {
                this.task.close();
            }
            super.channelInactive(ctx);
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            FullHttpResponse response = (FullHttpResponse)msg;
            if (NettyConnector.this.httpRequiresSessionId && !this.active) {
                Set cookieMap = CookieDecoder.decode((String)response.headers().get("Set-Cookie"));
                for (Cookie cookie : cookieMap) {
                    if (!cookie.getName().equals("JSESSIONID")) continue;
                    this.cookie = ClientCookieEncoder.LAX.encode((io.netty.handler.codec.http.cookie.Cookie)cookie);
                }
                this.active = true;
                this.handShakeFuture.run();
            }
            this.waitingGet = false;
            ctx.fireChannelRead((Object)response.content());
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            if (msg instanceof ByteBuf) {
                if (NettyConnector.this.httpRequiresSessionId && !this.active) {
                    if (this.handshaking) {
                        this.handshaking = true;
                    } else if (!this.handShakeFuture.await(5000L)) {
                        throw new RuntimeException("Handshake failed after timeout");
                    }
                }
                ByteBuf buf = (ByteBuf)msg;
                DefaultFullHttpRequest httpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, this.url, buf);
                httpRequest.headers().add("Host", (Object)NettyConnector.this.host);
                if (this.cookie != null) {
                    httpRequest.headers().add("Cookie", (Object)this.cookie);
                }
                httpRequest.headers().add("Content-Length", (Object)String.valueOf(buf.readableBytes()));
                ctx.write((Object)httpRequest, promise);
                this.lastSendTime = System.currentTimeMillis();
            } else {
                ctx.write(msg, promise);
                this.lastSendTime = System.currentTimeMillis();
            }
        }

        private class HttpIdleTimer
        implements Runnable {
            private boolean closed = false;
            private Future<?> future;

            private HttpIdleTimer() {
            }

            @Override
            public synchronized void run() {
                if (this.closed) {
                    return;
                }
                if (!HttpHandler.this.waitingGet && System.currentTimeMillis() > HttpHandler.this.lastSendTime + NettyConnector.this.httpMaxClientIdleTime) {
                    DefaultFullHttpRequest httpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, HttpHandler.this.url);
                    httpRequest.headers().add("Host", (Object)NettyConnector.this.host);
                    HttpHandler.this.waitingGet = true;
                    HttpHandler.this.channel.writeAndFlush((Object)httpRequest);
                }
            }

            public synchronized void setFuture(Future<?> future) {
                this.future = future;
            }

            public void close() {
                if (this.future != null) {
                    this.future.cancel(false);
                }
                this.closed = true;
            }
        }
    }

    private static class HttpUpgradeHandler
    extends SimpleChannelInboundHandler<HttpObject> {
        private final ChannelPipeline pipeline;
        private final HttpClientCodec httpClientCodec;
        private final CountDownLatch latch = new CountDownLatch(1);
        private boolean handshakeComplete = false;

        private HttpUpgradeHandler(ChannelPipeline pipeline, HttpClientCodec httpClientCodec) {
            this.pipeline = pipeline;
            this.httpClientCodec = httpClientCodec;
        }

        public void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Received msg=" + msg));
            }
            if (msg instanceof HttpResponse) {
                HttpResponse response = (HttpResponse)msg;
                if (response.getStatus().code() == HttpResponseStatus.SWITCHING_PROTOCOLS.code() && response.headers().get("Upgrade").equals(NettyConnector.ACTIVEMQ_REMOTING)) {
                    String accept = response.headers().get(NettyConnector.SEC_ACTIVEMQ_REMOTING_ACCEPT);
                    String expectedResponse = NettyConnector.createExpectedResponse(NettyConnector.MAGIC_NUMBER, (String)ctx.channel().attr(REMOTING_KEY).get());
                    if (expectedResponse.equals(accept)) {
                        this.handshakeComplete = true;
                    } else {
                        ActiveMQClientLogger.LOGGER.httpHandshakeFailed(msg);
                        ctx.close();
                        this.latch.countDown();
                    }
                    return;
                }
            } else if (msg == LastHttpContent.EMPTY_LAST_CONTENT && this.handshakeComplete) {
                this.pipeline.remove((ChannelHandler)this.httpClientCodec);
                this.pipeline.remove((ChannelHandler)this);
                ActiveMQChannelHandler channelHandler = (ActiveMQChannelHandler)this.pipeline.get(ActiveMQChannelHandler.class);
                channelHandler.active = true;
            }
            if (!this.handshakeComplete) {
                ActiveMQClientLogger.LOGGER.httpHandshakeFailed(msg);
                ctx.close();
            }
            this.latch.countDown();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            ActiveMQClientLogger.LOGGER.errorCreatingNettyConnection(cause);
            ctx.close();
        }

        public boolean awaitHandshake() {
            try {
                if (!this.latch.await(30000L, TimeUnit.MILLISECONDS)) {
                    return false;
                }
            }
            catch (InterruptedException e) {
                return false;
            }
            return this.handshakeComplete;
        }
    }

    private static final class ActiveMQClientChannelHandler
    extends ActiveMQChannelHandler {
        ActiveMQClientChannelHandler(ChannelGroup group, BufferHandler handler, ClientConnectionLifeCycleListener listener) {
            super(group, handler, listener);
        }
    }
}

