/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.client.impl;

import java.util.concurrent.Executor;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.client.SendAcknowledgementHandler;
import org.apache.activemq.artemis.utils.actors.Actor;

public class SendAcknowledgementHandlerWrapper
implements SendAcknowledgementHandler {
    private SendAcknowledgementHandler wrapped;
    private final Actor<Message> messageActor;

    public SendAcknowledgementHandlerWrapper(SendAcknowledgementHandler wrapped, Executor executor) {
        this.wrapped = wrapped;
        this.messageActor = new Actor<Message>(executor, wrapped::sendAcknowledged);
    }

    @Override
    public void sendAcknowledged(Message message) {
        ICoreMessage msg = message.toCore();
        if (!msg.isConfirmed()) {
            try {
                this.messageActor.act(message);
            }
            finally {
                msg.setConfirmed(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendFailed(Message message, Exception e) {
        ICoreMessage msg = message.toCore();
        if (!msg.isConfirmed()) {
            try {
                this.wrapped.sendFailed(message, e);
            }
            finally {
                msg.setConfirmed(true);
            }
        }
    }
}

