/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.Header;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Bits;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Headers;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class RelayHeader
extends Header {
    public static final byte DATA = 1;
    public static final byte SITE_UNREACHABLE = 2;
    public static final byte MBR_UNREACHABLE = 3;
    public static final byte SITES_UP = 4;
    public static final byte SITES_DOWN = 5;
    public static final byte TOPO_REQ = 6;
    public static final byte TOPO_RSP = 7;
    protected byte type;
    protected Address final_dest;
    protected Address original_sender;
    protected Set<String> sites;
    protected Set<String> visited_sites;
    protected boolean return_entire_cache;
    protected Header[] original_hdrs;
    protected short original_flags;

    public RelayHeader() {
    }

    public RelayHeader(byte type) {
        this.type = type;
    }

    public RelayHeader(byte type, Address final_dest, Address original_sender) {
        this(type);
        this.final_dest = final_dest;
        this.original_sender = original_sender;
    }

    @Override
    public short getMagicId() {
        return 80;
    }

    @Override
    public Supplier<? extends Header> create() {
        return RelayHeader::new;
    }

    public byte getType() {
        return this.type;
    }

    public Address getFinalDest() {
        return this.final_dest;
    }

    public RelayHeader setFinalDestination(Address d) {
        this.final_dest = d;
        return this;
    }

    public Address getOriginalSender() {
        return this.original_sender;
    }

    public RelayHeader setOriginalSender(Address s) {
        this.original_sender = s;
        return this;
    }

    public Set<String> getSites() {
        return this.sites != null ? new HashSet<String>(this.sites) : null;
    }

    public boolean hasSites() {
        return this.sites != null && !this.sites.isEmpty();
    }

    public boolean returnEntireCache() {
        return this.return_entire_cache;
    }

    public RelayHeader returnEntireCache(boolean b) {
        this.return_entire_cache = b;
        return this;
    }

    public Header[] originalHeaders() {
        return this.original_hdrs;
    }

    public RelayHeader originalHeaders(Header[] hdrs) {
        this.original_hdrs = hdrs;
        return this;
    }

    public short originalFlags() {
        return this.original_flags;
    }

    public RelayHeader originalFlags(short fl) {
        this.original_flags = fl;
        return this;
    }

    public String getSite() {
        if (this.sites == null || this.sites.isEmpty()) {
            return null;
        }
        Iterator<String> it = this.sites.iterator();
        return it.hasNext() ? it.next() : null;
    }

    public RelayHeader addToSites(Collection<String> s) {
        if (s != null) {
            if (this.sites == null) {
                this.sites = new HashSet<String>(s.size());
            }
            this.sites.addAll(s);
        }
        this.assertNonNullSites();
        return this;
    }

    public RelayHeader addToSites(String ... s) {
        if (s != null && s.length > 0) {
            if (this.sites == null) {
                this.sites = new HashSet<String>();
            }
            this.sites.addAll(Arrays.asList(s));
        }
        this.assertNonNullSites();
        return this;
    }

    public RelayHeader addToVisitedSites(String s) {
        if (this.visited_sites == null) {
            this.visited_sites = new HashSet<String>();
        }
        this.visited_sites.add(s);
        return this;
    }

    public RelayHeader addToVisitedSites(Collection<String> list) {
        if (list == null || list.isEmpty()) {
            return this;
        }
        for (String s : list) {
            this.addToVisitedSites(s);
        }
        return this;
    }

    public boolean hasVisitedSites() {
        return this.visited_sites != null && !this.visited_sites.isEmpty();
    }

    public Set<String> getVisitedSites() {
        return this.visited_sites;
    }

    public RelayHeader copy() {
        RelayHeader hdr = new RelayHeader(this.type, this.final_dest, this.original_sender).addToSites(this.sites).addToVisitedSites(this.visited_sites).returnEntireCache(this.return_entire_cache).originalHeaders(this.original_hdrs).originalFlags(this.original_flags);
        this.assertNonNullSites();
        hdr.assertNonNullSites();
        return hdr;
    }

    @Override
    public int serializedSize() {
        this.assertNonNullSites();
        return 2 + Util.size(this.final_dest) + Util.size(this.original_sender) + RelayHeader.sizeOf(this.sites) + RelayHeader.sizeOf(this.visited_sites) + 2 + Headers.marshalledSize(this.original_hdrs) + 2;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        out.writeByte(this.type);
        out.writeBoolean(this.return_entire_cache);
        Util.writeAddress(this.final_dest, out);
        Util.writeAddress(this.original_sender, out);
        out.writeInt(this.sites == null ? 0 : this.sites.size());
        if (this.sites != null) {
            for (String s : this.sites) {
                Bits.writeString(s, out);
            }
        }
        out.writeInt(this.visited_sites == null ? 0 : this.visited_sites.size());
        if (this.visited_sites != null) {
            for (String s : this.visited_sites) {
                Bits.writeString(s, out);
            }
        }
        this.assertNonNullSites();
        Headers.writeHeaders(this.original_hdrs, out, (short[])null);
        out.writeShort(this.original_flags);
    }

    @Override
    public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
        int i;
        this.type = in.readByte();
        this.return_entire_cache = in.readBoolean();
        this.final_dest = Util.readAddress(in);
        this.original_sender = Util.readAddress(in);
        int num_elements = in.readInt();
        if (num_elements > 0) {
            this.sites = new HashSet<String>(num_elements);
            for (i = 0; i < num_elements; ++i) {
                this.sites.add(Bits.readString(in));
            }
        }
        if ((num_elements = in.readInt()) > 0) {
            this.visited_sites = new HashSet<String>(num_elements);
            for (i = 0; i < num_elements; ++i) {
                this.visited_sites.add(Bits.readString(in));
            }
        }
        this.assertNonNullSites();
        this.original_hdrs = Headers.readHeaders(in);
        this.original_flags = in.readShort();
    }

    @Override
    public String toString() {
        return String.format("%s [final dest=%s, original sender=%s%s%s]", RelayHeader.typeToString(this.type), this.final_dest, this.original_sender, this.sites == null || this.sites.isEmpty() ? "" : String.format(", sites=%s", this.sites), this.visited_sites == null || this.visited_sites.isEmpty() ? "" : String.format(", visited=%s", this.visited_sites));
    }

    protected static String typeToString(byte type) {
        switch (type) {
            case 1: {
                return "DATA";
            }
            case 2: {
                return "SITE_UNREACHABLE";
            }
            case 3: {
                return "MBR_UNREACHABLE";
            }
            case 4: {
                return "SITES_UP";
            }
            case 5: {
                return "SITES_DOWN";
            }
            case 6: {
                return "TOPO_REQ";
            }
            case 7: {
                return "TOPO_RSP";
            }
        }
        return "<unknown>";
    }

    protected static int sizeOf(Collection<String> list) {
        int retval = 4;
        if (list != null) {
            for (String s : list) {
                retval += Bits.sizeUTF(s) + 1;
            }
        }
        return retval;
    }

    protected void assertNonNullSites() {
        if ((this.type == 4 || this.type == 5) && this.sites == null) {
            throw new IllegalStateException(String.format("sites cannot be null with type %s\n", this.type));
        }
    }
}

