/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.tests;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.stream.Stream;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class HexToBinary {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.printf("%s <input file> <output file>\n", HexToBinary.class.getSimpleName());
            return;
        }
        File input_file = new File(args[0]);
        File output_file = new File(args[1]);
        if (!input_file.exists()) {
            throw new FileNotFoundException(input_file.toString());
        }
        if (!output_file.exists()) {
            output_file.createNewFile();
        }
        FileWriter fw = new FileWriter(output_file.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(input_file));
            Stream<String> lines = br.lines();
            lines.forEach(sCurrentLine -> {
                if (sCurrentLine != null && !sCurrentLine.isEmpty()) {
                    String bits = Util.hexToBin(sCurrentLine);
                    try {
                        bw.write(bits);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
            bw.close();
            System.out.println("done....");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

