/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.drivers.postgres;

import org.apache.activemq.artemis.jdbc.store.sql.GenericSQLProvider;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;

public class PostgresSQLProvider
extends GenericSQLProvider {
    private static final long MAX_BLOB_SIZE = 0x40000000L;
    private final String createFileTableSQL;
    private final String[] createJournalTableSQL;

    private PostgresSQLProvider(String tName, SQLProvider.DatabaseStoreType databaseStoreType) {
        super(tName.toLowerCase(), databaseStoreType);
        this.createFileTableSQL = "CREATE TABLE " + this.tableName + "(ID BIGSERIAL, FILENAME VARCHAR(255), EXTENSION VARCHAR(10), DATA OID, PRIMARY KEY(ID))";
        this.createJournalTableSQL = new String[]{"CREATE TABLE " + this.tableName + "(id BIGINT,recordType SMALLINT,compactCount SMALLINT,txId BIGINT,userRecordType SMALLINT,variableSize INTEGER,record BYTEA,txDataSize INTEGER,txData BYTEA,txCheckNoRecords INTEGER,seq BIGINT)", "CREATE INDEX " + this.tableName + "_IDX ON " + this.tableName + " (id)"};
    }

    @Override
    public String getCreateFileTableSQL() {
        return this.createFileTableSQL;
    }

    @Override
    public String[] getCreateJournalTableSQL() {
        return this.createJournalTableSQL;
    }

    @Override
    public long getMaxBlobSize() {
        return 0x40000000L;
    }

    public static class Factory
    implements SQLProvider.Factory {
        @Override
        public SQLProvider create(String tableName, SQLProvider.DatabaseStoreType databaseStoreType) {
            return new PostgresSQLProvider(tableName, databaseStoreType);
        }
    }
}

