/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.util;

import java.util.function.Consumer;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.Experimental;

@Experimental
public class RefcountImpl<T> {
    protected byte refcount;
    protected Consumer<T> release_code;

    public RefcountImpl() {
    }

    public RefcountImpl(Consumer<T> c) {
        this.release_code = c;
    }

    public synchronized byte getRefcount() {
        return this.refcount;
    }

    public synchronized RefcountImpl<T> incr() {
        this.refcount = (byte)(this.refcount + 1);
        return this;
    }

    public synchronized RefcountImpl<T> decr(T t) {
        this.refcount = (byte)(this.refcount - 1);
        byte tmp = this.refcount;
        if (tmp == 0) {
            this.release(t);
        } else if (tmp < 0) {
            this.refcount = 0;
        }
        return this;
    }

    public RefcountImpl<T> onRelease(Consumer<T> rc) {
        this.release_code = rc;
        return this;
    }

    public String toString() {
        return String.format("%s (refcnt=%d)", super.toString(), this.refcount);
    }

    protected void release(T t) {
        if (this.release_code != null) {
            this.release_code.accept(t);
        }
    }
}

