/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.util;

import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.shaded.org.jgroups.Lifecycle;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.ManagedAttribute;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.ManagedOperation;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.Property;
import org.apache.activemq.artemis.shaded.org.jgroups.conf.AttributeType;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.TP;
import org.apache.activemq.artemis.shaded.org.jgroups.util.DirectExecutor;
import org.apache.activemq.artemis.shaded.org.jgroups.util.ShutdownRejectedExecutionHandler;
import org.apache.activemq.artemis.shaded.org.jgroups.util.ThreadFactory;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class ThreadPool
implements Lifecycle {
    protected Executor thread_pool;
    protected final TP tp;
    protected final AtomicInteger thread_dumps = new AtomicInteger();
    @Property(description="Whether or not the thread pool is enabled. If false, tasks will be run on the caller's thread")
    protected boolean enabled = true;
    @Property(description="Minimum thread pool size for the thread pool")
    protected int min_threads;
    @Property(description="Maximum thread pool size for the thread pool")
    protected int max_threads = 100;
    @Property(description="Timeout (ms) to remove idle threads from the pool", type=AttributeType.TIME)
    protected long keep_alive_time = 30000L;
    @Property(description="The number of times a thread pool needs to be full before a thread dump is logged")
    protected int thread_dumps_threshold = 1;

    public ThreadPool(TP tp) {
        this.tp = Objects.requireNonNull(tp);
    }

    public Executor getThreadPool() {
        return this.thread_pool;
    }

    public ThreadPool setThreadPool(Executor thread_pool) {
        if (this.thread_pool != null) {
            this.destroy();
        }
        this.thread_pool = thread_pool;
        return this;
    }

    public ThreadPool setThreadFactory(ThreadFactory factory) {
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.thread_pool).setThreadFactory(factory);
        }
        return this;
    }

    public boolean isShutdown() {
        return this.thread_pool instanceof ExecutorService && ((ExecutorService)this.thread_pool).isShutdown();
    }

    public int getMinThreads() {
        return this.min_threads;
    }

    public ThreadPool setMinThreads(int size) {
        this.min_threads = size;
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.thread_pool).setCorePoolSize(size);
        }
        return this;
    }

    public int getMaxThreads() {
        return this.max_threads;
    }

    public ThreadPool setMaxThreads(int size) {
        this.max_threads = size;
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.thread_pool).setMaximumPoolSize(size);
        }
        return this;
    }

    public long getKeepAliveTime() {
        return this.keep_alive_time;
    }

    public ThreadPool setKeepAliveTime(long time) {
        this.keep_alive_time = time;
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.thread_pool).setKeepAliveTime(time, TimeUnit.MILLISECONDS);
        }
        return this;
    }

    public int getThreadDumpsThreshold() {
        return this.thread_dumps_threshold;
    }

    public ThreadPool setThreadDumpsThreshold(int t) {
        this.thread_dumps_threshold = t;
        return this;
    }

    @ManagedAttribute(description="Number of thread dumps")
    public int getNumberOfThreadDumps() {
        return this.thread_dumps.get();
    }

    @ManagedOperation(description="Resets the thread_dumps counter")
    public void resetThreadDumps() {
        this.thread_dumps.set(0);
    }

    @ManagedAttribute(description="Current number of threads in the thread pool")
    public int getThreadPoolSize() {
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.thread_pool).getPoolSize();
        }
        return 0;
    }

    @ManagedAttribute(description="Current number of active threads in the thread pool")
    public int getThreadPoolSizeActive() {
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.thread_pool).getActiveCount();
        }
        return 0;
    }

    @ManagedAttribute(description="Largest number of threads in the thread pool")
    public int getLargestSize() {
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.thread_pool).getLargestPoolSize();
        }
        return 0;
    }

    @Override
    public void init() throws Exception {
        if (this.enabled) {
            if (this.tp.useVirtualThreads()) {
                this.thread_pool = Util.createFiberThreadPool();
            } else {
                this.tp.getLog().debug("thread pool min/max/keep-alive (ms): %d/%d/%d", this.min_threads, this.max_threads, this.keep_alive_time);
                this.thread_pool = ThreadPool.createThreadPool(this.min_threads, this.max_threads, this.keep_alive_time, "abort", new SynchronousQueue<Runnable>(), this.tp.getThreadFactory());
            }
        } else {
            this.thread_pool = new DirectExecutor();
        }
    }

    @Override
    public void destroy() {
        if (this.thread_pool instanceof ExecutorService) {
            ExecutorService service = (ExecutorService)this.thread_pool;
            service.shutdownNow();
            try {
                service.awaitTermination(3000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public boolean execute(Runnable task) {
        try {
            this.thread_pool.execute(task);
            return true;
        }
        catch (RejectedExecutionException ex) {
            this.tp.getMessageStats().incrNumRejectedMsgs(1);
            if (this.thread_dumps.incrementAndGet() == this.thread_dumps_threshold) {
                this.tp.getLog().fatal("%s: thread pool is full (max=%d, active=%d); thread dump (dumped once, until thread_dump is reset):\n%s", this.tp.getAddress(), this.max_threads, this.getThreadPoolSize(), Util.dumpThreads());
            }
            return false;
        }
        catch (Throwable t) {
            this.tp.getLog().error("failure submitting task to thread pool", t);
            this.tp.getMessageStats().incrNumRejectedMsgs(1);
            return false;
        }
    }

    protected static ExecutorService createThreadPool(int min_threads, int max_threads, long keep_alive_time, String rejection_policy, BlockingQueue<Runnable> queue, ThreadFactory factory) {
        ThreadPoolExecutor pool = new ThreadPoolExecutor(min_threads, max_threads, keep_alive_time, TimeUnit.MILLISECONDS, queue, factory);
        RejectedExecutionHandler handler = Util.parseRejectionPolicy(rejection_policy);
        pool.setRejectedExecutionHandler(new ShutdownRejectedExecutionHandler(handler));
        return pool;
    }
}

