/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.crypto.pem;

import de.dentrassi.crypto.pem.AbstractPemKeyStore;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

public class PemUtils {
    private static final String SOURCE_PREFIX = "source.";

    public static Map<String, AbstractPemKeyStore.Entry> loadFrom(InputStream stream, boolean chained) throws CertificateException, IOException {
        HashMap<String, AbstractPemKeyStore.Entry> result = new HashMap<String, AbstractPemKeyStore.Entry>();
        PemUtils.loadFrom(result, "pem", chained, stream);
        return result;
    }

    public static Map<String, AbstractPemKeyStore.Entry> loadFromConfiguration(InputStream stream) throws CertificateException, IOException {
        HashMap<String, AbstractPemKeyStore.Entry> result = new HashMap<String, AbstractPemKeyStore.Entry>();
        Properties p = new Properties();
        p.load(stream);
        String alias = p.getProperty("alias", "pem");
        for (String key : p.stringPropertyNames()) {
            if (!key.startsWith(SOURCE_PREFIX)) continue;
            InputStream source = PemUtils.openResource(p.getProperty(key));
            try {
                PemUtils.loadFrom(result, alias, true, source);
            }
            finally {
                if (source == null) continue;
                source.close();
            }
        }
        return result;
    }

    private static InputStream openResource(String uri) throws IOException {
        if (uri.startsWith("classpath:")) {
            return Thread.currentThread().getContextClassLoader().getResourceAsStream(uri.substring(10));
        }
        return new FileInputStream(uri.startsWith("file://") ? uri.substring(7) : uri);
    }

    private static void loadFrom(Map<String, AbstractPemKeyStore.Entry> result, String alias, boolean chained, InputStream stream) throws CertificateException, IOException {
        Object object;
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider(new BouncyCastleProvider());
        PEMParser reader = new PEMParser(new InputStreamReader(stream, StandardCharsets.UTF_8));
        ArrayList<Certificate> chain = new ArrayList<Certificate>();
        PrivateKey key = null;
        int counter = 0;
        while ((object = reader.readObject()) != null) {
            if (object instanceof X509CertificateHolder) {
                X509CertificateHolder certHolder = (X509CertificateHolder)object;
                Collection<? extends Certificate> certs = factory.generateCertificates(new ByteArrayInputStream(certHolder.getEncoded()));
                for (Certificate certificate : certs) {
                    if (chained) {
                        if (!(certificate instanceof X509Certificate)) continue;
                        chain.add(certificate);
                        continue;
                    }
                    result.put(alias + "-" + counter++, new AbstractPemKeyStore.Entry(null, new Certificate[]{certificate}));
                }
                continue;
            }
            if (object instanceof PEMKeyPair) {
                key = converter.getKeyPair((PEMKeyPair)object).getPrivate();
                continue;
            }
            if (!(object instanceof PrivateKeyInfo)) continue;
            key = converter.getPrivateKey((PrivateKeyInfo)object);
        }
        Certificate[] certificateChain = chain.isEmpty() ? null : (Certificate[])chain.toArray(new X509Certificate[chain.size()]);
        AbstractPemKeyStore.Entry e = new AbstractPemKeyStore.Entry(key, certificateChain);
        result.compute(alias, (k, v) -> {
            if (v != null) {
                return v.merge(e);
            }
            return e;
        });
    }
}

