/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence;

import java.util.function.Supplier;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.utils.Suppliers;
import org.apache.activemq.artemis.utils.collections.TypedProperties;

public class CoreMessageObjectPools {
    private final Supplier<SimpleString.ByteBufSimpleStringPool> addressDecoderPool;
    private final Supplier<TypedProperties.TypedPropertiesDecoderPools> propertiesDecoderPools;
    private final Supplier<SimpleString.StringSimpleStringPool> groupIdStringSimpleStringPool;
    private final Supplier<SimpleString.StringSimpleStringPool> addressStringSimpleStringPool;
    private final Supplier<TypedProperties.TypedPropertiesStringSimpleStringPools> propertiesStringSimpleStringPools;

    public CoreMessageObjectPools(int addressPoolCapacity, int groupIdCapacity, int propertyKeyCapacity, int propertyValueCapacity) {
        this.addressDecoderPool = Suppliers.memoize(() -> new SimpleString.ByteBufSimpleStringPool(addressPoolCapacity));
        this.propertiesDecoderPools = Suppliers.memoize(() -> new TypedProperties.TypedPropertiesDecoderPools(propertyKeyCapacity, propertyValueCapacity));
        this.groupIdStringSimpleStringPool = Suppliers.memoize(() -> new SimpleString.StringSimpleStringPool(groupIdCapacity));
        this.addressStringSimpleStringPool = Suppliers.memoize(() -> new SimpleString.StringSimpleStringPool(addressPoolCapacity));
        this.propertiesStringSimpleStringPools = Suppliers.memoize(() -> new TypedProperties.TypedPropertiesStringSimpleStringPools(propertyKeyCapacity, propertyValueCapacity));
    }

    public CoreMessageObjectPools() {
        this.addressDecoderPool = Suppliers.memoize(SimpleString.ByteBufSimpleStringPool::new);
        this.propertiesDecoderPools = Suppliers.memoize(TypedProperties.TypedPropertiesDecoderPools::new);
        this.groupIdStringSimpleStringPool = Suppliers.memoize(SimpleString.StringSimpleStringPool::new);
        this.addressStringSimpleStringPool = Suppliers.memoize(SimpleString.StringSimpleStringPool::new);
        this.propertiesStringSimpleStringPools = Suppliers.memoize(TypedProperties.TypedPropertiesStringSimpleStringPools::new);
    }

    public SimpleString.ByteBufSimpleStringPool getAddressDecoderPool() {
        return this.addressDecoderPool.get();
    }

    public SimpleString.StringSimpleStringPool getAddressStringSimpleStringPool() {
        return this.addressStringSimpleStringPool.get();
    }

    public SimpleString.StringSimpleStringPool getGroupIdStringSimpleStringPool() {
        return this.groupIdStringSimpleStringPool.get();
    }

    public TypedProperties.TypedPropertiesDecoderPools getPropertiesDecoderPools() {
        return this.propertiesDecoderPools.get();
    }

    public TypedProperties.TypedPropertiesStringSimpleStringPools getPropertiesStringSimpleStringPools() {
        return this.propertiesStringSimpleStringPools.get();
    }

    public static SimpleString cachedAddressSimpleString(String address, CoreMessageObjectPools coreMessageObjectPools) {
        return SimpleString.toSimpleString(address, coreMessageObjectPools == null ? null : coreMessageObjectPools.getAddressStringSimpleStringPool());
    }
}

