/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.stack;

import java.io.Closeable;
import java.io.DataInput;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.PhysicalAddress;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.cs.BaseServer;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.cs.Client;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.cs.Connection;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.cs.ConnectionListener;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.cs.NioClient;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.cs.ReceiverAdapter;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.cs.TcpClient;
import org.apache.activemq.artemis.shaded.org.jgroups.logging.Log;
import org.apache.activemq.artemis.shaded.org.jgroups.logging.LogFactory;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.PingData;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.GossipData;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.GossipType;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.IpAddress;
import org.apache.activemq.artemis.shaded.org.jgroups.util.ByteArrayDataInputStream;
import org.apache.activemq.artemis.shaded.org.jgroups.util.ByteArrayDataOutputStream;
import org.apache.activemq.artemis.shaded.org.jgroups.util.SocketFactory;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class RouterStub
extends ReceiverAdapter
implements Comparable<RouterStub>,
ConnectionListener {
    protected BaseServer client;
    protected IpAddress local;
    protected IpAddress remote;
    protected InetSocketAddress remote_sa;
    protected final boolean use_nio;
    protected StubReceiver receiver;
    protected CloseListener close_listener;
    protected SocketFactory socket_factory;
    protected static final Log log = LogFactory.getLog(RouterStub.class);
    protected int sock_conn_timeout = 3000;
    protected boolean tcp_nodelay = true;
    protected int linger = -1;
    protected boolean handle_heartbeats;
    protected volatile long last_heartbeat;
    protected final Map<String, List<MembersNotification>> get_members_map = new HashMap<String, List<MembersNotification>>();

    public RouterStub(InetSocketAddress local_sa, InetSocketAddress remote_sa, boolean use_nio, CloseListener l, SocketFactory sf) {
        this(local_sa, remote_sa, use_nio, l, sf, -1);
    }

    public RouterStub(InetSocketAddress local_sa, InetSocketAddress remote_sa, boolean use_nio, CloseListener l, SocketFactory sf, int linger) {
        this.local = local_sa != null ? new IpAddress(local_sa.getAddress(), local_sa.getPort()) : new IpAddress((InetAddress)null, 0);
        this.remote_sa = Objects.requireNonNull(remote_sa);
        this.use_nio = use_nio;
        this.close_listener = l;
        this.socket_factory = sf;
        this.linger = linger;
        if (this.resolveRemoteAddress()) {
            this.client = this.createClient(sf);
        }
    }

    public IpAddress local() {
        return this.local;
    }

    public IpAddress remote() {
        return this.remote;
    }

    public RouterStub receiver(StubReceiver r) {
        this.receiver = r;
        return this;
    }

    public StubReceiver receiver() {
        return this.receiver;
    }

    public boolean tcpNoDelay() {
        return this.tcp_nodelay;
    }

    public RouterStub tcpNoDelay(boolean tcp_nodelay) {
        this.tcp_nodelay = tcp_nodelay;
        return this;
    }

    public CloseListener connectionListener() {
        return this.close_listener;
    }

    public RouterStub connectionListener(CloseListener l) {
        this.close_listener = l;
        return this;
    }

    public int socketConnectionTimeout() {
        return this.sock_conn_timeout;
    }

    public RouterStub socketConnectionTimeout(int timeout) {
        this.sock_conn_timeout = timeout;
        return this;
    }

    public boolean useNio() {
        return this.use_nio;
    }

    public IpAddress gossipRouterAddress() {
        return this.remote;
    }

    public boolean isConnected() {
        return this.client != null && ((Client)((Object)this.client)).isConnected();
    }

    public RouterStub handleHeartbeats(boolean f) {
        this.handle_heartbeats = f;
        return this;
    }

    public boolean handleHeartbeats() {
        return this.handle_heartbeats;
    }

    public long lastHeartbeat() {
        return this.last_heartbeat;
    }

    public int getLinger() {
        return this.linger;
    }

    public RouterStub setLinger(int l) {
        this.linger = l;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(String group, Address addr, String logical_name, PhysicalAddress phys_addr) throws Exception {
        RouterStub routerStub = this;
        synchronized (routerStub) {
            this._doConnect();
        }
        if (this.handle_heartbeats) {
            this.last_heartbeat = System.currentTimeMillis();
        }
        try {
            this.writeRequest(new GossipData(GossipType.REGISTER, group, addr, logical_name, phys_addr));
        }
        catch (Exception ex) {
            throw new Exception(String.format("connection to %s failed: %s", group, ex));
        }
    }

    public synchronized void connect() throws Exception {
        this._doConnect();
    }

    protected void _doConnect() throws Exception {
        if (this.client != null) {
            this.client.start();
        } else if (this.resolveRemoteAddress() && (this.client = this.createClient(this.socket_factory)) != null) {
            this.client.start();
        } else {
            throw new IllegalStateException("client could not be created as remote address has not yet been resolved");
        }
    }

    public void disconnect(String group, Address addr) throws Exception {
        if (this.isConnected()) {
            this.writeRequest(new GossipData(GossipType.UNREGISTER, group, addr));
        }
    }

    public void destroy() {
        Util.close((Closeable)this.client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getMembers(String group, MembersNotification callback) throws Exception {
        if (callback == null) {
            return;
        }
        Map<String, List<MembersNotification>> map = this.get_members_map;
        synchronized (map) {
            List set = this.get_members_map.computeIfAbsent(group, k -> new ArrayList());
            set.add(callback);
        }
        try {
            this.writeRequest(new GossipData(GossipType.GET_MBRS, group, null));
        }
        catch (Exception ex) {
            this.removeResponse(group, callback);
            throw new Exception(String.format("connection to %s broken. Could not send %s request: %s", new Object[]{this.gossipRouterAddress(), GossipType.GET_MBRS, ex}));
        }
    }

    public void sendToAllMembers(String group, Address sender, byte[] data, int offset, int length) throws Exception {
        this.sendToMember(group, null, sender, data, offset, length);
    }

    public void sendToMember(String group, Address dest, Address sender, byte[] data, int offset, int length) throws Exception {
        try {
            this.writeRequest(new GossipData(GossipType.MESSAGE, group, dest, data, offset, length).setSender(sender));
        }
        catch (Exception ex) {
            throw new Exception(String.format("connection to %s broken. Could not send message to %s: %s", this.gossipRouterAddress(), dest, ex));
        }
    }

    @Override
    public void receive(Address sender, byte[] buf, int offset, int length) {
        this.receive(sender, new ByteArrayDataInputStream(buf, offset, length));
    }

    @Override
    public void receive(Address sender, DataInput in) {
        try {
            GossipData data = new GossipData();
            data.readFrom(in);
            switch (data.getType()) {
                case HEARTBEAT: {
                    break;
                }
                case MESSAGE: 
                case SUSPECT: {
                    if (this.receiver == null) break;
                    this.receiver.receive(data);
                    break;
                }
                case GET_MBRS_RSP: {
                    this.notifyResponse(data.getGroup(), data.getPingData());
                }
            }
            if (this.handle_heartbeats) {
                this.last_heartbeat = System.currentTimeMillis();
            }
        }
        catch (Exception ex) {
            log.error(Util.getMessage("FailedReadingData"), ex);
        }
    }

    @Override
    public void connectionClosed(Connection conn) {
        if (this.close_listener != null) {
            this.close_listener.closed(this);
        }
    }

    @Override
    public void connectionEstablished(Connection conn) {
    }

    @Override
    public int compareTo(RouterStub o) {
        return this.remote.compareTo(o.remote);
    }

    public int hashCode() {
        return this.remote.hashCode();
    }

    public boolean equals(Object obj) {
        return this.compareTo((RouterStub)obj) == 0;
    }

    public String toString() {
        return String.format("RouterStub[local=%s, router_host=%s %s] - age: %s", this.client != null ? this.client.localAddress() : "n/a", this.remote, this.isConnected() ? "connected" : "disconnected", Util.printTime(System.currentTimeMillis() - this.last_heartbeat, TimeUnit.MILLISECONDS));
    }

    protected boolean resolveRemoteAddress() {
        if (this.remote != null) {
            return true;
        }
        if (this.remote_sa.isUnresolved()) {
            this.remote_sa = new InetSocketAddress(this.remote_sa.getHostString(), this.remote_sa.getPort());
            if (this.remote_sa.isUnresolved()) {
                return false;
            }
        }
        this.remote = new IpAddress(this.remote_sa.getAddress(), this.remote_sa.getPort());
        return true;
    }

    protected BaseServer createClient(SocketFactory sf) {
        BaseServer cl;
        BaseServer baseServer = cl = this.use_nio ? new NioClient(this.local, this.remote) : new TcpClient(this.local, this.remote);
        if (sf != null) {
            cl.socketFactory(sf);
        }
        cl.receiver(this);
        cl.addConnectionListener(this);
        cl.socketConnectionTimeout(this.sock_conn_timeout).tcpNodelay(this.tcp_nodelay).linger(this.linger);
        return cl;
    }

    public void writeRequest(GossipData req) throws Exception {
        int size = req.serializedSize();
        ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(size + 5);
        req.writeTo(out);
        this.client.send(this.remote, out.buffer(), 0, out.position());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeResponse(String group, MembersNotification notif) {
        Map<String, List<MembersNotification>> map = this.get_members_map;
        synchronized (map) {
            List<MembersNotification> set = this.get_members_map.get(group);
            if (set == null || set.isEmpty()) {
                this.get_members_map.remove(group);
                return;
            }
            if (set.remove(notif) && set.isEmpty()) {
                this.get_members_map.remove(group);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyResponse(String group, List<PingData> list) {
        if (group == null) {
            return;
        }
        if (list == null) {
            list = Collections.emptyList();
        }
        Map<String, List<MembersNotification>> map = this.get_members_map;
        synchronized (map) {
            List<MembersNotification> set = this.get_members_map.get(group);
            while (set != null && !set.isEmpty()) {
                try {
                    MembersNotification rsp = set.remove(0);
                    rsp.members(list);
                }
                catch (Throwable t) {
                    log.error("failed notifying %s: %s", group, t);
                }
            }
            this.get_members_map.remove(group);
        }
    }

    public static interface CloseListener {
        public void closed(RouterStub var1);
    }

    public static interface StubReceiver {
        public void receive(GossipData var1);
    }

    public static interface MembersNotification {
        public void members(List<PingData> var1);
    }
}

