/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.SwappedByteBuf;
import io.netty.buffer.UnsafeByteBufUtil;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

public final class UnpooledUnsafeDirectByteBufWrapper
extends AbstractReferenceCountedByteBuf {
    private static final byte ZERO = 0;
    private ByteBuffer buffer = null;
    private int arrayOffset = -1;
    private byte[] array = null;
    private long memoryAddress = 0L;

    public UnpooledUnsafeDirectByteBufWrapper() {
        super(0);
    }

    public void wrap(long address, int length) {
        this.memoryAddress = address;
        this.arrayOffset = -1;
        this.array = null;
        this.buffer = null;
        this.clear();
        this.maxCapacity(length);
    }

    public void wrap(byte[] array, int srcIndex, int length) {
        if (array != null) {
            this.memoryAddress = 0L;
            this.arrayOffset = srcIndex;
            this.array = array;
            this.buffer = null;
            this.clear();
            this.maxCapacity(length);
        } else {
            this.reset();
        }
    }

    public void wrap(ByteBuffer buffer, int srcIndex, int length) {
        if (buffer != null) {
            this.buffer = buffer;
            if (buffer.isDirect()) {
                this.memoryAddress = PlatformDependent.directBufferAddress((ByteBuffer)buffer) + (long)srcIndex;
                this.arrayOffset = -1;
                this.array = null;
            } else {
                this.arrayOffset = srcIndex;
                this.array = buffer.array();
                this.memoryAddress = 0L;
            }
            this.clear();
            this.maxCapacity(length);
        } else {
            this.reset();
        }
    }

    public void reset() {
        this.buffer = null;
        this.memoryAddress = 0L;
        this.arrayOffset = -1;
        this.array = null;
        this.clear();
        this.maxCapacity(0);
    }

    public boolean isDirect() {
        return this.buffer != null ? this.buffer.isDirect() : false;
    }

    public int capacity() {
        return this.maxCapacity();
    }

    public ByteBuf capacity(int newCapacity) {
        if (newCapacity != this.maxCapacity()) {
            throw new IllegalArgumentException("can't set a capacity different from the max allowed one");
        }
        return this;
    }

    public ByteBufAllocator alloc() {
        return null;
    }

    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    public boolean hasArray() {
        return this.array != null;
    }

    public byte[] array() {
        return this.array;
    }

    public int arrayOffset() {
        return this.arrayOffset;
    }

    public boolean hasMemoryAddress() {
        return this.memoryAddress != 0L;
    }

    public long memoryAddress() {
        return this.memoryAddress;
    }

    protected byte _getByte(int index) {
        if (this.hasMemoryAddress()) {
            return UnsafeByteBufUtil.getByte((long)this.addr(index));
        }
        return UnsafeByteBufUtil.getByte((byte[])this.array, (int)this.idx(index));
    }

    protected short _getShort(int index) {
        if (this.hasMemoryAddress()) {
            return UnsafeByteBufUtil.getShort((long)this.addr(index));
        }
        return UnsafeByteBufUtil.getShort((byte[])this.array, (int)this.idx(index));
    }

    protected short _getShortLE(int index) {
        if (this.hasMemoryAddress()) {
            return UnsafeByteBufUtil.getShortLE((long)this.addr(index));
        }
        return UnsafeByteBufUtil.getShortLE((byte[])this.array, (int)this.idx(index));
    }

    protected int _getUnsignedMedium(int index) {
        if (this.hasMemoryAddress()) {
            return UnsafeByteBufUtil.getUnsignedMedium((long)this.addr(index));
        }
        return UnsafeByteBufUtil.getUnsignedMedium((byte[])this.array, (int)this.idx(index));
    }

    protected int _getUnsignedMediumLE(int index) {
        if (this.hasMemoryAddress()) {
            return UnsafeByteBufUtil.getUnsignedMediumLE((long)this.addr(index));
        }
        return UnsafeByteBufUtil.getUnsignedMediumLE((byte[])this.array, (int)this.idx(index));
    }

    protected int _getInt(int index) {
        if (this.hasMemoryAddress()) {
            return UnsafeByteBufUtil.getInt((long)this.addr(index));
        }
        return UnsafeByteBufUtil.getInt((byte[])this.array, (int)this.idx(index));
    }

    protected int _getIntLE(int index) {
        if (this.hasMemoryAddress()) {
            return UnsafeByteBufUtil.getIntLE((long)this.addr(index));
        }
        return UnsafeByteBufUtil.getIntLE((byte[])this.array, (int)this.idx(index));
    }

    protected long _getLong(int index) {
        if (this.hasMemoryAddress()) {
            return UnsafeByteBufUtil.getLong((long)this.addr(index));
        }
        return UnsafeByteBufUtil.getLong((byte[])this.array, (int)this.idx(index));
    }

    protected long _getLongLE(int index) {
        if (this.hasMemoryAddress()) {
            return UnsafeByteBufUtil.getLongLE((long)this.addr(index));
        }
        return UnsafeByteBufUtil.getLongLE((byte[])this.array, (int)this.idx(index));
    }

    public ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        if (this.hasMemoryAddress()) {
            UnsafeByteBufUtil.getBytes((AbstractByteBuf)this, (long)this.addr(index), (int)index, (ByteBuf)dst, (int)dstIndex, (int)length);
        } else {
            int idx = this.idx(index);
            this.checkDstIndex(idx, length, dstIndex, dst.capacity());
            UnpooledUnsafeDirectByteBufWrapper.getBytes(this.array, idx, dst, dstIndex, length);
        }
        return this;
    }

    private static void getBytes(byte[] array, int idx, ByteBuf dst, int dstIndex, int length) {
        if (dst.hasMemoryAddress()) {
            PlatformDependent.copyMemory((byte[])array, (int)idx, (long)(dst.memoryAddress() + (long)dstIndex), (long)length);
        } else if (dst.hasArray()) {
            System.arraycopy(array, idx, dst.array(), dst.arrayOffset() + dstIndex, length);
        } else {
            dst.setBytes(dstIndex, array, idx, length);
        }
    }

    public ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        if (this.hasMemoryAddress()) {
            UnsafeByteBufUtil.getBytes((AbstractByteBuf)this, (long)this.addr(index), (int)index, (byte[])dst, (int)dstIndex, (int)length);
        } else {
            int idx = this.idx(index);
            this.checkDstIndex(idx, length, dstIndex, dst.length);
            System.arraycopy(this.array, idx, dst, dstIndex, length);
        }
        return this;
    }

    public ByteBuf getBytes(int index, ByteBuffer dst) {
        if (this.hasMemoryAddress()) {
            UnsafeByteBufUtil.getBytes((AbstractByteBuf)this, (long)this.addr(index), (int)index, (ByteBuffer)dst);
        } else {
            int idx = this.idx(index);
            this.checkIndex(idx, dst.remaining());
            UnpooledUnsafeDirectByteBufWrapper.getBytes(this.array, idx, dst);
        }
        return this;
    }

    private static void getBytes(byte[] array, int idx, ByteBuffer dst) {
        if (dst.remaining() == 0) {
            return;
        }
        if (dst.isDirect()) {
            if (dst.isReadOnly()) {
                throw new ReadOnlyBufferException();
            }
            long dstAddress = PlatformDependent.directBufferAddress((ByteBuffer)dst);
            PlatformDependent.copyMemory((byte[])array, (int)idx, (long)(dstAddress + (long)dst.position()), (long)dst.remaining());
            dst.position(dst.position() + dst.remaining());
        } else if (dst.hasArray()) {
            System.arraycopy(array, idx, dst.array(), dst.arrayOffset() + dst.position(), dst.remaining());
            dst.position(dst.position() + dst.remaining());
        } else {
            dst.put(array, idx, dst.remaining());
        }
    }

    public ByteBuf readBytes(ByteBuffer dst) {
        int length = dst.remaining();
        this.checkReadableBytes(length);
        this.getBytes(this.readerIndex, dst);
        this.readerIndex += length;
        return this;
    }

    protected void _setByte(int index, int value) {
        if (this.hasMemoryAddress()) {
            UnsafeByteBufUtil.setByte((long)this.addr(index), (int)value);
        } else {
            UnsafeByteBufUtil.setByte((byte[])this.array, (int)this.idx(index), (int)value);
        }
    }

    protected void _setShort(int index, int value) {
        if (this.hasMemoryAddress()) {
            UnsafeByteBufUtil.setShort((long)this.addr(index), (int)value);
        } else {
            UnsafeByteBufUtil.setShort((byte[])this.array, (int)this.idx(index), (int)value);
        }
    }

    protected void _setShortLE(int index, int value) {
        if (this.hasMemoryAddress()) {
            UnsafeByteBufUtil.setShortLE((long)this.addr(index), (int)value);
        } else {
            UnsafeByteBufUtil.setShortLE((byte[])this.array, (int)this.idx(index), (int)value);
        }
    }

    protected void _setMedium(int index, int value) {
        if (this.hasMemoryAddress()) {
            UnsafeByteBufUtil.setMedium((long)this.addr(index), (int)value);
        } else {
            UnsafeByteBufUtil.setMedium((byte[])this.array, (int)this.idx(index), (int)value);
        }
    }

    protected void _setMediumLE(int index, int value) {
        if (this.hasMemoryAddress()) {
            UnsafeByteBufUtil.setMediumLE((long)this.addr(index), (int)value);
        } else {
            UnsafeByteBufUtil.setMediumLE((byte[])this.array, (int)this.idx(index), (int)value);
        }
    }

    protected void _setInt(int index, int value) {
        if (this.hasMemoryAddress()) {
            UnsafeByteBufUtil.setInt((long)this.addr(index), (int)value);
        } else {
            UnsafeByteBufUtil.setInt((byte[])this.array, (int)this.idx(index), (int)value);
        }
    }

    protected void _setIntLE(int index, int value) {
        if (this.hasMemoryAddress()) {
            UnsafeByteBufUtil.setIntLE((long)this.addr(index), (int)value);
        } else {
            UnsafeByteBufUtil.setIntLE((byte[])this.array, (int)this.idx(index), (int)value);
        }
    }

    protected void _setLong(int index, long value) {
        if (this.hasMemoryAddress()) {
            UnsafeByteBufUtil.setLong((long)this.addr(index), (long)value);
        } else {
            UnsafeByteBufUtil.setLong((byte[])this.array, (int)this.idx(index), (long)value);
        }
    }

    protected void _setLongLE(int index, long value) {
        if (this.hasMemoryAddress()) {
            UnsafeByteBufUtil.setLongLE((long)this.addr(index), (long)value);
        } else {
            UnsafeByteBufUtil.setLongLE((byte[])this.array, (int)this.idx(index), (long)value);
        }
    }

    public ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        if (this.hasMemoryAddress()) {
            UnsafeByteBufUtil.setBytes((AbstractByteBuf)this, (long)this.addr(index), (int)index, (ByteBuf)src, (int)srcIndex, (int)length);
        } else {
            int idx = this.idx(index);
            this.checkSrcIndex(idx, length, srcIndex, src.capacity());
            UnpooledUnsafeDirectByteBufWrapper.setBytes(this.array, idx, src, srcIndex, length);
        }
        return this;
    }

    private static void setBytes(byte[] array, int idx, ByteBuf src, int srcIndex, int length) {
        if (src.hasMemoryAddress()) {
            PlatformDependent.copyMemory((long)(src.memoryAddress() + (long)srcIndex), (byte[])array, (int)idx, (long)length);
        } else if (src.hasArray()) {
            System.arraycopy(src.array(), src.arrayOffset() + srcIndex, array, idx, length);
        } else {
            src.getBytes(srcIndex, array, idx, length);
        }
    }

    public ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        if (this.hasMemoryAddress()) {
            UnsafeByteBufUtil.setBytes((AbstractByteBuf)this, (long)this.addr(index), (int)index, (byte[])src, (int)srcIndex, (int)length);
        } else {
            int idx = this.idx(index);
            this.checkSrcIndex(idx, length, srcIndex, src.length);
            System.arraycopy(src, srcIndex, this.array, idx, length);
        }
        return this;
    }

    public ByteBuf setBytes(int index, ByteBuffer src) {
        if (this.hasMemoryAddress()) {
            UnsafeByteBufUtil.setBytes((AbstractByteBuf)this, (long)this.addr(index), (int)index, (ByteBuffer)src);
        } else {
            int idx = this.idx(index);
            this.checkSrcIndex(idx, src.remaining(), src.position(), src.capacity());
            UnpooledUnsafeDirectByteBufWrapper.setBytes(this.array, this.idx(index), src);
        }
        return this;
    }

    private static void setBytes(byte[] array, int idx, ByteBuffer src) {
        int length = src.remaining();
        if (length == 0) {
            return;
        }
        if (src.isDirect()) {
            long srcAddress = PlatformDependent.directBufferAddress((ByteBuffer)src);
            PlatformDependent.copyMemory((long)(srcAddress + (long)src.position()), (byte[])array, (int)idx, (long)length);
            src.position(src.position() + length);
        } else if (src.hasArray()) {
            System.arraycopy(src.array(), src.arrayOffset() + src.position(), array, idx, length);
            src.position(src.position() + length);
        } else {
            src.get(array, idx, src.remaining());
        }
    }

    @Deprecated
    public ByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
        throw new UnsupportedOperationException("unsupported!");
    }

    @Deprecated
    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        throw new UnsupportedOperationException("unsupported!");
    }

    @Deprecated
    public int getBytes(int index, FileChannel out, long position, int length) throws IOException {
        throw new UnsupportedOperationException("unsupported!");
    }

    @Deprecated
    public int readBytes(GatheringByteChannel out, int length) throws IOException {
        throw new UnsupportedOperationException("unsupported!");
    }

    @Deprecated
    public int readBytes(FileChannel out, long position, int length) throws IOException {
        throw new UnsupportedOperationException("unsupported!");
    }

    @Deprecated
    public int setBytes(int index, InputStream in, int length) throws IOException {
        throw new UnsupportedOperationException("unsupported!");
    }

    @Deprecated
    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        throw new UnsupportedOperationException("unsupported!");
    }

    @Deprecated
    public int setBytes(int index, FileChannel in, long position, int length) throws IOException {
        throw new UnsupportedOperationException("unsupported!");
    }

    public int nioBufferCount() {
        return this.buffer == null ? 0 : 1;
    }

    @Deprecated
    public ByteBuffer[] nioBuffers(int index, int length) {
        throw new UnsupportedOperationException("unsupported!");
    }

    @Deprecated
    public ByteBuf copy(int index, int length) {
        throw new UnsupportedOperationException("unsupported!");
    }

    @Deprecated
    public ByteBuffer internalNioBuffer(int index, int length) {
        throw new UnsupportedOperationException("cannot access directly the wrapped buffer!");
    }

    @Deprecated
    public ByteBuffer nioBuffer(int index, int length) {
        throw new UnsupportedOperationException("unsupported!");
    }

    @Deprecated
    protected void deallocate() {
    }

    public ByteBuf unwrap() {
        return null;
    }

    private long addr(int index) {
        return this.memoryAddress + (long)index;
    }

    private int idx(int index) {
        return this.arrayOffset + index;
    }

    @Deprecated
    protected SwappedByteBuf newSwappedByteBuf() {
        throw new UnsupportedOperationException("unsupported!");
    }

    public ByteBuf setZero(int index, int length) {
        if (this.hasMemoryAddress()) {
            if (length == 0) {
                return this;
            }
            this.checkIndex(index, length);
            PlatformDependent.setMemory((long)this.addr(index), (long)length, (byte)0);
        } else {
            UnsafeByteBufUtil.setZero((byte[])this.array, (int)this.idx(index), (int)length);
        }
        return this;
    }

    public ByteBuf writeZero(int length) {
        this.ensureWritable(length);
        int wIndex = this.writerIndex;
        this.setZero(wIndex, length);
        this.writerIndex = wIndex + length;
        return this;
    }
}

