/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.maven;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.Properties;
import org.apache.activemq.artemis.maven.ArtemisAbstractPlugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="runClient", defaultPhase=LifecyclePhase.VERIFY)
public class ArtemisClientPlugin
extends ArtemisAbstractPlugin {
    @Parameter
    String clientClass;
    @Parameter
    String[] args;
    @Parameter
    String classPath;
    @Parameter(defaultValue="${noClient}")
    boolean ignore;
    private Properties systemProperties;

    @Override
    protected boolean isIgnore() {
        return this.ignore;
    }

    protected ClassLoader defineClassLoader(String classPath) throws Exception {
        String[] classPathArray = classPath.split(File.pathSeparator);
        URL[] elements = new URL[classPathArray.length];
        for (int i = 0; i < classPathArray.length; ++i) {
            elements[i] = new File(classPathArray[i]).toPath().toUri().toURL();
        }
        return new URLClassLoader(elements);
    }

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        try {
            Class<?> aClass;
            if (this.systemProperties != null && !this.systemProperties.isEmpty()) {
                System.getProperties().putAll((Map<?, ?>)this.systemProperties);
            }
            if (this.classPath != null) {
                ClassLoader loader = this.defineClassLoader(this.classPath);
                aClass = loader.loadClass(this.clientClass);
            } else {
                aClass = Class.forName(this.clientClass);
            }
            Method method = aClass.getDeclaredMethod("main", String[].class);
            method.invoke(null, new Object[]{this.args});
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoFailureException(e.getMessage());
        }
    }
}

