/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.ha;

import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.DistributedPrimitiveManagerConfiguration;

public class ReplicationBackupPolicyConfiguration
implements HAPolicyConfiguration {
    private String clusterName = null;
    private int maxSavedReplicatedJournalsSize = ActiveMQDefaultConfiguration.getDefaultMaxSavedReplicatedJournalsSize();
    private String groupName = null;
    private boolean allowFailBack = false;
    private long initialReplicationSyncTimeout = ActiveMQDefaultConfiguration.getDefaultInitialReplicationSyncTimeout();
    private long retryReplicationWait = ActiveMQDefaultConfiguration.getDefaultRetryReplicationWait();
    private DistributedPrimitiveManagerConfiguration distributedManagerConfiguration = null;

    public static final ReplicationBackupPolicyConfiguration withDefault() {
        return new ReplicationBackupPolicyConfiguration();
    }

    private ReplicationBackupPolicyConfiguration() {
    }

    @Override
    public HAPolicyConfiguration.TYPE getType() {
        return HAPolicyConfiguration.TYPE.BACKUP;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public ReplicationBackupPolicyConfiguration setClusterName(String clusterName) {
        this.clusterName = clusterName;
        return this;
    }

    public int getMaxSavedReplicatedJournalsSize() {
        return this.maxSavedReplicatedJournalsSize;
    }

    public ReplicationBackupPolicyConfiguration setMaxSavedReplicatedJournalsSize(int maxSavedReplicatedJournalsSize) {
        this.maxSavedReplicatedJournalsSize = maxSavedReplicatedJournalsSize;
        return this;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public ReplicationBackupPolicyConfiguration setGroupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    public boolean isAllowFailBack() {
        return this.allowFailBack;
    }

    public ReplicationBackupPolicyConfiguration setAllowFailBack(boolean allowFailBack) {
        this.allowFailBack = allowFailBack;
        return this;
    }

    public long getInitialReplicationSyncTimeout() {
        return this.initialReplicationSyncTimeout;
    }

    public ReplicationBackupPolicyConfiguration setInitialReplicationSyncTimeout(long initialReplicationSyncTimeout) {
        this.initialReplicationSyncTimeout = initialReplicationSyncTimeout;
        return this;
    }

    public long getRetryReplicationWait() {
        return this.retryReplicationWait;
    }

    public ReplicationBackupPolicyConfiguration setRetryReplicationWait(long retryReplicationWait) {
        this.retryReplicationWait = retryReplicationWait;
        return this;
    }

    public ReplicationBackupPolicyConfiguration setDistributedManagerConfiguration(DistributedPrimitiveManagerConfiguration configuration) {
        this.distributedManagerConfiguration = configuration;
        return this;
    }

    public DistributedPrimitiveManagerConfiguration getDistributedManagerConfiguration() {
        return this.distributedManagerConfiguration;
    }
}

