/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl.invm;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.NotificationType;
import org.apache.activemq.artemis.core.remoting.impl.AbstractAcceptor;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMAcceptorFactory;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnection;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnector;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMRegistry;
import org.apache.activemq.artemis.core.security.ActiveMQPrincipal;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.cluster.ClusterConnection;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.server.management.NotificationService;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManager;
import org.apache.activemq.artemis.spi.core.remoting.BufferHandler;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.spi.core.remoting.ServerConnectionLifeCycleListener;
import org.apache.activemq.artemis.utils.ConfigurationHelper;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.actors.OrderedExecutorFactory;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.jboss.logging.Logger;

public final class InVMAcceptor
extends AbstractAcceptor {
    private final int id;
    private final BufferHandler handler;
    private final ServerConnectionLifeCycleListener listener;
    private final ConcurrentMap<String, Connection> connections = new ConcurrentHashMap<String, Connection>();
    private volatile boolean started;
    private final ExecutorFactory executorFactory;
    private final ClusterConnection clusterConnection;
    private boolean paused;
    private NotificationService notificationService;
    private final Map<String, Object> configuration;
    private ActiveMQPrincipal defaultActiveMQPrincipal;
    private final long connectionsAllowed;
    private final String name;
    private static final Logger logger = Logger.getLogger(InVMAcceptor.class);
    private final boolean enableBufferPooling;
    private final boolean directDeliver;

    public InVMAcceptor(String name, ClusterConnection clusterConnection, Map<String, Object> configuration, BufferHandler handler, ServerConnectionLifeCycleListener listener, Map<String, ProtocolManager> protocolMap, Executor threadPool) {
        super(protocolMap);
        this.name = name;
        this.clusterConnection = clusterConnection;
        this.configuration = configuration;
        this.handler = handler;
        this.listener = listener;
        this.id = ConfigurationHelper.getIntProperty((String)"serverId", (int)0, configuration);
        this.executorFactory = new OrderedExecutorFactory(threadPool);
        this.connectionsAllowed = ConfigurationHelper.getLongProperty((String)"connectionsAllowed", (long)-1L, configuration);
        this.enableBufferPooling = ConfigurationHelper.getBooleanProperty((String)"bufferPooling", (boolean)true, configuration);
        this.directDeliver = ConfigurationHelper.getBooleanProperty((String)"directDeliver", (boolean)false, configuration);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    @Override
    public ClusterConnection getClusterConnection() {
        return this.clusterConnection;
    }

    public long getConnectionsAllowed() {
        return this.connectionsAllowed;
    }

    public int getConnectionCount() {
        return this.connections.size();
    }

    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        InVMRegistry.instance.registerAcceptor(this.id, this);
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(new SimpleString("factory"), new SimpleString(InVMAcceptorFactory.class.getName()));
            props.putIntProperty(new SimpleString("id"), this.id);
            Notification notification = new Notification(null, (NotificationType)CoreNotificationType.ACCEPTOR_STARTED, props);
            this.notificationService.sendNotification(notification);
        }
        this.started = true;
        this.paused = false;
    }

    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        if (!this.paused) {
            InVMRegistry.instance.unregisterAcceptor(this.id);
        }
        for (Connection connection : this.connections.values()) {
            this.listener.connectionDestroyed(connection.getID());
        }
        this.connections.clear();
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(new SimpleString("factory"), new SimpleString(InVMAcceptorFactory.class.getName()));
            props.putIntProperty(new SimpleString("id"), this.id);
            Notification notification = new Notification(null, (NotificationType)CoreNotificationType.ACCEPTOR_STOPPED, props);
            try {
                this.notificationService.sendNotification(notification);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.failedToSendNotification(e);
            }
        }
        this.started = false;
        this.paused = false;
    }

    public synchronized boolean isStarted() {
        return this.started;
    }

    @Override
    public synchronized void pause() {
        if (!this.started || this.paused) {
            return;
        }
        InVMRegistry.instance.unregisterAcceptor(this.id);
        this.paused = true;
    }

    @Override
    public synchronized void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public BufferHandler getHandler() {
        if (!this.started) {
            throw new IllegalStateException("Acceptor is not started");
        }
        return this.handler;
    }

    public ExecutorFactory getExecutorFactory() {
        return this.executorFactory;
    }

    public void connect(String connectionID, BufferHandler remoteHandler, InVMConnector connector, Executor clientExecutor) {
        if (!this.started) {
            throw new IllegalStateException("Acceptor is not started");
        }
        Listener connectionListener = new Listener(connector);
        InVMConnection inVMConnection = new InVMConnection(this.id, connectionID, remoteHandler, connectionListener, clientExecutor, this.defaultActiveMQPrincipal);
        inVMConnection.setEnableBufferPooling(this.enableBufferPooling);
        inVMConnection.setDirectDeliver(this.directDeliver);
        connectionListener.connectionCreated((ActiveMQComponent)this, (Connection)inVMConnection, (ProtocolManager)this.protocolMap.get("CORE"));
    }

    public void disconnect(String connectionID) {
        if (!this.started) {
            return;
        }
        Connection conn = (Connection)this.connections.get(connectionID);
        if (conn != null) {
            conn.close();
        }
    }

    @Override
    public boolean isUnsecurable() {
        return true;
    }

    @Override
    public void reload() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDefaultActiveMQPrincipal(ActiveMQPrincipal defaultActiveMQPrincipal) {
        this.defaultActiveMQPrincipal = defaultActiveMQPrincipal;
    }

    private class Listener
    implements ServerConnectionLifeCycleListener {
        private final InVMConnector connector;

        Listener(InVMConnector connector) {
            this.connector = connector;
        }

        public void connectionCreated(ActiveMQComponent component, Connection connection, ProtocolManager protocol) {
            if (InVMAcceptor.this.connections.putIfAbsent((String)connection.getID(), connection) != null) {
                throw ActiveMQMessageBundle.BUNDLE.connectionExists(connection.getID());
            }
            InVMAcceptor.this.listener.connectionCreated(component, connection, protocol);
        }

        public void connectionDestroyed(final Object connectionID) {
            InVMConnection connection = (InVMConnection)InVMAcceptor.this.connections.remove(connectionID);
            if (connection != null) {
                InVMAcceptor.this.listener.connectionDestroyed(connectionID);
                connection.getExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        Listener.this.connector.disconnect((String)connectionID);
                    }
                });
            }
        }

        public void connectionException(Object connectionID, ActiveMQException me) {
            InVMAcceptor.this.listener.connectionException(connectionID, me);
        }

        public void connectionReadyForWrites(Object connectionID, boolean ready) {
        }
    }
}

