/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.routing.policies;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.activemq.artemis.core.server.routing.policies.AbstractPolicy;
import org.apache.activemq.artemis.core.server.routing.targets.Target;

public class ConsistentHashPolicy
extends AbstractPolicy {
    public static final String NAME = "CONSISTENT_HASH";

    public ConsistentHashPolicy() {
        super(NAME);
    }

    protected ConsistentHashPolicy(String name) {
        super(name);
    }

    @Override
    public Target selectTarget(List<Target> targets, String key) {
        if (targets.size() > 1) {
            TreeMap<Integer, Target> consistentTargets = new TreeMap<Integer, Target>();
            for (Target target : targets) {
                consistentTargets.put(this.getHash(target.getNodeID()), target);
            }
            if (consistentTargets.size() > 0) {
                Map.Entry consistentEntry = consistentTargets.floorEntry(this.getHash(key));
                if (consistentEntry == null) {
                    consistentEntry = consistentTargets.firstEntry();
                }
                return (Target)consistentEntry.getValue();
            }
        } else if (targets.size() > 0) {
            return targets.get(0);
        }
        return null;
    }

    protected int getHash(String str) {
        int FNV_INIT = -2128831035;
        int FNV_PRIME = 16777619;
        int hash = -2128831035;
        for (int i = 0; i < str.length(); ++i) {
            hash = (hash ^ str.charAt(i)) * 16777619;
        }
        return hash;
    }
}

