/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;

class SimpleMessageListener
implements MessageListener {
    private final String name;
    private final Map<String, String> messageReceiverMap;

    SimpleMessageListener(String listenerName, Map<String, String> messageReceiverMap) {
        this.name = listenerName;
        this.messageReceiverMap = messageReceiverMap;
    }

    public void onMessage(Message message) {
        try {
            TextMessage msg = (TextMessage)message;
            System.out.format("Message: [%s] received by %s%n", msg.getText(), this.name);
            this.messageReceiverMap.put(msg.getText(), this.name);
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }
}

