/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.junit;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Session;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.plugin.StatisticsBrokerPlugin;
import org.apache.activemq.pool.PooledConnectionFactory;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedActiveMQBroker
extends ExternalResource {
    Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    BrokerService brokerService;
    InternalClient internalClient;

    public EmbeddedActiveMQBroker() {
        this.brokerService = new BrokerService();
        this.brokerService.setUseJmx(true);
        this.brokerService.getManagementContext().setCreateConnector(false);
        this.brokerService.setUseShutdownHook(false);
        this.brokerService.setPersistent(false);
        this.brokerService.setBrokerName("embedded-broker");
    }

    public EmbeddedActiveMQBroker(String configurationURI) {
        try {
            this.brokerService = BrokerFactory.createBroker((String)configurationURI);
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception encountered creating embedded ActiveMQ broker from configuration URI: " + configurationURI, ex);
        }
    }

    public EmbeddedActiveMQBroker(URI configurationURI) {
        try {
            this.brokerService = BrokerFactory.createBroker((URI)configurationURI);
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception encountered creating embedded ActiveMQ broker from configuration URI: " + configurationURI, ex);
        }
    }

    public static void setMessageProperties(Message message, Map<String, Object> properties) {
        if (properties != null && properties.size() > 0) {
            for (Map.Entry<String, Object> property : properties.entrySet()) {
                try {
                    message.setObjectProperty(property.getKey(), property.getValue());
                }
                catch (JMSException jmsEx) {
                    throw new EmbeddedActiveMQBrokerException(String.format("Failed to set property {%s = %s}", property.getKey(), property.getValue().toString()), (Exception)((Object)jmsEx));
                }
            }
        }
    }

    protected void configure() {
    }

    public void start() {
        try {
            this.configure();
            this.brokerService.start();
            this.internalClient = new InternalClient();
            this.internalClient.start();
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception encountered starting embedded ActiveMQ broker: {}" + this.getBrokerName(), ex);
        }
        this.brokerService.waitUntilStarted();
    }

    public void stop() {
        if (this.internalClient != null) {
            this.internalClient.stop();
            this.internalClient = null;
        }
        if (!this.brokerService.isStopped()) {
            try {
                this.brokerService.stop();
            }
            catch (Exception ex) {
                this.log.warn("Exception encountered stopping embedded ActiveMQ broker: {}" + this.getBrokerName(), (Throwable)ex);
            }
        }
        this.brokerService.waitUntilStopped();
    }

    protected void before() throws Throwable {
        this.log.info("Starting embedded ActiveMQ broker: {}", (Object)this.getBrokerName());
        this.start();
        super.before();
    }

    protected void after() {
        this.log.info("Stopping Embedded ActiveMQ Broker: {}", (Object)this.getBrokerName());
        super.after();
        this.stop();
    }

    public ActiveMQConnectionFactory createConnectionFactory() {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory();
        connectionFactory.setBrokerURL(this.getVmURL());
        return connectionFactory;
    }

    public PooledConnectionFactory createPooledConnectionFactory() {
        ActiveMQConnectionFactory connectionFactory = this.createConnectionFactory();
        PooledConnectionFactory pooledConnectionFactory = new PooledConnectionFactory(connectionFactory);
        return pooledConnectionFactory;
    }

    public BrokerService getBrokerService() {
        return this.brokerService;
    }

    public String getVmURL() {
        return this.getVmURL(true);
    }

    public String getVmURL(boolean failoverURL) {
        if (failoverURL) {
            return String.format("failover:(%s?create=false)", this.brokerService.getVmConnectorURI().toString());
        }
        return this.brokerService.getVmConnectorURI().toString() + "?create=false";
    }

    public URI getVmURI() {
        return this.getVmURI(true);
    }

    public URI getVmURI(boolean failoverURI) {
        URI result;
        try {
            result = new URI(this.getVmURL(failoverURI));
        }
        catch (URISyntaxException uriEx) {
            throw new RuntimeException("Unable to create failover URI", uriEx);
        }
        return result;
    }

    public String getBrokerName() {
        return this.brokerService.getBrokerName();
    }

    public void setBrokerName(String brokerName) {
        this.brokerService.setBrokerName(brokerName);
    }

    public boolean isStatisticsPluginEnabled() {
        BrokerPlugin[] plugins = this.brokerService.getPlugins();
        if (null != plugins) {
            for (BrokerPlugin plugin : plugins) {
                if (!(plugin instanceof StatisticsBrokerPlugin)) continue;
                return true;
            }
        }
        return false;
    }

    public void enableStatisticsPlugin() {
        if (!this.isStatisticsPluginEnabled()) {
            BrokerPlugin[] newPlugins;
            BrokerPlugin[] currentPlugins = this.brokerService.getPlugins();
            if (null != currentPlugins && 0 < currentPlugins.length) {
                newPlugins = new BrokerPlugin[currentPlugins.length + 1];
                System.arraycopy(currentPlugins, 0, newPlugins, 0, currentPlugins.length);
            } else {
                newPlugins = new BrokerPlugin[1];
            }
            newPlugins[newPlugins.length - 1] = new StatisticsBrokerPlugin();
            this.brokerService.setPlugins(newPlugins);
        }
    }

    public void disableStatisticsPlugin() {
        if (this.isStatisticsPluginEnabled()) {
            BrokerPlugin[] currentPlugins = this.brokerService.getPlugins();
            if (1 < currentPlugins.length) {
                BrokerPlugin[] newPlugins = new BrokerPlugin[currentPlugins.length - 1];
                int i = 0;
                for (BrokerPlugin plugin : currentPlugins) {
                    if (plugin instanceof StatisticsBrokerPlugin) continue;
                    newPlugins[i++] = plugin;
                }
                this.brokerService.setPlugins(newPlugins);
            } else {
                this.brokerService.setPlugins(null);
            }
        }
    }

    public boolean isAdvisoryForDeliveryEnabled() {
        return this.getDefaultPolicyEntry().isAdvisoryForDelivery();
    }

    public void enableAdvisoryForDelivery() {
        this.getDefaultPolicyEntry().setAdvisoryForDelivery(true);
    }

    public void disableAdvisoryForDelivery() {
        this.getDefaultPolicyEntry().setAdvisoryForDelivery(false);
    }

    public boolean isAdvisoryForConsumedEnabled() {
        return this.getDefaultPolicyEntry().isAdvisoryForConsumed();
    }

    public void enableAdvisoryForConsumed() {
        this.getDefaultPolicyEntry().setAdvisoryForConsumed(true);
    }

    public void disableAdvisoryForConsumed() {
        this.getDefaultPolicyEntry().setAdvisoryForConsumed(false);
    }

    public boolean isAdvisoryForDiscardingMessagesEnabled() {
        return this.getDefaultPolicyEntry().isAdvisoryForDiscardingMessages();
    }

    public void enableAdvisoryForDiscardingMessages() {
        this.getDefaultPolicyEntry().setAdvisoryForDiscardingMessages(true);
    }

    public void disableAdvisoryForDiscardingMessages() {
        this.getDefaultPolicyEntry().setAdvisoryForDiscardingMessages(false);
    }

    public boolean isAdvisoryForFastProducersEnabled() {
        return this.getDefaultPolicyEntry().isAdvisoryForFastProducers();
    }

    public void enableAdvisoryForFastProducers() {
        this.getDefaultPolicyEntry().setAdvisoryForFastProducers(true);
    }

    public void disableAdvisoryForFastProducers() {
        this.getDefaultPolicyEntry().setAdvisoryForFastProducers(false);
    }

    public boolean isAdvisoryForSlowConsumersEnabled() {
        return this.getDefaultPolicyEntry().isAdvisoryForSlowConsumers();
    }

    public void enableAdvisoryForSlowConsumers() {
        this.getDefaultPolicyEntry().setAdvisoryForSlowConsumers(true);
    }

    public void disableAdvisoryForSlowConsumers() {
        this.getDefaultPolicyEntry().setAdvisoryForSlowConsumers(false);
    }

    public long getMessageCount(String destinationName) {
        if (null == this.brokerService) {
            throw new IllegalStateException("BrokerService has not yet been created - was before() called?");
        }
        Destination destination = this.getDestination(destinationName);
        if (destination == null) {
            throw new RuntimeException("Failed to find destination: " + destinationName);
        }
        return destination.getDestinationStatistics().getMessages().getCount();
    }

    public Destination getDestination(String destinationName) {
        if (null == this.brokerService) {
            throw new IllegalStateException("BrokerService has not yet been created - was before() called?");
        }
        Destination destination = null;
        try {
            destination = this.brokerService.getDestination(ActiveMQDestination.createDestination((String)destinationName, (byte)1));
        }
        catch (RuntimeException runtimeEx) {
            throw runtimeEx;
        }
        catch (Exception ex) {
            throw new EmbeddedActiveMQBrokerException("Unexpected exception getting destination from broker", ex);
        }
        return destination;
    }

    private PolicyEntry getDefaultPolicyEntry() {
        PolicyEntry defaultEntry;
        PolicyMap destinationPolicy = this.brokerService.getDestinationPolicy();
        if (null == destinationPolicy) {
            destinationPolicy = new PolicyMap();
            this.brokerService.setDestinationPolicy(destinationPolicy);
        }
        if (null == (defaultEntry = destinationPolicy.getDefaultEntry())) {
            defaultEntry = new PolicyEntry();
            destinationPolicy.setDefaultEntry(defaultEntry);
        }
        return defaultEntry;
    }

    public BytesMessage createBytesMessage() {
        return this.internalClient.createBytesMessage();
    }

    public TextMessage createTextMessage() {
        return this.internalClient.createTextMessage();
    }

    public MapMessage createMapMessage() {
        return this.internalClient.createMapMessage();
    }

    public ObjectMessage createObjectMessage() {
        return this.internalClient.createObjectMessage();
    }

    public StreamMessage createStreamMessage() {
        return this.internalClient.createStreamMessage();
    }

    public BytesMessage createMessage(byte[] body) {
        return this.createMessage(body, null);
    }

    public TextMessage createMessage(String body) {
        return this.createMessage(body, null);
    }

    public MapMessage createMessage(Map<String, Object> body) {
        return this.createMessage(body, null);
    }

    public ObjectMessage createMessage(Serializable body) {
        return this.createMessage(body, null);
    }

    public BytesMessage createMessage(byte[] body, Map<String, Object> properties) {
        BytesMessage message = this.createBytesMessage();
        if (body != null) {
            try {
                message.writeBytes(body);
            }
            catch (JMSException jmsEx) {
                throw new EmbeddedActiveMQBrokerException(String.format("Failed to set body {%s} on BytesMessage", new String(body)), (Exception)((Object)jmsEx));
            }
        }
        EmbeddedActiveMQBroker.setMessageProperties((Message)message, properties);
        return message;
    }

    public TextMessage createMessage(String body, Map<String, Object> properties) {
        TextMessage message = this.createTextMessage();
        if (body != null) {
            try {
                message.setText(body);
            }
            catch (JMSException jmsEx) {
                throw new EmbeddedActiveMQBrokerException(String.format("Failed to set body {%s} on TextMessage", body), (Exception)((Object)jmsEx));
            }
        }
        EmbeddedActiveMQBroker.setMessageProperties((Message)message, properties);
        return message;
    }

    public MapMessage createMessage(Map<String, Object> body, Map<String, Object> properties) {
        MapMessage message = this.createMapMessage();
        if (body != null) {
            for (Map.Entry<String, Object> entry : body.entrySet()) {
                try {
                    message.setObject(entry.getKey(), entry.getValue());
                }
                catch (JMSException jmsEx) {
                    throw new EmbeddedActiveMQBrokerException(String.format("Failed to set body entry {%s = %s} on MapMessage", entry.getKey(), entry.getValue().toString()), (Exception)((Object)jmsEx));
                }
            }
        }
        EmbeddedActiveMQBroker.setMessageProperties((Message)message, properties);
        return message;
    }

    public ObjectMessage createMessage(Serializable body, Map<String, Object> properties) {
        ObjectMessage message = this.createObjectMessage();
        if (body != null) {
            try {
                message.setObject(body);
            }
            catch (JMSException jmsEx) {
                throw new EmbeddedActiveMQBrokerException(String.format("Failed to set body {%s} on ObjectMessage", body.toString()), (Exception)((Object)jmsEx));
            }
        }
        EmbeddedActiveMQBroker.setMessageProperties((Message)message, properties);
        return message;
    }

    public void pushMessage(String destinationName, Message message) {
        if (destinationName == null) {
            throw new IllegalArgumentException("pushMessage failure - destination name is required");
        }
        if (message == null) {
            throw new IllegalArgumentException("pushMessage failure - a Message is required");
        }
        ActiveMQDestination destination = ActiveMQDestination.createDestination((String)destinationName, (byte)1);
        this.internalClient.pushMessage(destination, message);
    }

    public BytesMessage pushMessage(String destinationName, byte[] body) {
        BytesMessage message = this.createMessage(body, null);
        this.pushMessage(destinationName, (Message)message);
        return message;
    }

    public TextMessage pushMessage(String destinationName, String body) {
        TextMessage message = this.createMessage(body, null);
        this.pushMessage(destinationName, (Message)message);
        return message;
    }

    public MapMessage pushMessage(String destinationName, Map<String, Object> body) {
        MapMessage message = this.createMessage(body, null);
        this.pushMessage(destinationName, (Message)message);
        return message;
    }

    public ObjectMessage pushMessage(String destinationName, Serializable body) {
        ObjectMessage message = this.createMessage(body, null);
        this.pushMessage(destinationName, (Message)message);
        return message;
    }

    public BytesMessage pushMessageWithProperties(String destinationName, byte[] body, Map<String, Object> properties) {
        BytesMessage message = this.createMessage(body, properties);
        this.pushMessage(destinationName, (Message)message);
        return message;
    }

    public TextMessage pushMessageWithProperties(String destinationName, String body, Map<String, Object> properties) {
        TextMessage message = this.createMessage(body, properties);
        this.pushMessage(destinationName, (Message)message);
        return message;
    }

    public MapMessage pushMessageWithProperties(String destinationName, Map<String, Object> body, Map<String, Object> properties) {
        MapMessage message = this.createMessage(body, properties);
        this.pushMessage(destinationName, (Message)message);
        return message;
    }

    public ObjectMessage pushMessageWithProperties(String destinationName, Serializable body, Map<String, Object> properties) {
        ObjectMessage message = this.createMessage(body, properties);
        this.pushMessage(destinationName, (Message)message);
        return message;
    }

    public Message peekMessage(String destinationName) {
        if (null == this.brokerService) {
            throw new NullPointerException("peekMessage failure  - BrokerService is null");
        }
        if (destinationName == null) {
            throw new IllegalArgumentException("peekMessage failure - destination name is required");
        }
        ActiveMQDestination destination = ActiveMQDestination.createDestination((String)destinationName, (byte)1);
        Destination brokerDestination = null;
        try {
            brokerDestination = this.brokerService.getDestination(destination);
        }
        catch (Exception ex) {
            throw new EmbeddedActiveMQBrokerException("peekMessage failure - unexpected exception getting destination from BrokerService", ex);
        }
        if (brokerDestination == null) {
            throw new IllegalStateException(String.format("peekMessage failure - destination %s not found in broker %s", destination.toString(), this.brokerService.getBrokerName()));
        }
        org.apache.activemq.command.Message[] messages = brokerDestination.browse();
        if (messages != null && messages.length > 0) {
            return (Message)messages[0];
        }
        return null;
    }

    public BytesMessage peekBytesMessage(String destinationName) {
        return (BytesMessage)this.peekMessage(destinationName);
    }

    public TextMessage peekTextMessage(String destinationName) {
        return (TextMessage)this.peekMessage(destinationName);
    }

    public MapMessage peekMapMessage(String destinationName) {
        return (MapMessage)this.peekMessage(destinationName);
    }

    public ObjectMessage peekObjectMessage(String destinationName) {
        return (ObjectMessage)this.peekMessage(destinationName);
    }

    public StreamMessage peekStreamMessage(String destinationName) {
        return (StreamMessage)this.peekMessage(destinationName);
    }

    public static class EmbeddedActiveMQBrokerException
    extends RuntimeException {
        public EmbeddedActiveMQBrokerException(String message) {
            super(message);
        }

        public EmbeddedActiveMQBrokerException(String message, Exception cause) {
            super(message, cause);
        }
    }

    private class InternalClient {
        ActiveMQConnectionFactory connectionFactory;
        Connection connection;
        Session session;
        MessageProducer producer;

        void start() {
            this.connectionFactory = EmbeddedActiveMQBroker.this.createConnectionFactory();
            try {
                this.connection = this.connectionFactory.createConnection();
                this.session = this.connection.createSession(false, 1);
                this.producer = this.session.createProducer(null);
                this.connection.start();
            }
            catch (JMSException jmsEx) {
                throw new EmbeddedActiveMQBrokerException("Internal Client creation failure", (Exception)((Object)jmsEx));
            }
        }

        void stop() {
            if (null != this.connection) {
                try {
                    this.connection.close();
                }
                catch (JMSException jmsEx) {
                    EmbeddedActiveMQBroker.this.log.warn("JMSException encounter closing InternalClient connection - ignoring", (Throwable)jmsEx);
                }
            }
        }

        public BytesMessage createBytesMessage() {
            this.checkSession();
            try {
                return this.session.createBytesMessage();
            }
            catch (JMSException jmsEx) {
                throw new EmbeddedActiveMQBrokerException("Failed to create BytesMessage", (Exception)((Object)jmsEx));
            }
        }

        public TextMessage createTextMessage() {
            this.checkSession();
            try {
                return this.session.createTextMessage();
            }
            catch (JMSException jmsEx) {
                throw new EmbeddedActiveMQBrokerException("Failed to create TextMessage", (Exception)((Object)jmsEx));
            }
        }

        public MapMessage createMapMessage() {
            this.checkSession();
            try {
                return this.session.createMapMessage();
            }
            catch (JMSException jmsEx) {
                throw new EmbeddedActiveMQBrokerException("Failed to create MapMessage", (Exception)((Object)jmsEx));
            }
        }

        public ObjectMessage createObjectMessage() {
            this.checkSession();
            try {
                return this.session.createObjectMessage();
            }
            catch (JMSException jmsEx) {
                throw new EmbeddedActiveMQBrokerException("Failed to create ObjectMessage", (Exception)((Object)jmsEx));
            }
        }

        public StreamMessage createStreamMessage() {
            this.checkSession();
            try {
                return this.session.createStreamMessage();
            }
            catch (JMSException jmsEx) {
                throw new EmbeddedActiveMQBrokerException("Failed to create StreamMessage", (Exception)((Object)jmsEx));
            }
        }

        public void pushMessage(ActiveMQDestination destination, Message message) {
            if (this.producer == null) {
                throw new IllegalStateException("JMS MessageProducer is null - has the InternalClient been started?");
            }
            try {
                this.producer.send((jakarta.jms.Destination)destination, message);
            }
            catch (JMSException jmsEx) {
                throw new EmbeddedActiveMQBrokerException(String.format("Failed to push %s to %s", message.getClass().getSimpleName(), destination.toString()), (Exception)((Object)jmsEx));
            }
        }

        void checkSession() {
            if (this.session == null) {
                throw new IllegalStateException("JMS Session is null - has the InternalClient been started?");
            }
        }
    }
}

