/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.v1.model.discovery;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.atlas.v1.model.instance.Referenceable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class DSLSearchResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String requestId;
    private String queryType;
    private String query;
    private String dataType;
    private int count = 0;
    private List<Referenceable> results;

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getQueryType() {
        return this.queryType;
    }

    public void setQueryType(String queryType) {
        this.queryType = queryType;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public List<Referenceable> getResults() {
        return this.results;
    }

    public void setResults(List<Referenceable> results) {
        this.results = results;
    }

    public void addResult(Referenceable entity) {
        if (this.results == null) {
            this.results = new ArrayList<Referenceable>();
        }
        this.results.add(entity);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DSLSearchResult obj = (DSLSearchResult)o;
        return Objects.equals(this.requestId, obj.requestId) && Objects.equals(this.queryType, obj.queryType) && Objects.equals(this.query, obj.query) && Objects.equals(this.dataType, obj.dataType) && Objects.equals(this.count, obj.count) && Objects.equals(this.results, obj.results);
    }

    public int hashCode() {
        return Objects.hash(this.requestId, this.queryType, this.query, this.dataType, this.count, this.results);
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("FullTextSearchResult{").append("requestId=").append(this.requestId).append(", queryType=").append(this.queryType).append(", query=").append(this.query).append(", dataType=").append(this.dataType).append(", count=").append(this.count).append(", results=").append(this.results).append("}");
        return sb;
    }
}

