/**
 * Autogenerated by Avro
 *
 * DO NOT EDIT DIRECTLY
 */
package org.apache.avro.mapred.tether;

@SuppressWarnings("all")
/** Transmit outputs from a map or reduce task to parent. */
@org.apache.avro.specific.AvroGenerated
public interface OutputProtocol {
  public static final org.apache.avro.Protocol PROTOCOL = org.apache.avro.Protocol.parse("{\"protocol\":\"OutputProtocol\",\"namespace\":\"org.apache.avro.mapred.tether\",\"doc\":\"Transmit outputs from a map or reduce task to parent.\",\"types\":[],\"messages\":{\"configure\":{\"doc\":\"Configure task.  Sent before any other message.\",\"request\":[{\"name\":\"port\",\"type\":\"int\",\"doc\":\"The port to transmit inputs to this task on.\"}],\"response\":\"null\",\"one-way\":true},\"output\":{\"doc\":\"Send an output datum.\",\"request\":[{\"name\":\"datum\",\"type\":\"bytes\",\"doc\":\"A binary-encoded instance of the declared schema.\"}],\"response\":\"null\",\"one-way\":true},\"outputPartitioned\":{\"doc\":\"Send map output datum explicitly naming its partition.\",\"request\":[{\"name\":\"partition\",\"type\":\"int\",\"doc\":\"The map output partition for this datum.\"},{\"name\":\"datum\",\"type\":\"bytes\",\"doc\":\"A binary-encoded instance of the declared schema.\"}],\"response\":\"null\",\"one-way\":true},\"status\":{\"doc\":\"Update the task's status message.  Also acts as keepalive.\",\"request\":[{\"name\":\"message\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The new status message for the task.\"}],\"response\":\"null\",\"one-way\":true},\"count\":{\"doc\":\"Increment a task/job counter.\",\"request\":[{\"name\":\"group\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The name of the counter group.\"},{\"name\":\"name\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The name of the counter to increment.\"},{\"name\":\"amount\",\"type\":\"long\",\"doc\":\"The amount to incrment the counter.\"}],\"response\":\"null\",\"one-way\":true},\"fail\":{\"doc\":\"Called by a failing task to abort.\",\"request\":[{\"name\":\"message\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The new status message for the task.\"}],\"response\":\"null\",\"one-way\":true},\"complete\":{\"doc\":\"Called when a task's output has completed without error.\",\"request\":[],\"response\":\"null\",\"one-way\":true}}}");
  /**
   * Configure task.  Sent before any other message.
   * @param port The port to transmit inputs to this task on.
   */
  void configure(int port);
  /**
   * Send an output datum.
   * @param datum A binary-encoded instance of the declared schema.
   */
  void output(java.nio.ByteBuffer datum);
  /**
   * Send map output datum explicitly naming its partition.
   * @param partition The map output partition for this datum.
   * @param datum A binary-encoded instance of the declared schema.
   */
  void outputPartitioned(int partition, java.nio.ByteBuffer datum);
  /**
   * Update the task's status message.  Also acts as keepalive.
   * @param message The new status message for the task.
   */
  void status(java.lang.String message);
  /**
   * Increment a task/job counter.
   * @param group The name of the counter group.
   * @param name The name of the counter to increment.
   * @param amount The amount to incrment the counter.
   */
  void count(java.lang.String group, java.lang.String name, long amount);
  /**
   * Called by a failing task to abort.
   * @param message The new status message for the task.
   */
  void fail(java.lang.String message);
  /**
   * Called when a task's output has completed without error.
   */
  void complete();

  @SuppressWarnings("all")
  /** Transmit outputs from a map or reduce task to parent. */
  public interface Callback extends OutputProtocol {
    public static final org.apache.avro.Protocol PROTOCOL = org.apache.avro.mapred.tether.OutputProtocol.PROTOCOL;
  }
}