/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mojo;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Protocol;
import org.apache.avro.compiler.idl.Idl;
import org.apache.avro.compiler.idl.ParseException;
import org.apache.avro.compiler.specific.SpecificCompiler;
import org.apache.avro.generic.GenericData;
import org.apache.avro.mojo.AbstractAvroMojo;
import org.apache.maven.artifact.DependencyResolutionRequiredException;

public class IDLProtocolMojo
extends AbstractAvroMojo {
    private String[] includes = new String[]{"**/*.avdl"};
    private String[] testIncludes = new String[]{"**/*.avdl"};

    @Override
    protected void doCompile(String filename, File sourceDirectory, File outputDirectory) throws IOException {
        try {
            List runtimeClasspathElements = this.project.getRuntimeClasspathElements();
            ArrayList<URL> runtimeUrls = new ArrayList<URL>();
            runtimeUrls.add(sourceDirectory.toURI().toURL());
            if (runtimeClasspathElements != null && !runtimeClasspathElements.isEmpty()) {
                for (Object runtimeClasspathElement : runtimeClasspathElements) {
                    String element = (String)runtimeClasspathElement;
                    runtimeUrls.add(new File(element).toURI().toURL());
                }
            }
            URLClassLoader projPathLoader = new URLClassLoader(runtimeUrls.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
            Idl parser = new Idl(new File(sourceDirectory, filename), (ClassLoader)projPathLoader);
            Protocol p = parser.CompilationUnit();
            String json = p.toString(true);
            Protocol protocol = Protocol.parse((String)json);
            SpecificCompiler compiler = new SpecificCompiler(protocol);
            compiler.setStringType(GenericData.StringType.valueOf((String)this.stringType));
            compiler.setTemplateDir(this.templateDirectory);
            compiler.setFieldVisibility(this.getFieldVisibility());
            compiler.setCreateSetters(this.createSetters);
            compiler.setEnableDecimalLogicalType(this.enableDecimalLogicalType);
            compiler.compileToDestination(null, outputDirectory);
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
        catch (DependencyResolutionRequiredException drre) {
            throw new IOException(drre);
        }
    }

    @Override
    protected String[] getIncludes() {
        return this.includes;
    }

    @Override
    protected String[] getTestIncludes() {
        return this.testIncludes;
    }
}

