/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.databinding.types.xsd;

import java.util.Vector;
import javax.activation.DataHandler;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axis2.databinding.ADBBean;
import org.apache.axis2.databinding.ADBDataSource;
import org.apache.axis2.databinding.ADBException;
import org.apache.axis2.databinding.utils.BeanUtil;
import org.apache.axis2.databinding.utils.ConverterUtil;

public class Base64
implements ADBBean {
    public static final QName MY_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "base64", "xsd");
    protected DataHandler localBase64;

    private static String generatePrefix(String namespace) {
        if (namespace.equals("http://www.w3.org/2001/XMLSchema")) {
            return "xsd";
        }
        return BeanUtil.getUniquePrefix();
    }

    public DataHandler getBase64() {
        return this.localBase64;
    }

    public void setBase64(DataHandler param) {
        this.localBase64 = param;
    }

    public String toString() {
        return this.localBase64.toString();
    }

    public static boolean isReaderMTOMAware(XMLStreamReader reader) {
        boolean isReaderMTOMAware = false;
        try {
            isReaderMTOMAware = Boolean.TRUE.equals(reader.getProperty("IsDatahandlersAwareParsing"));
        }
        catch (IllegalArgumentException e) {
            isReaderMTOMAware = false;
        }
        return isReaderMTOMAware;
    }

    public OMElement getOMElement(QName parentQName, OMFactory factory) throws ADBException {
        ADBDataSource dataSource = new ADBDataSource(this, MY_QNAME);
        return factory.createOMElement((OMDataSource)dataSource, MY_QNAME);
    }

    public void serialize(QName parentQName, XMLStreamWriter xmlWriter) throws XMLStreamException, ADBException {
        this.serialize(parentQName, xmlWriter, false);
    }

    public void serialize(QName parentQName, XMLStreamWriter xmlWriter, boolean serializeType) throws XMLStreamException, ADBException {
        String namespace = parentQName.getNamespaceURI();
        String localName = parentQName.getLocalPart();
        if (!namespace.equals("")) {
            String prefix = xmlWriter.getPrefix(namespace);
            if (prefix == null) {
                prefix = Base64.generatePrefix(namespace);
                xmlWriter.writeStartElement(prefix, localName, namespace);
                xmlWriter.writeNamespace(prefix, namespace);
                xmlWriter.setPrefix(prefix, namespace);
            } else {
                xmlWriter.writeStartElement(namespace, localName);
            }
        } else {
            xmlWriter.writeStartElement(localName);
        }
        if (serializeType) {
            String namespacePrefix = this.registerPrefix(xmlWriter, "http://www.w3.org/2001/XMLSchema");
            if (namespacePrefix != null && namespacePrefix.trim().length() > 0) {
                this.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type", namespacePrefix + ":base64", xmlWriter);
            } else {
                this.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type", "base64", xmlWriter);
            }
        }
        if (this.localBase64 == null) {
            throw new ADBException("Value cannot be null !!");
        }
        xmlWriter.writeCharacters(ConverterUtil.convertToString(this.localBase64));
        xmlWriter.writeEndElement();
    }

    private void writeAttribute(String prefix, String namespace, String attName, String attValue, XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (xmlWriter.getPrefix(namespace) == null) {
            xmlWriter.writeNamespace(prefix, namespace);
            xmlWriter.setPrefix(prefix, namespace);
        }
        xmlWriter.writeAttribute(namespace, attName, attValue);
    }

    private void writeAttribute(String namespace, String attName, String attValue, XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (namespace.equals("")) {
            xmlWriter.writeAttribute(attName, attValue);
        } else {
            this.registerPrefix(xmlWriter, namespace);
            xmlWriter.writeAttribute(namespace, attName, attValue);
        }
    }

    private void writeQNameAttribute(String namespace, String attName, QName qname, XMLStreamWriter xmlWriter) throws XMLStreamException {
        String attributeNamespace = qname.getNamespaceURI();
        String attributePrefix = xmlWriter.getPrefix(attributeNamespace);
        if (attributePrefix == null) {
            attributePrefix = this.registerPrefix(xmlWriter, attributeNamespace);
        }
        String attributeValue = attributePrefix.trim().length() > 0 ? attributePrefix + ":" + qname.getLocalPart() : qname.getLocalPart();
        if (namespace.equals("")) {
            xmlWriter.writeAttribute(attName, attributeValue);
        } else {
            this.registerPrefix(xmlWriter, namespace);
            xmlWriter.writeAttribute(namespace, attName, attributeValue);
        }
    }

    private void writeQName(QName qname, XMLStreamWriter xmlWriter) throws XMLStreamException {
        String namespaceURI = qname.getNamespaceURI();
        if (namespaceURI != null) {
            String prefix = xmlWriter.getPrefix(namespaceURI);
            if (prefix == null) {
                prefix = Base64.generatePrefix(namespaceURI);
                xmlWriter.writeNamespace(prefix, namespaceURI);
                xmlWriter.setPrefix(prefix, namespaceURI);
            }
            if (prefix.trim().length() > 0) {
                xmlWriter.writeCharacters(prefix + ":" + ConverterUtil.convertToString(qname));
            } else {
                xmlWriter.writeCharacters(ConverterUtil.convertToString(qname));
            }
        } else {
            xmlWriter.writeCharacters(ConverterUtil.convertToString(qname));
        }
    }

    private void writeQNames(QName[] qnames, XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (qnames != null) {
            StringBuffer stringToWrite = new StringBuffer();
            String namespaceURI = null;
            String prefix = null;
            for (int i = 0; i < qnames.length; ++i) {
                if (i > 0) {
                    stringToWrite.append(" ");
                }
                if ((namespaceURI = qnames[i].getNamespaceURI()) != null) {
                    prefix = xmlWriter.getPrefix(namespaceURI);
                    if (prefix == null || prefix.length() == 0) {
                        prefix = Base64.generatePrefix(namespaceURI);
                        xmlWriter.writeNamespace(prefix, namespaceURI);
                        xmlWriter.setPrefix(prefix, namespaceURI);
                    }
                    if (prefix.trim().length() > 0) {
                        stringToWrite.append(prefix).append(":").append(ConverterUtil.convertToString(qnames[i]));
                        continue;
                    }
                    stringToWrite.append(ConverterUtil.convertToString(qnames[i]));
                    continue;
                }
                stringToWrite.append(ConverterUtil.convertToString(qnames[i]));
            }
            xmlWriter.writeCharacters(stringToWrite.toString());
        }
    }

    private String registerPrefix(XMLStreamWriter xmlWriter, String namespace) throws XMLStreamException {
        String prefix = xmlWriter.getPrefix(namespace);
        if (prefix == null) {
            String uri;
            prefix = Base64.generatePrefix(namespace);
            NamespaceContext nsContext = xmlWriter.getNamespaceContext();
            while ((uri = nsContext.getNamespaceURI(prefix)) != null && uri.length() != 0) {
                prefix = BeanUtil.getUniquePrefix();
            }
            xmlWriter.writeNamespace(prefix, namespace);
            xmlWriter.setPrefix(prefix, namespace);
        }
        return prefix;
    }

    public static class Factory {
        public static Base64 fromString(String value, String namespaceURI) {
            Base64 returnValue = new Base64();
            returnValue.setBase64(ConverterUtil.convertToBase64Binary(value));
            return returnValue;
        }

        public static Base64 fromString(XMLStreamReader xmlStreamReader, String content) {
            if (content.indexOf(":") > -1) {
                String prefix = content.substring(0, content.indexOf(":"));
                String namespaceUri = xmlStreamReader.getNamespaceContext().getNamespaceURI(prefix);
                return Factory.fromString(content, namespaceUri);
            }
            return Factory.fromString(content, "");
        }

        public static Base64 parse(XMLStreamReader reader) throws Exception {
            Base64 object = new Base64();
            Object nillableValue = null;
            String prefix = "";
            String namespaceuri = "";
            try {
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                Vector handledAttributes = new Vector();
                while (!reader.isEndElement()) {
                    if (reader.isStartElement() || reader.hasText()) {
                        if (reader.isStartElement() || reader.hasText()) {
                            String content = reader.getElementText();
                            object.setBase64(ConverterUtil.convertToBase64Binary(content));
                            continue;
                        }
                        throw new ADBException("Unexpected subelement " + reader.getLocalName());
                    }
                    reader.next();
                }
            }
            catch (XMLStreamException e) {
                throw new Exception(e);
            }
            return object;
        }
    }
}

