/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.addressing.metadata;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WSDLLocation {
    private static final Log log = LogFactory.getLog(WSDLLocation.class);
    private static final QName WSDLI = new QName("http://www.w3.org/2006/01/wsdl-instance", "wsdlLocation", "wsdli");
    private static final QName FINAL_WSDLI = new QName("http://www.w3.org/ns/wsdl-instance", "wsdlLocation", "wsdli");
    private String targetNamespace;
    private String wsdlURL;

    public WSDLLocation() {
    }

    public WSDLLocation(String targetNamespace, String wsdlURL) {
        this.targetNamespace = targetNamespace;
        this.wsdlURL = wsdlURL;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public String getLocation() {
        return this.wsdlURL;
    }

    public void setLocation(String wsdlURL) {
        this.wsdlURL = wsdlURL;
    }

    public OMAttribute toOM(OMFactory factory) {
        String value = new StringBuffer(this.targetNamespace).append(" ").append(this.wsdlURL).toString();
        OMNamespace wsdliNs = factory.createOMNamespace(FINAL_WSDLI.getNamespaceURI(), FINAL_WSDLI.getPrefix());
        OMAttribute omAttribute = factory.createOMAttribute(FINAL_WSDLI.getLocalPart(), wsdliNs, value);
        return omAttribute;
    }

    public void fromOM(OMAttribute omAttribute) throws AxisFault {
        QName qname = omAttribute.getQName();
        if (WSDLI.equals(qname) || FINAL_WSDLI.equals(qname)) {
            String value = omAttribute.getAttributeValue().trim();
            String[] values = value.split("\\s", 2);
            if (values.length != 2) {
                return;
            }
            this.targetNamespace = values[0];
            this.wsdlURL = values[1];
            if (log.isDebugEnabled()) {
                log.debug((Object)("fromOM: Extracted WSDLLocation targetNamespace = " + this.targetNamespace + " and wsdlURL = " + this.wsdlURL + " from an OMAttribute with QName = " + qname));
            }
        } else {
            throw new AxisFault("Unrecognized element.");
        }
    }

    public static boolean isWSDLLocationAttribute(OMAttribute omAttribute) {
        boolean result = false;
        QName qname = omAttribute.getQName();
        if (WSDLI.equals(qname) || FINAL_WSDLI.equals(qname)) {
            result = true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("isWSDLLocationAttribute: OMAttribute QName = " + qname + ", result = " + result));
        }
        return result;
    }
}

