/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.classloader;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.axis2.classloader.AbstractUrlResourceLocation;
import org.apache.axis2.classloader.DirectoryResourceLocation;
import org.apache.axis2.classloader.JarResourceLocation;
import org.apache.axis2.classloader.ResourceEnumeration;
import org.apache.axis2.classloader.ResourceFinder;
import org.apache.axis2.classloader.ResourceHandle;
import org.apache.axis2.classloader.ResourceLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlResourceFinder
implements ResourceFinder {
    private final Object lock = new Object();
    private final LinkedHashSet<URL> urls = new LinkedHashSet();
    private final LinkedHashMap<URL, ResourceLocation> classPath = new LinkedHashMap();
    private final LinkedHashSet<File> watchedFiles = new LinkedHashSet();
    private boolean destroyed = false;

    public UrlResourceFinder() {
    }

    public UrlResourceFinder(URL[] urls) {
        this.addUrls(urls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.lock;
        synchronized (object) {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
            this.urls.clear();
            for (ResourceLocation resourceLocation : this.classPath.values()) {
                resourceLocation.close();
            }
            this.classPath.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceHandle getResource(String resourceName) {
        Object object = this.lock;
        synchronized (object) {
            if (this.destroyed) {
                return null;
            }
            for (Map.Entry<URL, ResourceLocation> entry : this.getClassPath().entrySet()) {
                ResourceLocation resourceLocation = entry.getValue();
                ResourceHandle resourceHandle = resourceLocation.getResourceHandle(resourceName);
                if (resourceHandle == null || resourceHandle.isDirectory()) continue;
                return resourceHandle;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL findResource(String resourceName) {
        Object object = this.lock;
        synchronized (object) {
            if (this.destroyed) {
                return null;
            }
            for (Map.Entry<URL, ResourceLocation> entry : this.getClassPath().entrySet()) {
                ResourceLocation resourceLocation = entry.getValue();
                ResourceHandle resourceHandle = resourceLocation.getResourceHandle(resourceName);
                if (resourceHandle == null) continue;
                return resourceHandle.getUrl();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration findResources(String resourceName) {
        Object object = this.lock;
        synchronized (object) {
            return new ResourceEnumeration(new ArrayList<ResourceLocation>(this.getClassPath().values()), resourceName);
        }
    }

    public void addUrl(URL url) {
        this.addUrls(Collections.singletonList(url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL[] getUrls() {
        Object object = this.lock;
        synchronized (object) {
            return this.urls.toArray(new URL[this.urls.size()]);
        }
    }

    protected void addUrls(URL[] urls) {
        this.addUrls(Arrays.asList(urls));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addUrls(List<URL> urls) {
        Object object = this.lock;
        synchronized (object) {
            if (this.destroyed) {
                throw new IllegalStateException("UrlResourceFinder has been destroyed");
            }
            boolean shouldRebuild = this.urls.addAll(urls);
            if (shouldRebuild) {
                this.rebuildClassPath();
            }
        }
    }

    private LinkedHashMap<URL, ResourceLocation> getClassPath() {
        assert (Thread.holdsLock(this.lock)) : "This method can only be called while holding the lock";
        for (File file : this.watchedFiles) {
            if (!file.canRead()) continue;
            this.rebuildClassPath();
            break;
        }
        return this.classPath;
    }

    private void rebuildClassPath() {
        assert (Thread.holdsLock(this.lock)) : "This method can only be called while holding the lock";
        LinkedHashMap<URL, ResourceLocation> existingJarFiles = new LinkedHashMap<URL, ResourceLocation>(this.classPath);
        this.classPath.clear();
        LinkedList<URL> locationStack = new LinkedList<URL>(this.urls);
        try {
            while (!locationStack.isEmpty()) {
                ResourceLocation resourceLocation;
                block12: {
                    URL url = locationStack.removeFirst();
                    if (this.classPath.containsKey(url)) continue;
                    resourceLocation = (ResourceLocation)existingJarFiles.remove(url);
                    if (resourceLocation == null) {
                        try {
                            File file = this.cacheUrl(url);
                            resourceLocation = this.createResourceLocation(url, file);
                        }
                        catch (FileNotFoundException e) {
                            if (!"file".equals(url.getProtocol())) break block12;
                            try {
                                File file = new File(url.toURI());
                                this.watchedFiles.add(file);
                                continue;
                            }
                            catch (URISyntaxException uRISyntaxException) {
                            }
                        }
                        catch (IOException ignored) {
                            continue;
                        }
                        catch (UnsupportedOperationException ex) {
                            System.out.println("The protocol for the JAR file's URL is not supported" + ex);
                            continue;
                        }
                    }
                }
                this.classPath.put(resourceLocation.getCodeSource(), resourceLocation);
                List<URL> manifestClassPath = this.getManifestClassPath(resourceLocation);
                locationStack.addAll(0, manifestClassPath);
            }
        }
        catch (Error e) {
            this.destroy();
            throw e;
        }
        for (ResourceLocation resourceLocation : existingJarFiles.values()) {
            resourceLocation.close();
        }
    }

    protected File cacheUrl(URL url) throws IOException {
        File file;
        if (!"file".equals(url.getProtocol())) {
            throw new UnsupportedOperationException("Only local file jars are supported " + url);
        }
        try {
            file = new File(url.toURI());
        }
        catch (URISyntaxException ex) {
            throw new IOException("Invalid file URL");
        }
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        if (!file.canRead()) {
            throw new IOException("File is not readable: " + file.getAbsolutePath());
        }
        return file;
    }

    protected ResourceLocation createResourceLocation(URL codeSource, File cacheFile) throws IOException {
        if (!cacheFile.exists()) {
            throw new FileNotFoundException(cacheFile.getAbsolutePath());
        }
        if (!cacheFile.canRead()) {
            throw new IOException("File is not readable: " + cacheFile.getAbsolutePath());
        }
        AbstractUrlResourceLocation resourceLocation = cacheFile.isDirectory() ? new DirectoryResourceLocation(cacheFile) : new JarResourceLocation(codeSource, cacheFile);
        return resourceLocation;
    }

    private List<URL> getManifestClassPath(ResourceLocation resourceLocation) {
        try {
            Manifest manifest = resourceLocation.getManifest();
            if (manifest == null) {
                return Collections.EMPTY_LIST;
            }
            String manifestClassPath = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
            if (manifestClassPath == null) {
                return Collections.EMPTY_LIST;
            }
            URL codeSource = resourceLocation.getCodeSource();
            LinkedList<URL> classPathUrls = new LinkedList<URL>();
            StringTokenizer tokenizer = new StringTokenizer(manifestClassPath, " ");
            while (tokenizer.hasMoreTokens()) {
                String entry = tokenizer.nextToken();
                try {
                    URL entryUrl = new URL(codeSource, entry);
                    classPathUrls.addLast(entryUrl);
                }
                catch (MalformedURLException malformedURLException) {}
            }
            return classPathUrls;
        }
        catch (IOException ignored) {
            return Collections.EMPTY_LIST;
        }
    }
}

