/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf;

import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class Main {
    private static final String ARG_IN = "-in";
    private static final String ARG_LANG = "-lang";
    private static final String ARG_OUT = "-out";
    private static final String DEFAULT_IN_FILE_NAME = "<STDIN>";
    private static final String DEFAULT_CLASS_NAME = "Test";

    public static void main(String[] args) throws IOException {
        InputStreamReader in;
        ScriptEngineManager mgr;
        List engineFactories;
        if (args.length == 0 || args.length % 2 != 0) {
            Main.printHelp();
            System.exit(1);
        }
        Hashtable<String, String> argsTable = new Hashtable<String, String>();
        argsTable.put(ARG_OUT, DEFAULT_CLASS_NAME);
        for (int i = 0; i < args.length; i += 2) {
            argsTable.put(args[i], args[i + 1]);
        }
        String inFileName = (String)argsTable.get(ARG_IN);
        String language = (String)argsTable.get(ARG_LANG);
        if (language == null && inFileName != null) {
            int i = inFileName.lastIndexOf(46);
            if (i > 0) {
                language = inFileName.substring(i + 1);
            }
            if (language == null) {
                throw new IllegalArgumentException("unable to determine language");
            }
        }
        if ((engineFactories = (mgr = new ScriptEngineManager()).getEngineFactories()).isEmpty()) {
            throw new RuntimeException("Could not find any engine factories");
        }
        if (inFileName != null) {
            in = new FileReader(inFileName);
        } else {
            in = new InputStreamReader(System.in);
            inFileName = DEFAULT_IN_FILE_NAME;
        }
        try {
            ScriptEngine engine = mgr.getEngineByExtension(language);
            if (engine == null) {
                throw new IllegalArgumentException("unable to find engine using Extension: " + language);
            }
            Bindings bindings = engine.getBindings(100);
            bindings.put("args", args);
            Object obj = engine.eval(in);
            System.err.println("Result: " + obj);
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
    }

    private static void printHelp() {
        System.err.println("Usage:");
        System.err.println();
        System.err.println("  java " + Main.class.getName() + " [args]");
        System.err.println();
        System.err.println("    args:");
        System.err.println();
        System.err.println("      [-in                fileName]   default: <STDIN>");
        System.err.println("      [-lang          languageName]   default: <If -in is specified and -lang");
        System.err.println("                                                is not, attempt to determine");
        System.err.println("                                                language from file extension;");
        System.err.println("                                                otherwise, -lang is required.>");
        System.err.println();
        System.err.println("    Additional args used only if -mode is set to \"compile\":");
        System.err.println();
        System.err.println("      [-out              className]   default: Test");
    }
}

