/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.validation.BootstrapConfiguration;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.ParameterNameProvider;
import javax.validation.TraversableResolver;
import javax.validation.ValidationException;
import javax.validation.ValidationProviderResolver;
import javax.validation.ValidatorFactory;
import javax.validation.executable.ExecutableType;
import javax.validation.spi.BootstrapState;
import javax.validation.spi.ConfigurationState;
import javax.validation.spi.ValidationProvider;
import org.apache.bval.cdi.BValExtension;
import org.apache.bval.jsr.ApacheValidatorConfiguration;
import org.apache.bval.jsr.ConfigurationImpl$newInstance$$Ljava_lang_Class$_ACTION;
import org.apache.bval.jsr.DefaultConstraintValidatorFactory;
import org.apache.bval.jsr.DefaultMessageInterpolator;
import org.apache.bval.jsr.parameter.DefaultParameterNameProvider;
import org.apache.bval.jsr.resolver.DefaultTraversableResolver;
import org.apache.bval.jsr.util.IOs;
import org.apache.bval.jsr.xml.ValidationParser;
import org.apache.commons.weaver.privilizer.Privileged;
import org.apache.commons.weaver.privilizer.Privilized;

@Privilized(value="DYNAMIC")
public class ConfigurationImpl
implements ApacheValidatorConfiguration,
ConfigurationState {
    protected final ValidationProvider<?> provider;
    protected final ValidationProviderResolver providerResolver;
    protected Class<? extends ValidationProvider<?>> providerClass;
    protected MessageInterpolator defaultMessageInterpolator;
    protected MessageInterpolator messageInterpolator;
    protected Class<? extends MessageInterpolator> messageInterpolatorClass;
    protected ConstraintValidatorFactory defaultConstraintValidatorFactory;
    protected ConstraintValidatorFactory constraintValidatorFactory;
    protected Class<? extends ConstraintValidatorFactory> constraintValidatorFactoryClass;
    protected TraversableResolver defaultTraversableResolver;
    protected TraversableResolver traversableResolver;
    protected Class<? extends TraversableResolver> traversableResolverClass;
    protected ParameterNameProvider defaultParameterNameProvider;
    protected ParameterNameProvider parameterNameProvider;
    protected Class<? extends ParameterNameProvider> parameterNameProviderClass;
    protected BootstrapConfiguration bootstrapConfiguration;
    protected Collection<ExecutableType> executableValidation;
    private Collection<BValExtension.Releasable<?>> releasables;
    private boolean beforeCdi;
    private boolean prepared;
    private Set<InputStream> mappingStreams;
    private Map<String, String> properties;
    private boolean ignoreXmlConfiguration;
    private volatile ValidationParser parser;

    public ConfigurationImpl(BootstrapState aState, ValidationProvider<?> aProvider) {
        this.messageInterpolator = this.defaultMessageInterpolator = new DefaultMessageInterpolator();
        this.messageInterpolatorClass = null;
        this.constraintValidatorFactory = this.defaultConstraintValidatorFactory = new DefaultConstraintValidatorFactory();
        this.constraintValidatorFactoryClass = null;
        this.traversableResolver = this.defaultTraversableResolver = new DefaultTraversableResolver();
        this.traversableResolverClass = null;
        this.parameterNameProvider = this.defaultParameterNameProvider = new DefaultParameterNameProvider();
        this.parameterNameProviderClass = null;
        this.releasables = new CopyOnWriteArrayList();
        this.beforeCdi = false;
        this.prepared = false;
        this.mappingStreams = new HashSet<InputStream>();
        this.properties = new HashMap<String, String>();
        this.ignoreXmlConfiguration = false;
        if (aProvider != null) {
            this.provider = aProvider;
            this.providerResolver = null;
        } else if (aState != null) {
            this.provider = null;
            this.providerResolver = aState.getValidationProviderResolver() == null ? aState.getDefaultValidationProviderResolver() : aState.getValidationProviderResolver();
        } else {
            throw new ValidationException("either provider or state are required");
        }
    }

    public ApacheValidatorConfiguration traversableResolver(TraversableResolver resolver) {
        if (resolver == null) {
            return this;
        }
        this.traversableResolverClass = null;
        this.traversableResolver = resolver;
        this.prepared = false;
        return this;
    }

    public ApacheValidatorConfiguration ignoreXmlConfiguration() {
        this.ignoreXmlConfiguration = true;
        return this;
    }

    public ConfigurationImpl messageInterpolator(MessageInterpolator resolver) {
        if (resolver == null) {
            return this;
        }
        this.messageInterpolatorClass = null;
        this.messageInterpolator = resolver;
        this.prepared = false;
        return this;
    }

    public ConfigurationImpl constraintValidatorFactory(ConstraintValidatorFactory constraintFactory) {
        if (constraintFactory == null) {
            return this;
        }
        this.constraintValidatorFactoryClass = null;
        this.constraintValidatorFactory = constraintFactory;
        this.prepared = false;
        return this;
    }

    public ApacheValidatorConfiguration parameterNameProvider(ParameterNameProvider parameterNameProvider) {
        if (parameterNameProvider == null) {
            return this;
        }
        this.parameterNameProviderClass = null;
        this.parameterNameProvider = parameterNameProvider;
        return this;
    }

    public ApacheValidatorConfiguration addMapping(InputStream stream) {
        if (stream == null) {
            return this;
        }
        this.mappingStreams.add(IOs.convertToMarkableInputStream(stream));
        return this;
    }

    public ApacheValidatorConfiguration addProperty(String name, String value) {
        if ("bval.before.cdi".equals(name)) {
            this.beforeCdi = Boolean.parseBoolean(value);
        } else {
            this.properties.put(name, value);
        }
        return this;
    }

    public MessageInterpolator getDefaultMessageInterpolator() {
        return this.defaultMessageInterpolator;
    }

    public TraversableResolver getDefaultTraversableResolver() {
        return this.defaultTraversableResolver;
    }

    public ConstraintValidatorFactory getDefaultConstraintValidatorFactory() {
        return this.defaultConstraintValidatorFactory;
    }

    public ParameterNameProvider getDefaultParameterNameProvider() {
        return this.defaultParameterNameProvider;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean isIgnoreXmlConfiguration() {
        return this.ignoreXmlConfiguration;
    }

    public Set<InputStream> getMappingStreams() {
        return this.mappingStreams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageInterpolator getMessageInterpolator() {
        if (this.beforeCdi) {
            return this.defaultMessageInterpolator;
        }
        if (this.messageInterpolator == this.defaultMessageInterpolator && this.messageInterpolatorClass != null) {
            ConfigurationImpl configurationImpl = this;
            synchronized (configurationImpl) {
                if (this.messageInterpolator == this.defaultMessageInterpolator && this.messageInterpolatorClass != null) {
                    this.messageInterpolator = this.newInstance(this.messageInterpolatorClass);
                }
            }
        }
        return this.messageInterpolator;
    }

    public BootstrapConfiguration getBootstrapConfiguration() {
        return this.createBootstrapConfiguration();
    }

    public ValidatorFactory buildValidatorFactory() {
        return this.doBuildValidatorFactory();
    }

    @Privileged
    private ValidatorFactory doBuildValidatorFactory() {
        if (!(System.getSecurityManager() != null)) {
            return this.__privileged_doBuildValidatorFactory();
        }
        return (ValidatorFactory)AccessController.doPrivileged(new ConfigurationImpl$doBuildValidatorFactory_ACTION(this));
    }

    static /* synthetic */ ValidatorFactory __privileged_access$0(ConfigurationImpl configurationImpl) {
        return configurationImpl.__privileged_doBuildValidatorFactory();
    }

    private ValidatorFactory __privileged_doBuildValidatorFactory() {
        this.prepare();
        this.parser.ensureValidatorFactoryCanBeBuilt();
        ValidationProvider<?> useProvider = this.provider == null ? this.findProvider() : this.provider;
        return useProvider.buildValidatorFactory((ConfigurationState)this);
    }

    private ConfigurationImpl prepare() {
        if (this.prepared) {
            return this;
        }
        this.createBootstrapConfiguration();
        this.parser.applyConfigWithInstantiation(this);
        this.prepared = true;
        return this;
    }

    private BootstrapConfiguration createBootstrapConfiguration() {
        if (this.parser == null) {
            this.parser = this.parseValidationXml();
            this.bootstrapConfiguration = this.parser.getBootstrap();
        }
        return this.bootstrapConfiguration;
    }

    private ValidationParser parseValidationXml() {
        return ValidationParser.processValidationConfig(this.getProperties().get("apache.bval.validation-xml-path"), this, this.ignoreXmlConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        if (this.beforeCdi) {
            return this.constraintValidatorFactory;
        }
        if (this.constraintValidatorFactory == this.defaultConstraintValidatorFactory && this.constraintValidatorFactoryClass != null) {
            ConfigurationImpl configurationImpl = this;
            synchronized (configurationImpl) {
                if (this.constraintValidatorFactory == this.defaultConstraintValidatorFactory && this.constraintValidatorFactoryClass != null) {
                    this.constraintValidatorFactory = this.newInstance(this.constraintValidatorFactoryClass);
                }
            }
        }
        return this.constraintValidatorFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TraversableResolver getTraversableResolver() {
        if (this.beforeCdi) {
            return this.defaultTraversableResolver;
        }
        if (this.traversableResolver == this.defaultTraversableResolver && this.traversableResolverClass != null) {
            ConfigurationImpl configurationImpl = this;
            synchronized (configurationImpl) {
                if (this.traversableResolver == this.defaultTraversableResolver && this.traversableResolverClass != null) {
                    this.traversableResolver = this.newInstance(this.traversableResolverClass);
                }
            }
        }
        return this.traversableResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParameterNameProvider getParameterNameProvider() {
        if (this.beforeCdi) {
            return this.defaultParameterNameProvider;
        }
        if (this.parameterNameProvider == this.defaultParameterNameProvider && this.parameterNameProviderClass != null) {
            ConfigurationImpl configurationImpl = this;
            synchronized (configurationImpl) {
                if (this.parameterNameProvider == this.defaultParameterNameProvider && this.parameterNameProviderClass != null) {
                    this.parameterNameProvider = this.newInstance(this.parameterNameProviderClass);
                }
            }
        }
        return this.parameterNameProvider;
    }

    public ValidationProvider<?> getProvider() {
        return this.provider;
    }

    private ValidationProvider<?> findProvider() {
        if (this.providerClass == null) {
            return (ValidationProvider)this.providerResolver.getValidationProviders().get(0);
        }
        for (ValidationProvider provider : this.providerResolver.getValidationProviders()) {
            if (!this.providerClass.isAssignableFrom(provider.getClass())) continue;
            return provider;
        }
        throw new ValidationException("Unable to find suitable provider: " + this.providerClass);
    }

    public void setProviderClass(Class<? extends ValidationProvider<?>> providerClass) {
        this.providerClass = providerClass;
    }

    public void setExecutableValidation(Collection<ExecutableType> executableValidation) {
        this.executableValidation = executableValidation;
    }

    public Collection<ExecutableType> getExecutableValidation() {
        return this.executableValidation;
    }

    public Closeable getClosable() {
        return new Closeable(){

            @Override
            public void close() throws IOException {
                for (BValExtension.Releasable releasable : ConfigurationImpl.this.releasables) {
                    releasable.release();
                }
                ConfigurationImpl.this.releasables.clear();
            }
        };
    }

    @Privileged
    private <T> T newInstance(Class<T> clazz) {
        if (!(System.getSecurityManager() != null)) {
            return this.__privileged_newInstance(clazz);
        }
        return AccessController.doPrivileged(new ConfigurationImpl$newInstance$$Ljava_lang_Class$_ACTION(this, clazz));
    }

    static /* synthetic */ Object __privileged_access$1(ConfigurationImpl configurationImpl, Class clazz) {
        return configurationImpl.__privileged_newInstance(clazz);
    }

    private <T> T __privileged_newInstance(Class<T> cls) {
        try {
            BValExtension.Releasable<T> releasable = BValExtension.inject(cls);
            this.releasables.add(releasable);
            return releasable.getInstance();
        }
        catch (Exception e) {
        }
        catch (NoClassDefFoundError error) {
            // empty catch block
        }
        try {
            return cls.newInstance();
        }
        catch (Exception e) {
            throw new ValidationException(e.getMessage(), (Throwable)e);
        }
    }

    public void traversableResolverClass(Class<TraversableResolver> clazz) {
        this.traversableResolverClass = clazz;
    }

    public void constraintValidatorFactoryClass(Class<ConstraintValidatorFactory> clazz) {
        this.constraintValidatorFactoryClass = clazz;
    }

    public void messageInterpolatorClass(Class<MessageInterpolator> clazz) {
        this.messageInterpolatorClass = clazz;
    }

    public void parameterNameProviderClass(Class<? extends ParameterNameProvider> clazz) {
        this.parameterNameProviderClass = clazz;
    }

    /*
     * Signature claims super is java.security.PrivilegedAction<javax.validation.ValidatorFactory>, not java.lang.Object - discarding signature.
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ConfigurationImpl$doBuildValidatorFactory_ACTION
    implements PrivilegedAction {
        private final ConfigurationImpl f1;

        ConfigurationImpl$doBuildValidatorFactory_ACTION(ConfigurationImpl arg1) {
            this.f1 = arg1;
        }

        public Object run() {
            return ConfigurationImpl.__privileged_access$0(this.f1);
        }
    }
}

