/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.validation.ValidationException;
import org.apache.bval.util.Exceptions;
import org.apache.bval.util.Validate;
import org.apache.commons.lang3.StringEscapeUtils;

public class PathNavigation {
    private static final Logger LOG;
    private static final QuotedStringParser QUOTED_STRING_PARSER;

    private PathNavigation() {
    }

    public static <T> T navigateAndReturn(CharSequence propertyPath, Callback<? extends T> callback) {
        try {
            PathNavigation.parse(propertyPath == null ? "" : propertyPath, new PathPosition(callback));
        }
        catch (IllegalArgumentException | ValidationException ex) {
            throw ex;
        }
        catch (Exception e) {
            Exceptions.raise(ValidationException::new, e, "invalid property: %s", propertyPath);
        }
        return callback.result();
    }

    public static void navigate(CharSequence propertyPath, Callback<?> callback) {
        PathNavigation.navigateAndReturn(propertyPath, callback);
    }

    private static void parse(CharSequence path, PathPosition pos) throws Exception {
        int len = path.length();
        boolean sep = true;
        while (pos.getIndex() < len) {
            int here = pos.getIndex();
            char c = path.charAt(here);
            switch (c) {
                case ']': {
                    Exceptions.raise(IllegalStateException::new, "Position %s: unexpected '%s'", here, Character.valueOf(c));
                }
                case '[': {
                    PathNavigation.handleIndex(path, pos.next());
                    break;
                }
                case '.': {
                    Exceptions.raiseIf(sep, IllegalStateException::new, "Position %s: expected property, index/key, or end of expression", here);
                    sep = true;
                    pos.next();
                }
                default: {
                    Exceptions.raiseUnless(sep, IllegalStateException::new, "Position %s: expected property path separator, index/key, or end of expression", here);
                    pos.handleProperty(PathNavigation.parseProperty(path, pos));
                }
            }
            sep = false;
        }
    }

    private static String parseProperty(CharSequence path, PathPosition pos) throws Exception {
        int len = path.length();
        int start = pos.getIndex();
        block3: while (pos.getIndex() < len) {
            switch (path.charAt(pos.getIndex())) {
                case '.': 
                case '[': 
                case ']': {
                    break block3;
                }
                default: {
                    pos.next();
                    continue block3;
                }
            }
        }
        Exceptions.raiseIf(pos.getIndex() == start, IllegalStateException::new, "Position %s: expected property", start);
        return path.subSequence(start, pos.getIndex()).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleIndex(CharSequence path, PathPosition pos) throws Exception {
        int len = path.length();
        int start = pos.getIndex();
        if (start < len) {
            String s;
            char first = path.charAt(pos.getIndex());
            if ((first == '\"' || first == '\'') && (s = QUOTED_STRING_PARSER.parseQuotedString(path, pos)) != null && path.charAt(pos.getIndex()) == ']') {
                pos.handleIndexOrKey(s);
                pos.next();
                return;
            }
            while (pos.getIndex() < len) {
                int here = pos.getIndex();
                try {
                    if (path.charAt(here) != ']') continue;
                    if (here == start) {
                        pos.handleGenericInIterable();
                    } else {
                        pos.handleIndexOrKey(path.subSequence(start, here).toString());
                    }
                    return;
                }
                finally {
                    pos.next();
                }
            }
        }
        Exceptions.raise(IllegalStateException::new, "Position %s: unparsable index", start);
    }

    static {
        QuotedStringParser quotedStringParser;
        LOG = Logger.getLogger(PathNavigation.class.getName());
        try {
            quotedStringParser = new FullQuotedStringParser();
        }
        catch (Exception e) {
            LOG.warning("Apache commons-lang3 is not on the classpath; Java escaping in quotes will not be available.");
            quotedStringParser = new QuotedStringParser();
        }
        QUOTED_STRING_PARSER = quotedStringParser;
    }

    private static class PathPosition
    extends ParsePosition
    implements Callback<Void> {
        final Callback<?> delegate;

        private PathPosition(Callback<?> delegate) {
            super(0);
            this.delegate = delegate;
        }

        public PathPosition next() {
            return this.plus(1);
        }

        public PathPosition plus(int addend) {
            this.setIndex(this.getIndex() + addend);
            return this;
        }

        @Override
        public void handleProperty(String name) {
            this.delegate.handleProperty(name);
        }

        @Override
        public void handleIndexOrKey(String value) {
            this.delegate.handleIndexOrKey(value);
        }

        @Override
        public void handleGenericInIterable() {
            this.delegate.handleGenericInIterable();
        }

        @Override
        public Void result() {
            return null;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    private static class FullQuotedStringParser
    extends QuotedStringParser {
        private FullQuotedStringParser() {
        }

        @Override
        protected void handleNextChar(CharSequence path, PathPosition pos, Writer target) throws IOException {
            int codePoints = StringEscapeUtils.UNESCAPE_JAVA.translate(path, pos.getIndex(), target);
            if (codePoints == 0) {
                super.handleNextChar(path, pos, target);
            } else {
                for (int i = 0; i < codePoints; ++i) {
                    pos.plus(Character.charCount(Character.codePointAt(path, pos.getIndex())));
                }
            }
        }
    }

    private static class QuotedStringParser {
        private QuotedStringParser() {
        }

        String parseQuotedString(CharSequence path, PathPosition pos) throws Exception {
            int len = path.length();
            int start = pos.getIndex();
            if (start < len) {
                char quote = path.charAt(start);
                pos.next();
                StringWriter w = new StringWriter();
                while (pos.getIndex() < len) {
                    int here = pos.getIndex();
                    if (path.charAt(here) == quote) {
                        pos.next();
                        return w.toString();
                    }
                    this.handleNextChar(path, pos, w);
                }
                pos.setIndex(start);
            }
            return null;
        }

        protected void handleNextChar(CharSequence path, PathPosition pos, Writer target) throws IOException {
            target.write(Character.toChars(Character.codePointAt(path, pos.getIndex())));
            pos.next();
        }
    }

    public static class CompositeCallbackProcedure
    extends CallbackProcedure {
        private final List<Callback<?>> delegates;

        public CompositeCallbackProcedure(Callback<?> ... delegates) {
            this(new ArrayList(Arrays.asList(delegates)));
        }

        public CompositeCallbackProcedure(List<Callback<?>> delegates) {
            this.delegates = Validate.notNull(delegates);
        }

        @Override
        public void handleProperty(String name) {
            this.delegates.forEach(d -> d.handleProperty(name));
        }

        @Override
        public void handleIndexOrKey(String value) {
            this.delegates.forEach(d -> d.handleIndexOrKey(value));
        }

        @Override
        public void handleGenericInIterable() {
            this.delegates.forEach(Callback::handleGenericInIterable);
        }
    }

    public static abstract class CallbackProcedure
    implements Callback<Void> {
        @Override
        public final Void result() {
            this.complete();
            return null;
        }

        protected void complete() {
        }
    }

    public static interface Callback<T> {
        public void handleProperty(String var1);

        public void handleIndexOrKey(String var1);

        public void handleGenericInIterable();

        public T result();
    }
}

