/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan.volcano;

import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.RelSet;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.plan.volcano.VolcanoRuleCall;
import org.apache.calcite.rel.RelNode;

class VolcanoRuleMatch
extends VolcanoRuleCall {
    private final RelSet targetSet;
    private RelSubset targetSubset;
    private String digest;
    private final VolcanoPlanner volcanoPlanner;
    private double cachedImportance = Double.NaN;

    VolcanoRuleMatch(VolcanoPlanner volcanoPlanner, RelOptRuleOperand operand0, RelNode[] rels) {
        super(volcanoPlanner, operand0, (RelNode[])rels.clone());
        this.volcanoPlanner = volcanoPlanner;
        for (int i = 0; i < rels.length; ++i) {
            assert (rels[i] != null);
        }
        this.targetSet = volcanoPlanner.getSet(rels[0]);
        assert (this.targetSet != null) : rels[0].toString() + " isn't in a set";
        this.digest = this.computeDigest();
    }

    public String toString() {
        return this.digest;
    }

    void clearCachedImportance() {
        this.cachedImportance = Double.NaN;
    }

    double getImportance() {
        if (Double.isNaN(this.cachedImportance)) {
            this.cachedImportance = this.computeImportance();
        }
        return this.cachedImportance;
    }

    double computeImportance() {
        double targetImportance;
        RelSubset targetSubset;
        assert (this.rels[0] != null);
        RelSubset subset = this.volcanoPlanner.getSubset(this.rels[0]);
        double importance = 0.0;
        if (subset != null) {
            importance = this.volcanoPlanner.ruleQueue.getImportance(subset);
        }
        if ((targetSubset = this.guessSubset()) != null && targetSubset != subset && (targetImportance = this.volcanoPlanner.ruleQueue.getImportance(targetSubset)) > importance) {
            importance = targetImportance;
            if (subset == null || subset.bestCost.isLt(targetSubset.bestCost)) {
                // empty if block
            }
        }
        return importance;
    }

    private String computeDigest() {
        StringBuilder buf = new StringBuilder("rule [" + this.getRule() + "] rels [");
        for (int i = 0; i < this.rels.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.rels[i].toString());
        }
        buf.append("]");
        return buf.toString();
    }

    public void recomputeDigest() {
        this.digest = this.computeDigest();
    }

    private RelSubset guessSubset() {
        if (this.targetSubset != null) {
            return this.targetSubset;
        }
        RelTrait targetTrait = this.getRule().getOutTrait();
        if (this.targetSet != null && targetTrait != null) {
            RelTraitSet targetTraitSet = this.rels[0].getTraitSet().replace(targetTrait);
            this.targetSubset = this.targetSet.getSubset(targetTraitSet);
            return this.targetSubset;
        }
        return null;
    }
}

