/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.core;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.mapping.Mappings;

public class AggregateCall {
    private final SqlAggFunction aggFunction;
    private final boolean distinct;
    public final RelDataType type;
    public final String name;
    private final ImmutableList<Integer> argList;

    public AggregateCall(SqlAggFunction aggFunction, boolean distinct, List<Integer> argList, RelDataType type, String name) {
        this.type = type;
        this.name = name;
        assert (aggFunction != null);
        assert (argList != null);
        assert (type != null);
        this.aggFunction = aggFunction;
        this.argList = ImmutableList.copyOf(argList);
        this.distinct = distinct;
    }

    public static AggregateCall create(SqlAggFunction aggFunction, boolean distinct, List<Integer> argList, int groupCount, RelNode input, RelDataType type, String name) {
        if (type == null) {
            RelDataTypeFactory typeFactory = input.getCluster().getTypeFactory();
            List<RelDataType> types = SqlTypeUtil.projectTypes(input.getRowType(), argList);
            Aggregate.AggCallBinding callBinding = new Aggregate.AggCallBinding(typeFactory, aggFunction, types, groupCount);
            type = aggFunction.inferReturnType(callBinding);
        }
        return new AggregateCall(aggFunction, distinct, argList, type, name);
    }

    public final boolean isDistinct() {
        return this.distinct;
    }

    public final SqlAggFunction getAggregation() {
        return this.aggFunction;
    }

    public final List<Integer> getArgList() {
        return this.argList;
    }

    public final RelDataType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public AggregateCall rename(String name) {
        return new AggregateCall(this.aggFunction, this.distinct, (List<Integer>)this.argList, this.type, name);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.aggFunction.getName());
        buf.append("(");
        if (this.distinct) {
            buf.append(this.argList.size() == 0 ? "DISTINCT" : "DISTINCT ");
        }
        int i = -1;
        for (Integer arg : this.argList) {
            if (++i > 0) {
                buf.append(", ");
            }
            buf.append("$");
            buf.append(arg);
        }
        buf.append(")");
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof AggregateCall)) {
            return false;
        }
        AggregateCall other = (AggregateCall)o;
        return this.aggFunction.equals(other.aggFunction) && this.distinct == other.distinct && this.argList.equals(other.argList);
    }

    public int hashCode() {
        return this.aggFunction.hashCode() + this.argList.hashCode();
    }

    public Aggregate.AggCallBinding createBinding(Aggregate aggregateRelBase) {
        RelDataType rowType = aggregateRelBase.getInput().getRowType();
        return new Aggregate.AggCallBinding(aggregateRelBase.getCluster().getTypeFactory(), this.aggFunction, SqlTypeUtil.projectTypes(rowType, this.argList), aggregateRelBase.getGroupCount());
    }

    public AggregateCall copy(List<Integer> args) {
        return new AggregateCall(this.aggFunction, this.distinct, args, this.type, this.name);
    }

    public AggregateCall adaptTo(RelNode input, List<Integer> aggArgs, int oldGroupKeyCount, int newGroupKeyCount) {
        SqlAggFunction sqlAgg = this.aggFunction;
        RelDataType newType = oldGroupKeyCount == newGroupKeyCount ? this.type : null;
        return AggregateCall.create(sqlAgg, this.distinct, aggArgs, newGroupKeyCount, input, newType, this.getName());
    }

    public AggregateCall transform(Mappings.TargetMapping mapping) {
        return this.copy(Mappings.permute(this.argList, mapping));
    }
}

