/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.jdbc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.avatica.AvaticaConnection;
import org.apache.calcite.avatica.AvaticaStatement;
import org.apache.calcite.avatica.AvaticaUtils;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.MetaImpl;
import org.apache.calcite.avatica.NoSuchStatementException;
import org.apache.calcite.avatica.QueryState;
import org.apache.calcite.avatica.remote.TypedValue;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.jdbc.CalciteConnectionImpl;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.Driver;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.function.Functions;
import org.apache.calcite.linq4j.function.Predicate1;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.runtime.FlatLists;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractTableQueryable;
import org.apache.calcite.server.CalciteServerStatement;
import org.apache.calcite.sql.SqlJdbcFunctionCall;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Util;

public class CalciteMetaImpl
extends MetaImpl {
    static final Driver DRIVER = new Driver();

    public CalciteMetaImpl(CalciteConnectionImpl connection) {
        super((AvaticaConnection)connection);
        this.connProps.setAutoCommit(false).setReadOnly(false).setTransactionIsolation(0);
        this.connProps.setDirty(false);
    }

    static <T extends MetaImpl.Named> Predicate1<T> namedMatcher(Meta.Pat pattern) {
        if (pattern.s == null || pattern.s.equals("%")) {
            return Functions.truePredicate1();
        }
        final Pattern regex = CalciteMetaImpl.likeToRegex(pattern);
        return new Predicate1<T>(){

            public boolean apply(T v1) {
                return regex.matcher(v1.getName()).matches();
            }
        };
    }

    static Predicate1<String> matcher(Meta.Pat pattern) {
        if (pattern.s == null || pattern.s.equals("%")) {
            return Functions.truePredicate1();
        }
        final Pattern regex = CalciteMetaImpl.likeToRegex(pattern);
        return new Predicate1<String>(){

            public boolean apply(String v1) {
                return regex.matcher(v1).matches();
            }
        };
    }

    public static Pattern likeToRegex(Meta.Pat pattern) {
        StringBuilder buf = new StringBuilder("^");
        char[] charArray = pattern.s.toCharArray();
        int slash = -2;
        block6: for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (slash == i - 1) {
                buf.append('[').append(c).append(']');
                continue;
            }
            switch (c) {
                case '\\': {
                    slash = i;
                    continue block6;
                }
                case '%': {
                    buf.append(".*");
                    continue block6;
                }
                case '[': {
                    buf.append("\\[");
                    continue block6;
                }
                case ']': {
                    buf.append("\\]");
                    continue block6;
                }
                default: {
                    buf.append('[').append(c).append(']');
                }
            }
        }
        buf.append("$");
        return Pattern.compile(buf.toString());
    }

    public Meta.StatementHandle createStatement(Meta.ConnectionHandle ch) {
        Meta.StatementHandle h = super.createStatement(ch);
        CalciteConnectionImpl calciteConnection = this.getConnection();
        calciteConnection.server.addStatement(calciteConnection, h);
        return h;
    }

    public void closeStatement(Meta.StatementHandle h) {
        CalciteConnectionImpl calciteConnection = this.getConnection();
        try {
            CalciteServerStatement stmt = calciteConnection.server.getStatement(h);
        }
        catch (NoSuchStatementException e) {
            return;
        }
        calciteConnection.server.removeStatement(h);
    }

    private <E> Meta.MetaResultSet createResultSet(Enumerable<E> enumerable, Class clazz, String ... names) {
        ArrayList<ColumnMetaData> columns = new ArrayList<ColumnMetaData>();
        ArrayList<Field> fields = new ArrayList<Field>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (String name : names) {
            Field field;
            int index = fields.size();
            String fieldName = AvaticaUtils.toCamelCase((String)name);
            try {
                field = clazz.getField(fieldName);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            columns.add(CalciteMetaImpl.columnMetaData((String)name, (int)index, field.getType()));
            fields.add(field);
            fieldNames.add(fieldName);
        }
        Enumerable<E> iterable = enumerable;
        return this.createResultSet(Collections.emptyMap(), columns, Meta.CursorFactory.record((Class)clazz, fields, fieldNames), new Meta.Frame(0L, true, iterable));
    }

    protected <E> Meta.MetaResultSet createEmptyResultSet(Class<E> clazz) {
        List columns = CalciteMetaImpl.fieldMetaData(clazz).columns;
        Meta.CursorFactory cursorFactory = Meta.CursorFactory.deduce((List)columns, clazz);
        return this.createResultSet(Collections.emptyMap(), columns, cursorFactory, Meta.Frame.EMPTY);
    }

    protected Meta.MetaResultSet createResultSet(Map<String, Object> internalParameters, List<ColumnMetaData> columns, Meta.CursorFactory cursorFactory, final Meta.Frame firstFrame) {
        try {
            CalciteConnectionImpl connection = this.getConnection();
            AvaticaStatement statement = connection.createStatement();
            CalcitePrepare.CalciteSignature<Object> signature = new CalcitePrepare.CalciteSignature<Object>("", (List)ImmutableList.of(), internalParameters, null, columns, cursorFactory, (List)ImmutableList.of(), -1L, null, Meta.StatementType.SELECT){

                @Override
                public Enumerable<Object> enumerable(DataContext dataContext) {
                    return Linq4j.asEnumerable((Iterable)firstFrame.rows);
                }
            };
            return Meta.MetaResultSet.create((String)connection.id, (int)statement.getId(), (boolean)true, (Meta.Signature)signature, (Meta.Frame)firstFrame);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    CalciteConnectionImpl getConnection() {
        return (CalciteConnectionImpl)this.connection;
    }

    public Map<Meta.DatabaseProperty, Object> getDatabaseProperties(Meta.ConnectionHandle ch) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Meta.DatabaseProperty p : Meta.DatabaseProperty.values()) {
            this.addProperty((ImmutableMap.Builder<Meta.DatabaseProperty, Object>)builder, p);
        }
        return builder.build();
    }

    private ImmutableMap.Builder<Meta.DatabaseProperty, Object> addProperty(ImmutableMap.Builder<Meta.DatabaseProperty, Object> builder, Meta.DatabaseProperty p) {
        switch (p) {
            case GET_S_Q_L_KEYWORDS: {
                return builder.put((Object)p, (Object)SqlParser.create("").getMetadata().getJdbcKeywords());
            }
            case GET_NUMERIC_FUNCTIONS: {
                return builder.put((Object)p, (Object)SqlJdbcFunctionCall.getNumericFunctions());
            }
            case GET_STRING_FUNCTIONS: {
                return builder.put((Object)p, (Object)SqlJdbcFunctionCall.getStringFunctions());
            }
            case GET_SYSTEM_FUNCTIONS: {
                return builder.put((Object)p, (Object)SqlJdbcFunctionCall.getSystemFunctions());
            }
            case GET_TIME_DATE_FUNCTIONS: {
                return builder.put((Object)p, (Object)SqlJdbcFunctionCall.getTimeDateFunctions());
            }
        }
        return builder;
    }

    public Meta.MetaResultSet getTables(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern, final Meta.Pat tableNamePattern, final List<String> typeList) {
        Object typeFilter = typeList == null ? Functions.truePredicate1() : new Predicate1<MetaImpl.MetaTable>(){

            public boolean apply(MetaImpl.MetaTable v1) {
                return typeList.contains(v1.tableType);
            }
        };
        Predicate1 schemaMatcher = CalciteMetaImpl.namedMatcher(schemaPattern);
        return this.createResultSet(this.schemas(catalog).where(schemaMatcher).selectMany((Function1)new Function1<MetaImpl.MetaSchema, Enumerable<MetaImpl.MetaTable>>(){

            public Enumerable<MetaImpl.MetaTable> apply(MetaImpl.MetaSchema schema) {
                return CalciteMetaImpl.this.tables(schema, CalciteMetaImpl.matcher(tableNamePattern));
            }
        }).where(typeFilter), MetaImpl.MetaTable.class, "TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE", "REMARKS", "TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "SELF_REFERENCING_COL_NAME", "REF_GENERATION");
    }

    public Meta.MetaResultSet getTypeInfo(Meta.ConnectionHandle ch) {
        return this.createResultSet(this.allTypeInfo(), MetaImpl.MetaTypeInfo.class, "TYPE_NAME", "DATA_TYPE", "PRECISION", "LITERAL_PREFIX", "LITERAL_SUFFIX", "CREATE_PARAMS", "NULLABLE", "CASE_SENSITIVE", "SEARCHABLE", "UNSIGNED_ATTRIBUTE", "FIXED_PREC_SCALE", "AUTO_INCREMENT", "LOCAL_TYPE_NAME", "MINIMUM_SCALE", "MAXIMUM_SCALE", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "NUM_PREC_RADIX");
    }

    public Meta.MetaResultSet getColumns(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, Meta.Pat columnNamePattern) {
        final Predicate1<String> tableNameMatcher = CalciteMetaImpl.matcher(tableNamePattern);
        Predicate1 schemaMatcher = CalciteMetaImpl.namedMatcher(schemaPattern);
        Predicate1 columnMatcher = CalciteMetaImpl.namedMatcher(columnNamePattern);
        return this.createResultSet(this.schemas(catalog).where(schemaMatcher).selectMany((Function1)new Function1<MetaImpl.MetaSchema, Enumerable<MetaImpl.MetaTable>>(){

            public Enumerable<MetaImpl.MetaTable> apply(MetaImpl.MetaSchema schema) {
                return CalciteMetaImpl.this.tables(schema, (Predicate1<String>)tableNameMatcher);
            }
        }).selectMany((Function1)new Function1<MetaImpl.MetaTable, Enumerable<MetaImpl.MetaColumn>>(){

            public Enumerable<MetaImpl.MetaColumn> apply(MetaImpl.MetaTable schema) {
                return CalciteMetaImpl.this.columns(schema);
            }
        }).where(columnMatcher), MetaImpl.MetaColumn.class, "TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SCOPE_CATALOG", "SCOPE_SCHEMA", "SCOPE_TABLE", "SOURCE_DATA_TYPE", "IS_AUTOINCREMENT", "IS_GENERATEDCOLUMN");
    }

    Enumerable<MetaImpl.MetaCatalog> catalogs() {
        return Linq4j.asEnumerable((List)ImmutableList.of((Object)new MetaImpl.MetaCatalog(this.connection.getCatalog())));
    }

    Enumerable<MetaImpl.MetaTableType> tableTypes() {
        return Linq4j.asEnumerable((List)ImmutableList.of((Object)new MetaImpl.MetaTableType("TABLE"), (Object)new MetaImpl.MetaTableType("VIEW")));
    }

    Enumerable<MetaImpl.MetaSchema> schemas(String catalog) {
        return Linq4j.asEnumerable(this.getConnection().rootSchema.getSubSchemaMap().values()).select((Function1)new Function1<CalciteSchema, MetaImpl.MetaSchema>(){

            public MetaImpl.MetaSchema apply(CalciteSchema calciteSchema) {
                return new CalciteMetaSchema(calciteSchema, CalciteMetaImpl.this.connection.getCatalog(), calciteSchema.getName());
            }
        }).orderBy((Function1)new Function1<MetaImpl.MetaSchema, Comparable>(){

            public Comparable apply(MetaImpl.MetaSchema metaSchema) {
                return (Comparable)((Object)FlatLists.of(Util.first(metaSchema.tableCatalog, ""), metaSchema.tableSchem));
            }
        });
    }

    Enumerable<MetaImpl.MetaTable> tables(String catalog) {
        return this.schemas(catalog).selectMany((Function1)new Function1<MetaImpl.MetaSchema, Enumerable<MetaImpl.MetaTable>>(){

            public Enumerable<MetaImpl.MetaTable> apply(MetaImpl.MetaSchema schema) {
                return CalciteMetaImpl.this.tables(schema, (Predicate1<String>)Functions.truePredicate1());
            }
        });
    }

    Enumerable<MetaImpl.MetaTable> tables(MetaImpl.MetaSchema schema_) {
        final CalciteMetaSchema schema = (CalciteMetaSchema)schema_;
        return Linq4j.asEnumerable(schema.calciteSchema.getTableNames()).select((Function1)new Function1<String, MetaImpl.MetaTable>(){

            public MetaImpl.MetaTable apply(String name) {
                Table table = schema.calciteSchema.getTable(name, true).getTable();
                return new CalciteMetaTable(table, schema.tableCatalog, schema.tableSchem, name);
            }
        }).concat(Linq4j.asEnumerable(schema.calciteSchema.getTablesBasedOnNullaryFunctions().entrySet()).select((Function1)new Function1<Map.Entry<String, Table>, MetaImpl.MetaTable>(){

            public MetaImpl.MetaTable apply(Map.Entry<String, Table> pair) {
                Table table = pair.getValue();
                return new CalciteMetaTable(table, schema.tableCatalog, schema.tableSchem, pair.getKey());
            }
        }));
    }

    Enumerable<MetaImpl.MetaTable> tables(MetaImpl.MetaSchema schema, final Predicate1<String> matcher) {
        return this.tables(schema).where((Predicate1)new Predicate1<MetaImpl.MetaTable>(){

            public boolean apply(MetaImpl.MetaTable v1) {
                return matcher.apply((Object)v1.getName());
            }
        });
    }

    private ImmutableList<MetaImpl.MetaTypeInfo> getAllDefaultType() {
        ImmutableList.Builder allTypeList = new ImmutableList.Builder();
        CalciteConnectionImpl conn = (CalciteConnectionImpl)this.connection;
        RelDataTypeSystem typeSystem = conn.typeFactory.getTypeSystem();
        for (SqlTypeName sqlTypeName : SqlTypeName.values()) {
            allTypeList.add((Object)new MetaImpl.MetaTypeInfo(sqlTypeName.getName(), sqlTypeName.getJdbcOrdinal(), typeSystem.getMaxPrecision(sqlTypeName), typeSystem.getLiteral(sqlTypeName, true), typeSystem.getLiteral(sqlTypeName, false), 1, typeSystem.isCaseSensitive(sqlTypeName), 3, false, false, typeSystem.isAutoincrement(sqlTypeName), sqlTypeName.getMinScale(), typeSystem.getMaxScale(sqlTypeName), typeSystem.getNumTypeRadix(sqlTypeName)));
        }
        return allTypeList.build();
    }

    protected Enumerable<MetaImpl.MetaTypeInfo> allTypeInfo() {
        return Linq4j.asEnumerable(this.getAllDefaultType());
    }

    public Enumerable<MetaImpl.MetaColumn> columns(MetaImpl.MetaTable table_) {
        final CalciteMetaTable table = (CalciteMetaTable)table_;
        RelDataType rowType = table.calciteTable.getRowType(this.getConnection().typeFactory);
        return Linq4j.asEnumerable(rowType.getFieldList()).select((Function1)new Function1<RelDataTypeField, MetaImpl.MetaColumn>(){

            public MetaImpl.MetaColumn apply(RelDataTypeField field) {
                int precision = field.getType().getSqlTypeName().allowsPrec() && !(field.getType() instanceof RelDataTypeFactoryImpl.JavaType) ? field.getType().getPrecision() : -1;
                return new MetaImpl.MetaColumn(table.tableCat, table.tableSchem, table.tableName, field.getName(), field.getType().getSqlTypeName().getJdbcOrdinal(), field.getType().getFullTypeString(), precision, field.getType().getSqlTypeName().allowsScale() ? Integer.valueOf(field.getType().getScale()) : null, 10, field.getType().isNullable() ? 1 : 0, precision, field.getIndex() + 1, field.getType().isNullable() ? "YES" : "NO");
            }
        });
    }

    public Meta.MetaResultSet getSchemas(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern) {
        Predicate1 schemaMatcher = CalciteMetaImpl.namedMatcher(schemaPattern);
        return this.createResultSet(this.schemas(catalog).where(schemaMatcher), MetaImpl.MetaSchema.class, "TABLE_SCHEM", "TABLE_CATALOG");
    }

    public Meta.MetaResultSet getCatalogs(Meta.ConnectionHandle ch) {
        return this.createResultSet(this.catalogs(), MetaImpl.MetaCatalog.class, "TABLE_CAT");
    }

    public Meta.MetaResultSet getTableTypes(Meta.ConnectionHandle ch) {
        return this.createResultSet(this.tableTypes(), MetaImpl.MetaTableType.class, "TABLE_TYPE");
    }

    public Iterable<Object> createIterable(Meta.StatementHandle handle, QueryState state, Meta.Signature signature, List<TypedValue> parameterValues, Meta.Frame firstFrame) {
        return this._createIterable(handle, signature, parameterValues, firstFrame);
    }

    Iterable<Object> _createIterable(Meta.StatementHandle handle, Meta.Signature signature, List<TypedValue> parameterValues, Meta.Frame firstFrame) {
        try {
            CalcitePrepare.CalciteSignature calciteSignature = (CalcitePrepare.CalciteSignature)signature;
            return this.getConnection().enumerable(handle, calciteSignature);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public Meta.StatementHandle prepare(Meta.ConnectionHandle ch, String sql, long maxRowCount) {
        CalciteServerStatement statement;
        Meta.StatementHandle h = this.createStatement(ch);
        CalciteConnectionImpl calciteConnection = this.getConnection();
        try {
            statement = calciteConnection.server.getStatement(h);
        }
        catch (NoSuchStatementException e) {
            throw new AssertionError("missing statement", e);
        }
        h.signature = calciteConnection.parseQuery(CalcitePrepare.Query.of(sql), statement.createPrepareContext(), maxRowCount);
        statement.setSignature(h.signature);
        return h;
    }

    public Meta.ExecuteResult prepareAndExecute(Meta.StatementHandle h, String sql, long maxRowCount, Meta.PrepareCallback callback) throws NoSuchStatementException {
        return this.prepareAndExecute(h, sql, maxRowCount, -1, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Meta.ExecuteResult prepareAndExecute(Meta.StatementHandle h, String sql, long maxRowCount, int maxRowsInFirstFrame, Meta.PrepareCallback callback) throws NoSuchStatementException {
        try {
            CalcitePrepare.CalciteSignature signature;
            Object object = callback.getMonitor();
            synchronized (object) {
                callback.clear();
                CalciteConnectionImpl calciteConnection = this.getConnection();
                CalciteServerStatement statement = calciteConnection.server.getStatement(h);
                signature = calciteConnection.parseQuery(CalcitePrepare.Query.of(sql), statement.createPrepareContext(), maxRowCount);
                statement.setSignature(signature);
                callback.assign(signature, null, -1L);
            }
            callback.execute();
            Meta.MetaResultSet metaResultSet = Meta.MetaResultSet.create((String)h.connectionId, (int)h.id, (boolean)false, signature, null);
            return new Meta.ExecuteResult((List)ImmutableList.of((Object)metaResultSet));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Meta.Frame fetch(Meta.StatementHandle h, long offset, int fetchMaxRowCount) throws NoSuchStatementException {
        Iterator<Object> iterator;
        CalciteConnectionImpl calciteConnection = this.getConnection();
        CalciteServerStatement stmt = calciteConnection.server.getStatement(h);
        Meta.Signature signature = stmt.getSignature();
        if (stmt.getResultSet() == null) {
            Iterable<Object> iterable = this._createIterable(h, signature, null, null);
            iterator = iterable.iterator();
            stmt.setResultSet(iterator);
        } else {
            iterator = stmt.getResultSet();
        }
        List rows = MetaImpl.collect((Meta.CursorFactory)signature.cursorFactory, LimitIterator.of(iterator, fetchMaxRowCount), new ArrayList());
        boolean done = fetchMaxRowCount == 0 || rows.size() < fetchMaxRowCount;
        List rows1 = rows;
        return new Meta.Frame(offset, done, (Iterable)rows1);
    }

    public Meta.ExecuteResult execute(Meta.StatementHandle h, List<TypedValue> parameterValues, long maxRowCount) throws NoSuchStatementException {
        return this.execute(h, parameterValues, Ints.saturatedCast((long)maxRowCount));
    }

    public Meta.ExecuteResult execute(Meta.StatementHandle h, List<TypedValue> parameterValues, int maxRowsInFirstFrame) throws NoSuchStatementException {
        Meta.MetaResultSet metaResultSet;
        CalciteConnectionImpl calciteConnection = this.getConnection();
        CalciteServerStatement stmt = calciteConnection.server.getStatement(h);
        Meta.Signature signature = stmt.getSignature();
        if (signature.statementType.canUpdate()) {
            Iterable<Object> iterable = this._createIterable(h, signature, parameterValues, null);
            Iterator<Object> iterator = iterable.iterator();
            stmt.setResultSet(iterator);
            metaResultSet = Meta.MetaResultSet.count((String)h.connectionId, (int)h.id, (long)((Number)iterator.next()).intValue());
        } else {
            Meta.Frame frame = new Meta.Frame(0L, false, Collections.emptyList());
            metaResultSet = Meta.MetaResultSet.create((String)h.connectionId, (int)h.id, (boolean)false, (Meta.Signature)signature, (Meta.Frame)frame);
        }
        return new Meta.ExecuteResult((List)ImmutableList.of((Object)metaResultSet));
    }

    public Meta.ExecuteBatchResult executeBatch(Meta.StatementHandle h, List<List<TypedValue>> parameterValueLists) throws NoSuchStatementException {
        ArrayList<Long> updateCounts = new ArrayList<Long>();
        for (List<TypedValue> parameterValueList : parameterValueLists) {
            Meta.ExecuteResult executeResult = this.execute(h, parameterValueList, -1);
            long updateCount = executeResult.resultSets.size() == 1 ? ((Meta.MetaResultSet)executeResult.resultSets.get((int)0)).updateCount : -1L;
            updateCounts.add(updateCount);
        }
        return new Meta.ExecuteBatchResult(Longs.toArray(updateCounts));
    }

    public Meta.ExecuteBatchResult prepareAndExecuteBatch(final Meta.StatementHandle h, List<String> sqlCommands) throws NoSuchStatementException {
        CalciteConnectionImpl calciteConnection = this.getConnection();
        final CalciteServerStatement statement = calciteConnection.server.getStatement(h);
        final ArrayList updateCounts = new ArrayList();
        Meta.PrepareCallback callback = new Meta.PrepareCallback(){
            long updateCount;
            Meta.Signature signature;

            public Object getMonitor() {
                return statement;
            }

            public void clear() throws SQLException {
            }

            public void assign(Meta.Signature signature, Meta.Frame firstFrame, long updateCount) throws SQLException {
                this.signature = signature;
                this.updateCount = updateCount;
            }

            public void execute() throws SQLException {
                if (this.signature.statementType.canUpdate()) {
                    Iterable<Object> iterable = CalciteMetaImpl.this._createIterable(h, this.signature, (List<TypedValue>)ImmutableList.of(), null);
                    Iterator<Object> iterator = iterable.iterator();
                    this.updateCount = ((Number)iterator.next()).longValue();
                }
                updateCounts.add(this.updateCount);
            }
        };
        for (String sqlCommand : sqlCommands) {
            Util.discard(this.prepareAndExecute(h, sqlCommand, -1L, -1, callback));
        }
        return new Meta.ExecuteBatchResult(Longs.toArray(updateCounts));
    }

    @VisibleForTesting
    public static DataContext createDataContext(CalciteConnection connection) {
        return ((CalciteConnectionImpl)connection).createDataContext((Map<String, Object>)ImmutableMap.of());
    }

    @VisibleForTesting
    public static CalciteConnection connect(CalciteSchema schema, JavaTypeFactory typeFactory) {
        return DRIVER.connect(schema, typeFactory);
    }

    public boolean syncResults(Meta.StatementHandle h, QueryState state, long offset) throws NoSuchStatementException {
        throw new UnsupportedOperationException();
    }

    public void commit(Meta.ConnectionHandle ch) {
        throw new UnsupportedOperationException();
    }

    public void rollback(Meta.ConnectionHandle ch) {
        throw new UnsupportedOperationException();
    }

    private static class LimitIterator<E>
    implements Iterator<E> {
        private final Iterator<E> iterator;
        private final long limit;
        int i = 0;

        private LimitIterator(Iterator<E> iterator, long limit) {
            this.iterator = iterator;
            this.limit = limit;
        }

        static <E> Iterator<E> of(Iterator<E> iterator, long limit) {
            if (limit <= 0L) {
                return iterator;
            }
            return new LimitIterator<E>(iterator, limit);
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext() && (long)this.i < this.limit;
        }

        @Override
        public E next() {
            ++this.i;
            return this.iterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static abstract class MetadataTable<E>
    extends AbstractQueryableTable {
        public MetadataTable(Class<E> clazz) {
            super(clazz);
        }

        @Override
        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return ((JavaTypeFactory)typeFactory).createType(this.elementType);
        }

        @Override
        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.SYSTEM_TABLE;
        }

        @Override
        public Class<E> getElementType() {
            return (Class)this.elementType;
        }

        protected abstract Enumerator<E> enumerator(CalciteMetaImpl var1);

        @Override
        public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
            return new AbstractTableQueryable<T>(queryProvider, schema, this, tableName){

                public Enumerator<T> enumerator() {
                    return MetadataTable.this.enumerator(((CalciteConnectionImpl)this.queryProvider).meta());
                }
            };
        }
    }

    private static class CalciteMetaSchema
    extends MetaImpl.MetaSchema {
        private final CalciteSchema calciteSchema;

        public CalciteMetaSchema(CalciteSchema calciteSchema, String tableCatalog, String tableSchem) {
            super(tableCatalog, tableSchem);
            this.calciteSchema = calciteSchema;
        }
    }

    private static class CalciteMetaTable
    extends MetaImpl.MetaTable {
        private final Table calciteTable;

        public CalciteMetaTable(Table calciteTable, String tableCat, String tableSchem, String tableName) {
            super(tableCat, tableSchem, tableName, calciteTable.getJdbcTableType().name());
            this.calciteTable = (Table)Preconditions.checkNotNull((Object)calciteTable);
        }
    }
}

