/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.logical;

import com.google.common.base.Supplier;
import java.util.List;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.metadata.RelMdCollation;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.Util;

public final class LogicalProject
extends Project {
    public LogicalProject(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<? extends RexNode> projects, RelDataType rowType) {
        super(cluster, traitSet, input, projects, rowType);
        assert (traitSet.containsIfApplicable(Convention.NONE));
    }

    @Deprecated
    public LogicalProject(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<? extends RexNode> projects, RelDataType rowType, int flags) {
        this(cluster, traitSet, input, projects, rowType);
        Util.discard(flags);
    }

    @Deprecated
    public LogicalProject(RelOptCluster cluster, RelNode input, List<RexNode> projects, List<String> fieldNames, int flags) {
        this(cluster, cluster.traitSetOf((RelTrait)RelCollations.EMPTY), input, projects, RexUtil.createStructType(cluster.getTypeFactory(), projects, fieldNames));
        Util.discard(flags);
    }

    public LogicalProject(RelInput input) {
        super(input);
    }

    public static LogicalProject create(RelNode input, List<? extends RexNode> projects, List<String> fieldNames) {
        RelOptCluster cluster = input.getCluster();
        List<String> fieldNames2 = fieldNames == null ? null : SqlValidatorUtil.uniquify(fieldNames, SqlValidatorUtil.F_SUGGESTER);
        RelDataType rowType = RexUtil.createStructType(cluster.getTypeFactory(), projects, fieldNames2);
        return LogicalProject.create(input, projects, rowType);
    }

    public static LogicalProject create(final RelNode input, final List<? extends RexNode> projects, RelDataType rowType) {
        RelOptCluster cluster = input.getCluster();
        final RelMetadataQuery mq = RelMetadataQuery.instance();
        RelTraitSet traitSet = cluster.traitSet().replace(Convention.NONE).replaceIfs(RelCollationTraitDef.INSTANCE, new Supplier<List<RelCollation>>(){

            public List<RelCollation> get() {
                return RelMdCollation.project(mq, input, projects);
            }
        });
        return new LogicalProject(cluster, traitSet, input, projects, rowType);
    }

    @Override
    public LogicalProject copy(RelTraitSet traitSet, RelNode input, List<RexNode> projects, RelDataType rowType) {
        return new LogicalProject(this.getCluster(), traitSet, input, projects, rowType);
    }

    @Override
    public RelNode accept(RelShuttle shuttle) {
        return shuttle.visit(this);
    }
}

