/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.type;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.type.DynamicRecordType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;

public class RelDataTypeHolder {
    List<RelDataTypeField> fields = new ArrayList<RelDataTypeField>();
    private RelDataTypeFactory typeFactory;

    public List<RelDataTypeField> getFieldList(RelDataTypeFactory typeFactory) {
        return this.fields;
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public Pair<RelDataTypeField, Boolean> getFieldOrInsert(RelDataTypeFactory typeFactory, String fieldName, boolean caseSensitive) {
        for (RelDataTypeField f : this.fields) {
            if (!Util.matches(caseSensitive, f.getName(), fieldName)) continue;
            return Pair.of(f, false);
        }
        SqlTypeName typeName = DynamicRecordType.isDynamicStarColName(fieldName) ? SqlTypeName.DYNAMIC_STAR : SqlTypeName.ANY;
        RelDataTypeFieldImpl newField = new RelDataTypeFieldImpl(fieldName, this.fields.size(), typeFactory.createTypeWithNullability(typeFactory.createSqlType(typeName), true));
        this.fields.add(newField);
        return Pair.of(newField, true);
    }

    public List<String> getFieldNames() {
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (RelDataTypeField f : this.fields) {
            fieldNames.add(f.getName());
        }
        return fieldNames;
    }

    public void setRelDataTypeFactory(RelDataTypeFactory typeFactory) {
        this.typeFactory = typeFactory;
    }
}

